/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.ui;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SourceEditorConfigurationServlet
extends HttpServlet {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final UserAccessor userAccessor;
    private ToolsHelper toolsHelper;

    public SourceEditorConfigurationServlet(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport UserManager userManager, @ConfluenceImport LoginUriProvider loginUriProvider, @ConfluenceImport TemplateRenderer renderer, ToolsHelper toolsHelper) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.toolsHelper = toolsHelper;
        this.userAccessor = userAccessor;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            String baseUrl = this.toolsHelper.getBaseUrl();
            response.sendRedirect(baseUrl);
        }
        response.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isLicenseIsValid", this.isLicenseIsValid());
        params.put("isReadOnly", this.toolsHelper.isReadOnly());
        params.put("groups", this.getConfluenceGroups());
        params.put("baseUrl", this.toolsHelper.getBaseUrl());
        params.put("tokenSecureMode", this.toolsHelper.getTokenConfigurationSecureMode());
        params.put("isSensitiveCustomer", this.isLicenseIsValid() ? this.toolsHelper.isSensitiveCustomer() : false);
        this.renderer.render("templates/extender-sourceEditor.vm", params, (Writer)response.getWriter());
    }

    private List<String> getConfluenceGroups() {
        ArrayList<String> groupsArray = new ArrayList<String>();
        Pager groups = this.userAccessor.getGroups();
        for (Group group : groups) {
            groupsArray.add(group.getName());
        }
        return groupsArray;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String baseUrl = this.toolsHelper.getBaseUrl();
        response.sendRedirect(baseUrl);
    }

    public boolean isLicenseIsValid() {
        return this.toolsHelper.isLicenseIsValid();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

