/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import com.itlab.confluence.plugins.restextender.helper.RequestWrapper;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTokens
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FilterTokens.class);
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    private final ToolsHelper toolsHelper;
    private final UserAccessor userAccessor;

    @Inject
    public FilterTokens(ToolsHelper toolsHelper, @ConfluenceImport UserAccessor userAccessor) {
        this.toolsHelper = toolsHelper;
        this.userAccessor = userAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public List<User> findUserByEmail(String email) {
        List<Object> userList = new ArrayList<User>();
        try {
            userList = this.userAccessor.findUsersAsList((Query)new EmailTermQuery(email));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userList;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<String, Object> extenderParams = new HashMap<String, Object>(){
            {
                this.put("useTokenForUser", false);
                this.put("confluenceUser", null);
                this.put("userData", "");
            }
        };
        boolean useTokenForUser = false;
        RequestWrapper httpRequest = new RequestWrapper((HttpServletRequest)request);
        if (httpRequest.getRemoteUser() == null) {
            String authHeader = httpRequest.getHeader("Authorization");
            String restUrl = httpRequest.getRequestURI();
            String accessTypeConfig = this.toolsHelper.getTokensAccessType();
            String authHeaderType = "";
            if (log.isDebugEnabled()) {
                log.debug("[Token] accessType: " + accessTypeConfig);
                log.debug("[Token] authHeader: " + authHeader);
            }
            boolean runTokenVerification = false;
            boolean useBasicAuth = true;
            if (authHeader != null && !authHeader.equals("") && authHeader.split(" ").length > 1) {
                authHeaderType = authHeader.split(" ")[0];
                if (authHeaderType.equalsIgnoreCase("basic") && (accessTypeConfig.equals("all") || accessTypeConfig.equals("basic"))) {
                    runTokenVerification = true;
                } else if (authHeaderType.equalsIgnoreCase("bearer") && (accessTypeConfig.equals("all") || accessTypeConfig.equals("bearer"))) {
                    runTokenVerification = true;
                    useBasicAuth = false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("[Token] authHeaderType: " + authHeaderType);
                log.debug("[Token] runTokenVerification: " + runTokenVerification);
                log.debug("[Token] useBasicAuth: " + useBasicAuth);
            }
            if (runTokenVerification && !useBasicAuth) {
                String tokenString = authHeader.split(" ")[1];
                if (this.isCorrectConfiguration(restUrl)) {
                    extenderParams = this.isUseTokenForUser(httpRequest, tokenString, restUrl, extenderParams, false);
                }
            }
            if (runTokenVerification && useBasicAuth) {
                String decodeAuthHeader;
                String base64authHeader;
                block30: {
                    base64authHeader = authHeader.split(" ")[1];
                    decodeAuthHeader = "";
                    try {
                        decodeAuthHeader = new String(Base64.getDecoder().decode(base64authHeader));
                    }
                    catch (Exception ex) {
                        if (!log.isDebugEnabled()) break block30;
                        log.debug("decodeAuthHeader Exception -> Basic Auth - Base64 -> String :: " + base64authHeader);
                    }
                }
                if (decodeAuthHeader != null && !decodeAuthHeader.equals("") && decodeAuthHeader.split(":").length >= 2) {
                    extenderParams.put("userData", decodeAuthHeader.split(":")[0]);
                    String tokenString = decodeAuthHeader.split(":")[1];
                    if (log.isDebugEnabled()) {
                        log.debug("[Token] authHeader " + authHeader);
                        log.debug("[Token] base64authHeader " + base64authHeader);
                        log.debug("[Token] decodeAuthHeader " + decodeAuthHeader);
                        log.debug("[Token] userData " + extenderParams.get("userData"));
                        log.debug("[Token] tokenString " + tokenString);
                        log.debug("[Token] restUrl " + restUrl);
                    }
                    boolean checkUserByEmail = false;
                    if (this.userAccessor.getUserByName(extenderParams.get("userData").toString()) == null && extenderParams.get("userData").toString().contains("@")) {
                        checkUserByEmail = true;
                    }
                    if (checkUserByEmail) {
                        List<User> result = this.findUserByEmail(extenderParams.get("userData").toString());
                        if (log.isDebugEnabled()) {
                            log.debug("result " + result.toString());
                        }
                        for (User user : result) {
                            if (log.isDebugEnabled()) {
                                log.debug("check user '" + user.getEmail() + "'");
                            }
                            if (!user.getEmail().equalsIgnoreCase(extenderParams.get("userData").toString())) continue;
                            if (log.isDebugEnabled()) {
                                log.debug("found user '" + user.getName() + "' '" + user.getEmail() + "'");
                            }
                            extenderParams.put("confluenceUser", this.userAccessor.getUserByName(user.getName()));
                        }
                    } else {
                        extenderParams.put("confluenceUser", this.userAccessor.getUserByName(extenderParams.get("userData").toString()));
                    }
                    if (extenderParams.get("confluenceUser") == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("RestAPI @tokens - confluenceUser does not exist " + extenderParams.get("userData"));
                        }
                    } else if (this.isCorrectConfiguration(restUrl)) {
                        extenderParams = this.isUseTokenForUser(httpRequest, tokenString, restUrl, extenderParams, true);
                    }
                }
            }
            useTokenForUser = (Boolean)extenderParams.get("useTokenForUser");
            ConfluenceUser confluenceUser = (ConfluenceUser)extenderParams.get("confluenceUser");
            String userData = (String)extenderParams.get("userData");
            if (useTokenForUser) {
                ConfluenceUserPrincipal userPrincipal = new ConfluenceUserPrincipal(confluenceUser);
                HttpSession session = httpRequest.getSession(true);
                session.setAttribute("samlNameID", (Object)userData);
                session.setAttribute("seraph_defaultauthenticator_user", (Object)userPrincipal);
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                if (log.isDebugEnabled()) {
                    log.debug("[Token] samlNameID :: " + userData);
                    log.debug("[Token] seraph_defaultauthenticator_user name :: " + userPrincipal.getName());
                    log.debug("[Token] seraph_defaultauthenticator_user key :: " + userPrincipal.getUserKey());
                    log.debug("[Token] request :: " + httpRequest.getAttribute("os_authstatus"));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("request :: " + httpRequest.getAttribute("os_authstatus"));
        }
        if (useTokenForUser) {
            chain.doFilter((ServletRequest)new RemoveAuthHeaderRequestWrapper((HttpServletRequest)httpRequest), response);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    private boolean isCorrectConfiguration(String restUrl) {
        return this.toolsHelper.getTokensConfig().equalsIgnoreCase("limit") && restUrl.toLowerCase().contains("rest/extender/1.0") || !this.toolsHelper.getTokensConfig().equalsIgnoreCase("limit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> isUseTokenForUser(RequestWrapper httpRequest, String tokenString, String restUrl, Map<String, Object> extenderParams, boolean useBasicAuth) throws IOException {
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        if (tokens.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("[Token] RestAPI @tokens - no tokens");
            }
        } else {
            String restMethod = httpRequest.getMethod();
            Map requestParameterMap = httpRequest.getParameterMap();
            StringBuilder jsonData = new StringBuilder();
            try (BufferedReader reader = httpRequest.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    jsonData.append(line.trim());
                }
            }
            ConfluenceUser confluenceUser = null;
            for (Token token : tokens) {
                boolean checkToken = false;
                if (!useBasicAuth) {
                    if (log.isDebugEnabled()) {
                        log.debug("[Token][Bearer] Token UserKey: " + token.getUserKey());
                    }
                    if (token.getToken().equals(tokenString) && token.getUserKey() != null && !token.getUserKey().equals("") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
                        extenderParams.put("confluenceUser", this.toolsHelper.getConfluenceUserByKey(token.getUserKey()));
                        checkToken = true;
                    }
                } else {
                    confluenceUser = (ConfluenceUser)extenderParams.get("confluenceUser");
                    checkToken = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[Token] checkToken: " + checkToken);
                    log.debug("[Token] tokenString: " + tokenString);
                    log.debug("[Token] confluenceUser: " + confluenceUser == null ? "null" : confluenceUser.toString());
                    log.debug("[Token] restUrl: " + restUrl);
                    log.debug("[Token] restMethod: " + restMethod);
                    log.debug("[Token] restUrl: " + restUrl);
                    log.debug("[Token] jsonData: " + jsonData.toString());
                }
                if (!checkToken || !this.checkToken(token, tokenString, confluenceUser.getKey().getStringValue(), restUrl, restMethod, requestParameterMap, jsonData.toString())) continue;
                extenderParams.put("useTokenForUser", true);
                if (tokenContainer.getCollectUsageDetails()) {
                    this.collectUsageDetails(httpRequest, token, tokenContainer);
                }
                if (!tokenContainer.getAddAuditRecord()) break;
                this.addAuditRecord(httpRequest, restUrl, token, confluenceUser);
                break;
            }
            if (!this.toolsHelper.isLicenseIsValid()) {
                extenderParams.put("useTokenForUser", false);
            }
        }
        return extenderParams;
    }

    private void addAuditRecord(RequestWrapper httpRequest, String restUrl, Token token, ConfluenceUser confluenceUser) {
        String requestMethod = httpRequest.getMethod().toLowerCase();
        UserProfile currentUserProfile = this.toolsHelper.getUserProfile(confluenceUser.getKey().getStringValue());
        com.atlassian.confluence.api.model.people.User author = this.toolsHelper.getPeopleUser(currentUserProfile);
        String objectType = this.toolsHelper.getUntransformedRawText("audit.logging.affected.object.user");
        AffectedObject targetAffectedUser = AffectedObject.builder().name(confluenceUser.getName()).objectType(objectType).build();
        HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
        associatedObjects.add(targetAffectedUser);
        ArrayList<Map<String, String>> changedValueList = new ArrayList<Map<String, String>>();
        HashMap<String, String> changedValue = new HashMap<String, String>();
        changedValue.put("name", "Url");
        changedValue.put("oldValue", "");
        changedValue.put("newValue", "[" + requestMethod.toUpperCase() + "] " + restUrl);
        changedValueList.add(changedValue);
        String jsonBody = this.toolsHelper.getJsonBodyForAuditRecord((HttpServletRequest)httpRequest);
        if (jsonBody != null && !jsonBody.equals("")) {
            changedValue = new HashMap();
            changedValue.put("name", "Payload");
            changedValue.put("oldValue", "");
            changedValue.put("newValue", jsonBody);
            changedValueList.add(changedValue);
        }
        this.toolsHelper.addAuditRecord(author, "Token \"" + token.getLabel() + "\" was used", "System", "Token \"" + token.getLabel() + "\" was used", true, targetAffectedUser, null, changedValueList);
    }

    private void collectUsageDetails(RequestWrapper httpRequest, Token token, TokenContainer tokenContainer) {
        token.setLastUsed(new Date());
        token.setIp(FilterTokens.getClientIpAddress((HttpServletRequest)httpRequest));
        token.addCounter();
        this.toolsHelper.saveTokens(tokenContainer);
    }

    private boolean matchesRegexp(Token token, String restUrl, String restMethod, Map<String, String[]> requestParameterMap, String jsonData) {
        String limitTo = token.getLimitTo();
        if (limitTo == null || limitTo.equals("")) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("restUrl " + restUrl);
            log.debug("limitTo " + limitTo);
        }
        for (String limitUrlRegexp : limitTo.split("<br>")) {
            ArrayList<String> jsonDatas;
            ArrayList<String> queryParams;
            String additionalData;
            String methodFromUrl;
            boolean queryOrJsonDataPass;
            boolean checkMethod;
            block49: {
                if (log.isDebugEnabled()) {
                    log.debug("for - split " + limitUrlRegexp);
                }
                checkMethod = false;
                queryOrJsonDataPass = true;
                methodFromUrl = "";
                additionalData = "";
                queryParams = new ArrayList<String>();
                jsonDatas = new ArrayList<String>();
                if (log.isDebugEnabled()) {
                    log.debug("limitUrlRegexp in " + limitUrlRegexp);
                }
                if (limitUrlRegexp.toLowerCase().startsWith("[post]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(6);
                    checkMethod = true;
                    methodFromUrl = "post";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[head]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(6);
                    checkMethod = true;
                    methodFromUrl = "head";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[get]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(5);
                    checkMethod = true;
                    methodFromUrl = "get";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[put]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(5);
                    checkMethod = true;
                    methodFromUrl = "put";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[patch]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(7);
                    checkMethod = true;
                    methodFromUrl = "patch";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[trace]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(7);
                    checkMethod = true;
                    methodFromUrl = "trace";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[delete]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(8);
                    checkMethod = true;
                    methodFromUrl = "delete";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[options]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(9);
                    checkMethod = true;
                    methodFromUrl = "options";
                } else if (limitUrlRegexp.toLowerCase().startsWith("[connect]")) {
                    limitUrlRegexp = limitUrlRegexp.substring(9);
                    checkMethod = true;
                    methodFromUrl = "connect";
                }
                if (limitUrlRegexp.toLowerCase().contains("[queryparam") || limitUrlRegexp.toLowerCase().contains("[jsondata")) {
                    try {
                        additionalData = limitUrlRegexp.substring(limitUrlRegexp.indexOf("["));
                        limitUrlRegexp = limitUrlRegexp.substring(0, limitUrlRegexp.indexOf("["));
                        for (String definition : additionalData.split("]")) {
                            if (definition.toLowerCase().startsWith("[queryparam")) {
                                queryParams.add(definition.substring(13));
                                continue;
                            }
                            if (!definition.toLowerCase().startsWith("[jsondata")) continue;
                            jsonDatas.add(definition.substring(11));
                        }
                    }
                    catch (Exception ex) {
                        if (!log.isDebugEnabled()) break block49;
                        log.debug("Exception :: limitUrlRegexp = " + limitUrlRegexp);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("checkMethod: " + checkMethod);
                log.debug("limitUrlRegexp: " + limitUrlRegexp);
                log.debug("additionalData: " + additionalData);
                log.debug("queryParams: " + queryParams);
                log.debug("requestJson: " + jsonData);
                log.debug("jsonData's: " + jsonDatas);
            }
            if (!queryParams.isEmpty()) {
                for (String queryParam : queryParams) {
                    try {
                        String paramName = queryParam.split("==")[0];
                        String paramValueRegexp = this.toolsHelper.unescapeHtml(queryParam.split("==")[1]);
                        if (log.isDebugEnabled()) {
                            log.debug("paramName: " + paramName);
                            log.debug("paramValueRegexp: " + paramValueRegexp);
                        }
                        if (requestParameterMap.get(paramName) != null && requestParameterMap.get(paramName).length > 0) {
                            for (String paramValues : requestParameterMap.get(paramName)) {
                                if (paramValues.matches(paramValueRegexp)) continue;
                                queryOrJsonDataPass = false;
                            }
                        } else {
                            queryOrJsonDataPass = false;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("restUrl.contains(\"rest/api/content\"): " + restUrl.contains("rest/api/content"));
                            log.debug("restUrl.contains(\"rest/api/latest/content\"): " + restUrl.contains("rest/api/latest/content"));
                            log.debug("restUrl: " + restUrl);
                            log.debug("limitUrlRegexp: " + limitUrlRegexp);
                            log.debug("restUrl.matches(limitUrlRegexp): " + restUrl.matches(limitUrlRegexp));
                            log.debug("paramName.equalsIgnoreCase(\"spaceKey\"): " + paramName.equalsIgnoreCase("spaceKey"));
                            log.debug("queryOrJsonDataPass: " + queryOrJsonDataPass);
                        }
                        if (!restUrl.contains("rest/api/content") && !restUrl.contains("rest/api/latest/content") || !restUrl.matches(limitUrlRegexp) || !paramName.equalsIgnoreCase("spaceKey") || !queryOrJsonDataPass) continue;
                        queryOrJsonDataPass = false;
                        if (restMethod.equalsIgnoreCase("get") && (restUrl.endsWith("rest/api/content") || restUrl.endsWith("rest/api/content/") || restUrl.endsWith("rest/api/latest/content") || restUrl.endsWith("rest/api/latest/content/"))) {
                            queryOrJsonDataPass = true;
                            continue;
                        }
                        String contentId = restUrl.replaceAll(".*/content/", "");
                        contentId = contentId.contains("/") ? contentId.substring(0, contentId.indexOf("/")) : contentId;
                        Page page = this.toolsHelper.getPageFormPageDao(Long.parseLong(contentId));
                        BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(Long.parseLong(contentId));
                        if (page != null && page.getSpaceKey().matches(paramValueRegexp)) {
                            if (log.isDebugEnabled()) {
                                log.debug("pageSpaceKey: " + page.getSpaceKey());
                            }
                            queryOrJsonDataPass = true;
                            continue;
                        }
                        if (blogPost == null || !blogPost.getSpaceKey().matches(paramValueRegexp)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("blogPostSpaceKey: " + blogPost.getSpaceKey());
                        }
                        queryOrJsonDataPass = true;
                    }
                    catch (Exception ex) {
                        if (log.isDebugEnabled()) {
                            log.debug("Exception :: queryParam = " + queryParam);
                        }
                        queryOrJsonDataPass = false;
                    }
                }
            }
            if (!jsonDatas.isEmpty() && jsonData != null && !jsonData.equals("")) {
                for (String jsonParam : jsonDatas) {
                    try {
                        JSONObject jsonObject = new JSONObject(jsonData);
                        String nodeName = jsonParam.split("==")[0];
                        String nodeValueRegexp = this.toolsHelper.unescapeHtml(jsonParam.split("==")[1]);
                        if (log.isDebugEnabled()) {
                            log.debug("nodeName: " + nodeName);
                            log.debug("nodeValueRegexp: " + nodeValueRegexp);
                            log.debug("jsonObject.get(nodeName): " + jsonObject.get(nodeName));
                        }
                        if (jsonObject.get(nodeName).toString().matches(nodeValueRegexp)) continue;
                        queryOrJsonDataPass = false;
                    }
                    catch (Exception ex) {
                        if (log.isDebugEnabled()) {
                            log.debug("Exception :: jsonParam = " + jsonData);
                        }
                        queryOrJsonDataPass = false;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("queryOrJsonDataPass: " + queryOrJsonDataPass);
            }
            if ((!checkMethod || !methodFromUrl.equalsIgnoreCase(restMethod) || !queryOrJsonDataPass || !restUrl.matches(limitUrlRegexp)) && (checkMethod || !queryOrJsonDataPass || !restUrl.matches(limitUrlRegexp))) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidDate(Token token) {
        if (token.getValidUntil() == null) {
            return true;
        }
        Date validUntil = token.getValidUntil();
        Date now = new Date();
        if (log.isDebugEnabled()) {
            log.debug(" validUntil " + validUntil.getTime());
            log.debug(" now " + now.getTime());
        }
        return now.getTime() <= validUntil.getTime();
    }

    private boolean userWithTokenExist(Token token, String tokenString, String userKey) {
        if (token.getToken().equals(tokenString) && token.getUserKey().equals(userKey)) {
            return true;
        }
        return token.getToken().equals(tokenString) && token.getUserKey().equals("") && token.getUser().equals("");
    }

    public void destroy() {
    }

    private boolean checkToken(Token token, String tokenString, String userKey, String restUrl, String restMethod, Map<String, String[]> requestParameterMap, String jsonData) {
        if (log.isDebugEnabled()) {
            log.debug("token check      restUrl: " + restUrl);
            log.debug("token check   restMethod: " + restMethod);
            for (Map.Entry<String, String[]> entry : requestParameterMap.entrySet()) {
                log.debug("token check param :: " + entry.getKey() + ":" + entry.getValue());
            }
            log.debug("token check 1 " + this.userWithTokenExist(token, tokenString, userKey));
            log.debug("token check 2 " + this.hasValidDate(token));
            log.debug("token check 3 " + this.matchesRegexp(token, restUrl, restMethod, requestParameterMap, jsonData));
        }
        if (this.userWithTokenExist(token, tokenString, userKey) && this.hasValidDate(token) && this.matchesRegexp(token, restUrl, restMethod, requestParameterMap, jsonData)) {
            if (log.isDebugEnabled()) {
                log.debug("RestAPI @tokens - token exist BASICAUTH:" + userKey + ":" + tokenString + " TOKEN:" + token.getUser() + ":" + token.getToken());
            }
            return true;
        }
        return false;
    }

    private static String getClientIpAddress(HttpServletRequest request) {
        for (String header : IP_HEADER_CANDIDATES) {
            String ip = request.getHeader(header);
            if (log.isDebugEnabled()) {
                log.debug("header:" + header);
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    class RemoveAuthHeaderRequestWrapper
    extends HttpServletRequestWrapper {
        public RemoveAuthHeaderRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            return "Authorization".equalsIgnoreCase(name) && !this.isWebSudoCheck() ? null : request.getHeader(name);
        }

        public Object getAttribute(String name) {
            return "os_authstatus".equals(name) ? "success" : super.getAttribute(name);
        }

        private boolean isWebSudoCheck() {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            return Arrays.stream(stacktrace).map(StackTraceElement::getMethodName).anyMatch("shouldEnforceWebSudoProtection"::equals);
        }
    }
}

