/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.license;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.LicenseHelper;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/license")
public class ApplicationLicenseTypeRestApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLicenseTypeRestApi.class);
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    private LicenseHelper licenseHelper;
    protected static final String EXT_L_KEY = "com.itlab.confluence.plugins.extender.server.license";

    public ApplicationLicenseTypeRestApi(ToolsHelper toolsHelper, LicenseHelper licenseHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        this.licenseHelper = licenseHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/type")
    public Response getLicenseType(@Context HttpServletRequest request) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("isDataCenter", this.toolsHelper.isLicensedForDataCenter());
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/key")
    public Response updateKey(String json, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(json);
        String extenderKey = "";
        if (jsonObject.has("extenderKey")) {
            extenderKey = jsonObject.getString("extenderKey").trim();
        }
        if (log.isDebugEnabled()) {
            log.debug("update key: " + extenderKey);
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), EXT_L_KEY, (Object)extenderKey);
        if (log.isDebugEnabled()) {
            log.debug("update key - license: " + this.licenseHelper.getLicenseDetails());
        }
        return Response.ok().build();
    }
}

