/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.source;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.StorageFormatCleaner;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.editor.EditorConverter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xml.XhtmlEntityResolver;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Path(value="/convert")
public class FormatConversionResource {
    private static final Logger log = LoggerFactory.getLogger(FormatConversionResource.class);
    private final Renderer editRenderer = (Renderer)ContainerManager.getComponent((String)"editRenderer");
    private final EditorConverter editConverter = (EditorConverter)ComponentLocator.getComponent(EditorConverter.class);
    private final StorageFormatCleaner storageFormatCleaner;
    private final PageTemplateManager pageTemplateManager;
    private final PermissionManager permissionManager;
    private final ToolsHelper toolsHelper;

    public FormatConversionResource(ToolsHelper toolsHelper, @ConfluenceImport StorageFormatCleaner storageFormatCleaner, @ConfluenceImport PermissionManager permissionManager, @ConfluenceImport PageTemplateManager pageTemplateManager) {
        this.storageFormatCleaner = storageFormatCleaner;
        this.permissionManager = permissionManager;
        this.toolsHelper = toolsHelper;
        this.pageTemplateManager = pageTemplateManager;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/toStorageFormat")
    public Response getStorageFormat(String jsonString) throws Exception {
        String editorFormat;
        JSONObject jsonObject;
        if (!this.hasAccess()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (log.isDebugEnabled()) {
            log.debug("getStorageFormat jsonString : " + jsonString);
        }
        String pageId = (jsonObject = new JSONObject(jsonString)).has("pageId") ? jsonObject.getString("pageId") : null;
        String blogId = jsonObject.has("blogId") ? jsonObject.getString("blogId") : null;
        String templateId = jsonObject.has("templateId") ? jsonObject.getString("templateId") : null;
        String string = editorFormat = jsonObject.has("editorFormat") ? jsonObject.getString("editorFormat").replace("@@quot@@", "\"").replace("@@br@@", "\n") : null;
        if (log.isDebugEnabled()) {
            log.debug("getStorageFormat pageId : " + this.getNotNullValue(pageId));
            log.debug("getStorageFormat blogId : " + this.getNotNullValue(blogId));
            log.debug("getStorageFormat templateId : " + this.getNotNullValue(templateId));
            log.debug("getStorageFormat editorFormat : " + this.getNotNullValue(editorFormat));
        }
        ContentEntityObject contentEntityObject = null;
        if (templateId == null) {
            contentEntityObject = this.getContentEntityObject(pageId, blogId);
            if (this.showContentPermissionError(pageId, blogId, contentEntityObject)) {
                return this.contentNotFoundOrPermissionViolation("page");
            }
        } else {
            PageTemplate pageTemplate = this.pageTemplateManager.getPageTemplate(Long.parseLong(templateId));
            if (this.showTemplatePermissionError(templateId, pageTemplate)) {
                return this.contentNotFoundOrPermissionViolation("template");
            }
        }
        ConversionContext conversionContext = this.getConversionContext(contentEntityObject);
        String storageFormat = this.convertContentToStorageFormat(editorFormat, conversionContext);
        storageFormat = this.storageFormatCleaner.cleanQuietly(storageFormat);
        storageFormat = this.makePretty(storageFormat);
        response.put("content", storageFormat);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/test")
    public Response test() throws IOException {
        HashMap<String, String> response = new HashMap<String, String>();
        String s1 = "<span/>@@br@@&nbsp; &nbsp; &nbsp; &nbsp; <cicosi";
        s1 = s1.replaceAll(">@@br@@[&nbsp; ]+<", "><");
        response.put("s1", s1);
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/toEditorFormat")
    public Response getEditorFormat(String jsonString) throws IOException {
        Map<String, Object> mapError;
        String storageFormat;
        if (!this.hasAccess()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (log.isDebugEnabled()) {
            log.debug("getEditorFormat jsonString : " + jsonString);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        String pageId = jsonObject.has("pageId") ? jsonObject.getString("pageId") : null;
        String blogId = jsonObject.has("blogId") ? jsonObject.getString("blogId") : null;
        String templateId = jsonObject.has("templateId") ? jsonObject.getString("templateId") : null;
        String string = storageFormat = jsonObject.has("storageFormat") ? jsonObject.getString("storageFormat").replaceAll(">@@br@@[&nbsp; ]+<", "><").replace("@@quot@@", "\"").replace("@@br@@", "\n") : null;
        if (log.isDebugEnabled()) {
            log.debug("getEditorFormat pageId : " + this.getNotNullValue(pageId));
            log.debug("getEditorFormat blogId : " + this.getNotNullValue(blogId));
            log.debug("getEditorFormat templateId : " + this.getNotNullValue(templateId));
            log.debug("getEditorFormat storageFormat : " + this.getNotNullValue(storageFormat));
        }
        if (!(mapError = this.validate(storageFormat)).isEmpty() && mapError.get("message") != null) {
            response.put("message", mapError.get("message"));
            response.put("lineNumber", mapError.get("lineNumber"));
            response.put("columnNumber", mapError.get("columnNumber"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(response).build();
        }
        ContentEntityObject contentEntityObject = null;
        if (templateId == null) {
            contentEntityObject = this.getContentEntityObject(pageId, blogId);
            if (this.showContentPermissionError(pageId, blogId, contentEntityObject)) {
                return this.contentNotFoundOrPermissionViolation("page");
            }
        } else {
            PageTemplate pageTemplate = this.pageTemplateManager.getPageTemplate(Long.parseLong(templateId));
            if (this.showTemplatePermissionError(templateId, pageTemplate)) {
                return this.contentNotFoundOrPermissionViolation("template");
            }
        }
        ConversionContext conversionContext = this.getConversionContext(contentEntityObject);
        storageFormat = StringUtils.replaceEach((String)storageFormat, (String[])new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<storage-format>", "</storage-format>"}, (String[])new String[]{"", "", ""});
        String editorFormat = this.editRenderer.render(storageFormat, conversionContext);
        response.put("content", editorFormat);
        return Response.ok(response).build();
    }

    private boolean showTemplatePermissionError(String templateId, PageTemplate pageTemplate) {
        if (log.isDebugEnabled()) {
            log.debug("showTemplatePermissionError pageTemplate : " + pageTemplate);
        }
        if (templateId.contains("0")) {
            return false;
        }
        if (pageTemplate == null) {
            return true;
        }
        return !(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserHasSpaceViewPermission(pageTemplate.getSpace()) && this.toolsHelper.isCurrentUserHasSpaceCreatePagePermission(pageTemplate.getSpace()) || this.toolsHelper.isCurrentUserIsSpaceAdministrator(pageTemplate.getSpace()));
        {
        }
    }

    private boolean showContentPermissionError(String pageId, String blogId, ContentEntityObject contentEntityObject) {
        if (log.isDebugEnabled()) {
            log.debug("showContentPermissionError pageId : " + this.getNotNullValue(pageId));
            log.debug("showContentPermissionError blogId : " + this.getNotNullValue(blogId));
            log.debug("showContentPermissionError contentEntityObject : " + this.getNotNullValue(contentEntityObject));
            log.debug("showContentPermissionError isNewContent : " + this.isNewContent(pageId, blogId));
        }
        return contentEntityObject == null && !this.isNewContent(pageId, blogId);
    }

    private Response contentNotFoundOrPermissionViolation(String contentType) {
        if (log.isDebugEnabled()) {
            log.debug("contentNotFoundOrPermissionViolation " + contentType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("reason", "We can't find that " + contentType);
        response.put("message", "This could be because:<ul><li>The " + contentType + " doesn't exist.</li><li>The " + contentType + " exists, but you don't have view permission for that space.</li></ul>");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(response).build();
    }

    private boolean isNewContent(String pageId, String blogId) {
        return pageId != null && pageId.equals("0") || blogId != null && blogId.equals("0");
    }

    private ContentEntityObject getContentEntityObject(String pageId, String blogId) {
        Page contentEntityObject = null;
        if (pageId != null) {
            contentEntityObject = this.getPage(pageId);
        } else if (blogId != null) {
            contentEntityObject = this.getBlogPost(blogId);
        }
        return contentEntityObject;
    }

    private BlogPost getBlogPost(String blogId) {
        BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(Long.parseLong(blogId));
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (blogPost != null && this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)blogPost)) {
            return blogPost;
        }
        return null;
    }

    private Page getPage(String pageId) {
        Page page = this.toolsHelper.getPageFormPageDao(Long.parseLong(pageId));
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (page != null && this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page)) {
            return page;
        }
        return null;
    }

    private ConversionContext getConversionContext(ContentEntityObject page) {
        PageContext renderContext = page != null ? page.toPageContext() : new PageContext();
        return new DefaultConversionContext((RenderContext)renderContext);
    }

    private String convertContentToStorageFormat(String wysiwygContent, ConversionContext conversionContext) throws XhtmlException {
        return this.editConverter.convert(wysiwygContent, conversionContext);
    }

    private String makePretty(String storageFormat) throws Exception {
        Document doc = this.getStorageDocument(storageFormat);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        NodeList children = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            transformer.transform(new DOMSource(child), result);
        }
        return writer.toString();
    }

    private Map<String, Object> validate(String storageFormat) {
        HashMap<String, Object> validationError = new HashMap<String, Object>();
        try {
            Document document = this.getStorageDocument(storageFormat);
        }
        catch (SAXParseException e) {
            validationError.put("message", e.getMessage());
            validationError.put("lineNumber", e.getLineNumber());
            validationError.put("columnNumber", e.getColumnNumber());
        }
        catch (Exception e) {
            validationError.put("message", e.getMessage());
        }
        return validationError;
    }

    private String getNotNullValue(Object temp) {
        if (temp == null) {
            return "null";
        }
        return temp.toString();
    }

    private Document getStorageDocument(String storageFormat) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        XhtmlEntityResolver xmlResolver = new XhtmlEntityResolver();
        String entityDTD = "<!ENTITY % HTMLlat1 PUBLIC \"-//W3C//ENTITIES Latin 1 for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-lat1.ent\"> %HTMLlat1;<!ENTITY % HTMLsymbol PUBLIC \"-//W3C//ENTITIES Symbols for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-symbol.ent\"> %HTMLsymbol;<!ENTITY % HTMLspecial PUBLIC \"-//W3C//ENTITIES Special for XHTML//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-special.ent\"> %HTMLspecial;";
        String xmlStorageFormat = "<!DOCTYPE xml [ " + entityDTD + "]><storage-format>" + storageFormat + "</storage-format>";
        if (log.isDebugEnabled()) {
            log.debug("entityDTD : " + entityDTD);
            log.debug("xmlStorageFormat : " + xmlStorageFormat);
        }
        db.setEntityResolver((EntityResolver)xmlResolver);
        InputSource is = new InputSource(new StringReader(xmlStorageFormat));
        return db.parse(is);
    }

    private boolean hasAccess() {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return false;
        }
        return this.toolsHelper.isSourceEditorVisibleForUser();
    }
}

