/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.tokens.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.ConfluenceUser;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tokenTools")
public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);
    private final ToolsHelper toolsHelper;

    public TokenUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/delete")
    public Response clear(String jsonString, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            if (token.getToken().equals(stringToken)) continue;
            if (ToolsHelper.encrypt(token.getToken()).equals(id)) continue;
            newTokens.add(token);
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/{option}")
    public Response setConfig(@PathParam(value="option") String option) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (option.equalsIgnoreCase("limit") || option.equalsIgnoreCase("nolimit")) {
            this.toolsHelper.savedTokensConfig(option.toLowerCase());
        }
        if (option.equalsIgnoreCase("basic") || option.equalsIgnoreCase("bearer") || option.equalsIgnoreCase("all")) {
            this.toolsHelper.setTokensAccessType(option.toLowerCase());
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get")
    public Response getTokens(@Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        boolean tokenConfigurationSecureMode = this.toolsHelper.getTokenConfigurationSecureMode();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        ArrayList arrayTokens = new ArrayList();
        for (Token token : tokens) {
            ConfluenceUser confluenceUser;
            HashMap<String, Object> tokenMap = new HashMap<String, Object>();
            tokenMap.put("dateCreated", token.getDateCreated() == null ? "" : token.getDateCreated());
            tokenMap.put("label", token.getLabel() == null ? "" : token.getLabel());
            tokenMap.put("limitTo", token.getLimitTo() == null ? "" : token.getLimitTo());
            if (!tokenConfigurationSecureMode) {
                tokenMap.put("token", token.getToken() == null ? "" : token.getToken());
            }
            tokenMap.put("id", token.getToken() == null ? "" : ToolsHelper.encrypt(token.getToken()));
            tokenMap.put("user", token.getUser());
            tokenMap.put("userKey", token.getUserKey());
            tokenMap.put("userDisplayName", token.getUserKey());
            if (token.getUserKey() != null && !token.getUserKey().equals("") && !token.getUserKey().equals("not found") && (confluenceUser = this.toolsHelper.getConfluenceUserByKey(token.getUserKey())) != null) {
                tokenMap.put("user", confluenceUser.getName());
                tokenMap.put("userDisplayName", confluenceUser.getFullName());
            }
            tokenMap.put("validUntil", token.getValidUntil() == null ? "" : token.getValidUntil());
            if (tokenContainer.getCollectUsageDetails()) {
                tokenMap.put("ip", token.getIp() == null ? "" : token.getIp());
                tokenMap.put("lastUsed", token.getLastUsed() == null ? "" : token.getLastUsed());
                tokenMap.put("counter", token.getCounter());
            }
            arrayTokens.add(tokenMap);
        }
        if (tokenContainer.getTokens().isEmpty()) {
            response.put("status", "empty");
        } else {
            response.put("status", "ok");
            response.put("tokens", arrayTokens);
        }
        response.put("collectUsageDetails", tokenContainer.getCollectUsageDetails());
        response.put("addAuditRecord", tokenContainer.getAddAuditRecord());
        response.put("tokenAccessType", this.toolsHelper.getTokensAccessType());
        response.put("config", this.toolsHelper.getTokensConfig());
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/edit")
    public Response editToken(String jsonString, @Context HttpServletRequest request) throws JSONException {
        String id;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String stringToken = jsonObject.has("token") ? jsonObject.getString("token") : "";
        String string = id = jsonObject.has("id") ? jsonObject.getString("id") : "";
        if (this.toolsHelper.getTokenConfigurationSecureMode()) {
            if (!jsonObject.has("id") || jsonObject.getString("id").equals("")) {
                return this.toolsHelper.fieldRequired("id");
            }
        } else if (!jsonObject.has("token") || jsonObject.getString("token").equals("")) {
            return this.toolsHelper.fieldRequired("token");
        }
        if (!jsonObject.has("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (Token token : tokenContainer.getTokens()) {
            block15: {
                block14: {
                    if (token.getToken().equals(stringToken)) break block14;
                    if (!ToolsHelper.encrypt(token.getToken()).equals(id)) break block15;
                }
                token.setLabel(jsonObject.getString("label"));
                if (jsonObject.has("limitTo")) {
                    String limitTo = jsonObject.getString("limitTo");
                    if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
                        limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
                    }
                    token.setLimitTo(limitTo);
                }
            }
            newTokens.add(token);
        }
        tokenContainer.setTokens(newTokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/set")
    public Response setTokens(String jsonString, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (jsonObject.has("collectUsageDetails")) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setCollectUsageDetails(jsonObject.getBoolean("collectUsageDetails"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        if (jsonObject.has("addAuditRecord")) {
            TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
            tokenContainer.setAddAuditRecord(jsonObject.getBoolean("addAuditRecord"));
            this.toolsHelper.saveTokens(tokenContainer);
            return Response.ok().build();
        }
        String label = "";
        String userName = "";
        String stringToken = "";
        String daysUntilExpiry = "";
        String limitTo = "";
        if (jsonObject.isNull("label") || jsonObject.getString("label").equals("")) {
            return this.toolsHelper.fieldRequired("label");
        }
        label = jsonObject.getString("label");
        if (!jsonObject.isNull("userName")) {
            userName = jsonObject.getString("userName");
        }
        if (!jsonObject.isNull("limitTo")) {
            limitTo = jsonObject.getString("limitTo");
        }
        if (!jsonObject.isNull("daysUntilExpiry")) {
            daysUntilExpiry = jsonObject.getString("daysUntilExpiry");
        }
        if (!jsonObject.isNull("token")) {
            stringToken = jsonObject.getString("token");
        }
        if (stringToken.equals("")) {
            stringToken = this.generateToken();
        }
        if (!limitTo.equals("") && (limitTo.contains("\\n") || limitTo.contains("\\\\n"))) {
            limitTo = limitTo.replaceAll("\\\\n", "<br>").replaceAll("\\n", "<br>");
        }
        String userKey = "";
        if (userName.equals("")) {
            userKey = "";
        } else {
            ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(userName);
            if (confluenceUser == null) {
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("message", "User '" + userName + "' does not exist");
                return Response.serverError().entity(response).build();
            }
            userKey = confluenceUser.getKey().getStringValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("userKey " + userKey);
            log.debug("userName " + userName);
            log.debug("token " + stringToken);
            log.debug("daysUntilExpiry " + daysUntilExpiry);
            log.debug("limitTo " + limitTo);
        }
        TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
        ArrayList<Token> tokens = tokenContainer.getTokens();
        Date date = null;
        if (this.toolsHelper.isNumeric(daysUntilExpiry)) {
            Calendar now = Calendar.getInstance();
            now.add(5, Integer.parseInt(daysUntilExpiry));
            date = now.getTime();
        }
        Token token = new Token(label, userName, userKey, stringToken, date, limitTo);
        tokens.add(token);
        tokenContainer.setTokens(tokens);
        this.toolsHelper.saveTokens(tokenContainer);
        return Response.ok().build();
    }

    private String generateToken() {
        int length = 32;
        boolean useLetters = true;
        boolean useNumbers = true;
        return RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
    }
}

