/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.avatar;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

@Path(value="/avatar")
public class AvatarRestApi {
    private static final Logger log = Logger.getLogger(AvatarRestApi.class);
    private final UserAccessor userAccessor;
    private ToolsHelper toolsHelper;

    public AvatarRestApi(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.toolsHelper = toolsHelper;
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/image/{userName}")
    @Consumes(value={"multipart/form-data"})
    public Response setAvatarImage(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException, FileUploadException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug((Object)"RESTAPI - set avatar image");
        log.debug((Object)("RESTAPI - userName: " + userName));
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
        if (items.size() != 1) {
            response.put("message", "upload only 1 image");
            return Response.serverError().entity(response).build();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        Attachment userPhotoAttachment = this.prepareAndReturnAttachment(Base64.encodeBase64String((byte[])((FileItem)items.get(0)).get()), confluenceUser);
        this.userAccessor.setUserProfilePicture(confluenceUser, userPhotoAttachment);
        response.put("message", "avatar changed");
        if (log.isDebugEnabled()) {
            response.put("items", items.size());
            response.put("image", Base64.encodeBase64String((byte[])((FileItem)items.get(0)).get()));
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/base64/{userName}")
    public Response getAvatarBase64(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException, IOException {
        String tempBase64;
        String contentType;
        String lastBase64;
        HashMap<String, String> response;
        block6: {
            userName = this.toolsHelper.decodeUrlParam(userName);
            log.debug((Object)"RESTAPI - set avatar base64");
            log.debug((Object)("RESTAPI - userName: " + userName));
            response = new HashMap<String, String>();
            if (!this.toolsHelper.isLicenseIsValid()) {
                return this.toolsHelper.licenseIsInvalid();
            }
            if (!this.toolsHelper.isConfluenceAdministrator()) {
                return this.toolsHelper.permissionViolation();
            }
            if (!this.toolsHelper.isUserExistByName(userName)) {
                return this.toolsHelper.userNotFound(userName);
            }
            User confluenceUser = this.toolsHelper.getUserByName(userName);
            ProfilePictureInfo profilePictureInfo = this.userAccessor.getUserProfilePicture(confluenceUser);
            InputStream inputStream = profilePictureInfo.getBytes();
            lastBase64 = "";
            contentType = "";
            tempBase64 = "";
            try {
                tempBase64 = Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)inputStream));
                contentType = profilePictureInfo.getContentType();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Exception: " + ExceptionUtils.getStackTrace((Throwable)ex)));
            }
        }
        if (tempBase64 != null && contentType != null && !tempBase64.equals("") && !contentType.equals("")) {
            lastBase64 = "data:" + contentType + ";base64," + tempBase64;
        }
        response.put("string", lastBase64);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/base64/{userName}")
    public Response setAvatarBase64(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug((Object)"RESTAPI - set avatar base64");
        log.debug((Object)("RESTAPI - userName: " + userName));
        log.debug((Object)("RESTAPI - userJSON: " + userJSON));
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String base64string = jsonObject.getString("string");
        if (base64string.toLowerCase().startsWith("data:image")) {
            base64string = base64string.substring(base64string.indexOf("base64,") + 7);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        Attachment userPhotoAttachment = this.prepareAndReturnAttachment(base64string, confluenceUser);
        this.userAccessor.setUserProfilePicture(confluenceUser, userPhotoAttachment);
        response.put("message", "avatar changed");
        if (log.isDebugEnabled()) {
            response.put("base64string", base64string);
        }
        return Response.ok(response).build();
    }

    private Attachment prepareAndReturnAttachment(String imageBase64, User user) {
        return this.saveNewAttachment(Base64.decodeBase64((String)imageBase64.replaceAll(System.getProperty("line.separator"), "+")), user);
    }

    private Attachment saveNewAttachment(byte[] imageBytes, User user) {
        AttachmentManager attachmentManager = (AttachmentManager)ComponentLocator.getComponent(AttachmentManager.class);
        PersonalInformationManager personalInformationManager = (PersonalInformationManager)ComponentLocator.getComponent(PersonalInformationManager.class);
        PersonalInformation userPersonalInformation = personalInformationManager.getOrCreatePersonalInformation(user);
        Attachment attachment = attachmentManager.getAttachment((ContentEntityObject)userPersonalInformation, "user-avatar");
        Attachment previousVersion = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            try {
                previousVersion = (Attachment)attachment.clone();
            }
            catch (Exception e) {
                throw new InfrastructureException((Throwable)e);
            }
        }
        attachment.setMediaType("image/jpeg");
        attachment.setFileName("user-avatar");
        attachment.setVersionComment("Uploaded Profile Picture [Extender for Confluence]");
        attachment.setFileSize((long)imageBytes.length);
        userPersonalInformation.addAttachment(attachment);
        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
        try {
            attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)is);
        }
        catch (IOException e) {
            throw new InfrastructureException("Error saving attachment data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is, null);
        }
        return attachment;
    }
}

