/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.space.backup;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.actions.ExportSpaceLongRunningTask;
import com.atlassian.confluence.importexport.impl.ExportScope;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.collect.Sets;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.opensymphony.webwork.ServletActionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/export")
public class ExportRestApi {
    private static final Logger log = Logger.getLogger(ExportRestApi.class);
    private final SpaceManager spaceManager;
    private final ImportExportManager importExportManager;
    private final GateKeeper gateKeeper;
    private final LongRunningTaskManager longRunningTaskManager;
    private final PermissionManager permissionManager;
    private final BandanaManager bandanaManager;
    private final GroupManager groupManager;
    private ToolsHelper toolsHelper;
    private static final String EXPORT_TASK = "com.itlab.confluence.plugins.restextender.export.taskId.";

    public ExportRestApi(@ConfluenceImport SpaceManager spaceManager, @ConfluenceImport ImportExportManager importExportManager, @ConfluenceImport GateKeeper gateKeeper, @ConfluenceImport PermissionManager permissionManager, @ConfluenceImport LongRunningTaskManager longRunningTaskManager, @ConfluenceImport GroupManager groupManager, ToolsHelper toolsHelper) {
        this.spaceManager = spaceManager;
        this.groupManager = groupManager;
        this.toolsHelper = toolsHelper;
        this.importExportManager = importExportManager;
        this.gateKeeper = gateKeeper;
        this.permissionManager = permissionManager;
        this.longRunningTaskManager = longRunningTaskManager;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/task/{taskId}")
    public Response getTaskIdInfo(@PathParam(value="taskId") String taskId) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)this.toolsHelper.getAuthenticatedUser(), LongRunningTaskId.valueOf((String)taskId.toString()));
        if (!this.longRunningTaskExist(longRunningTask)) {
            return this.toolsHelper.taskIdNotExist(taskId);
        }
        response.put("name", longRunningTask.getName());
        response.put("currentStatus", longRunningTask.getCurrentStatus());
        response.put("isComplete", longRunningTask.isComplete());
        response.put("isSuccessful", longRunningTask.isSuccessful());
        response.put("percentageComplete", longRunningTask.getPercentageComplete());
        response.put("prettyElapsedTime", longRunningTask.getPrettyElapsedTime());
        response.put("prettyTimeRemaining", longRunningTask.getPrettyTimeRemaining());
        if (longRunningTask.isSuccessful() && longRunningTask.isComplete()) {
            String path = longRunningTask.getCurrentStatus();
            try {
                response.put("fileName", path.substring(path.indexOf("Confluence-space-export"), path.indexOf(".zip") + 4));
                response.put("downloadPath", path.substring(path.indexOf("href=") + 6, path.indexOf(".zip") + 4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Response.ok(response).build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}")
    public Response exportSpace(String jsonString, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        Object taskIdObject;
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("   isConfluenceAdministrator() - " + this.toolsHelper.isConfluenceAdministrator()));
            log.debug((Object)("   hasSpaceExportPermission()  - " + this.isCurrentUserHasSpaceExportPermission(space)));
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("exportSpace"))) {
            return this.toolsHelper.permissionViolation();
        }
        ConfluenceUser authenticatedUser = this.toolsHelper.getAuthenticatedUser();
        JSONObject jsonObject = new JSONObject(jsonString);
        boolean synchronous = false;
        boolean multiple = false;
        if (jsonObject.has("multiple")) {
            multiple = jsonObject.getBoolean("multiple");
        }
        if (jsonObject.has("synchronous")) {
            synchronous = jsonObject.getBoolean("synchronous");
        }
        if (this.isLongRunningTaskSupported() && !multiple && (taskIdObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), EXPORT_TASK + authenticatedUser.getKey())) != null && !"".equals(taskIdObject.toString())) {
            String taskId = taskIdObject.toString();
            if (taskId.contains("@@@@")) {
                spaceKey = taskId.substring(taskId.indexOf("@@@@") + 4);
                taskId = taskId.substring(0, taskId.indexOf("@@@@"));
            }
            LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)authenticatedUser, LongRunningTaskId.valueOf((String)taskId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getName " + longRunningTask.getName()));
                log.debug((Object)("isComplete " + longRunningTask.isComplete()));
                log.debug((Object)("getCurrentStatus " + longRunningTask.getCurrentStatus()));
                log.debug((Object)("isSuccessful " + longRunningTask.isSuccessful()));
                log.debug((Object)("spaceKey " + spaceKey));
                log.debug((Object)("taskId " + taskId));
            }
            if (!this.longRunningTaskExist(longRunningTask) || longRunningTask.isComplete() || !longRunningTask.isComplete() && !longRunningTask.isSuccessful()) {
                log.debug((Object)"done");
            } else {
                response.put("status", "waiting");
                response.put("spaceKey", spaceKey);
                response.put("message", "another export is in progress");
                response.put("taskId", taskId);
                return Response.ok(response).build();
            }
        }
        String exportType = "";
        try {
            exportType = jsonObject.getString("exportType");
        }
        catch (Exception ex) {
            log.debug((Object)"RESTAPI - exportType - debug:empty");
        }
        if (exportType == null || exportType.equals("")) {
            return this.toolsHelper.fieldRequired("exportType");
        }
        if (!exportType.equalsIgnoreCase("xml") && !exportType.equalsIgnoreCase("html")) {
            response.put("message", "exportType '" + exportType + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        boolean exportComments = false;
        try {
            exportComments = jsonObject.getBoolean("exportComments");
        }
        catch (Exception ex) {
            log.debug((Object)"RESTAPI - exportComments - debug:empty");
        }
        boolean exportAttachments = false;
        try {
            exportAttachments = jsonObject.getBoolean("exportAttachments");
        }
        catch (Exception ex) {
            log.debug((Object)"RESTAPI - exportAttachments - debug:empty");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exportType :" + exportType));
            log.debug((Object)("exportAttachments :" + exportAttachments));
            log.debug((Object)("exportComments :" + exportComments));
        }
        DefaultExportContext exportContext = new DefaultExportContext();
        exportContext.setExportScope(ExportScope.SPACE);
        if (exportType.equalsIgnoreCase("xml")) {
            exportContext.setType("TYPE_XML");
        } else {
            exportContext.setType("TYPE_HTML");
        }
        exportContext.setExportComments(exportComments);
        exportContext.setExportAttachments(exportAttachments);
        exportContext.setUser((User)authenticatedUser);
        exportContext.setSpaceKey(space.getKey());
        long[] emptyContentToExInclude = new long[]{};
        String contentOption = "all";
        if (exportContext.getType().equalsIgnoreCase("TYPE_XML")) {
            contentOption = "all";
        } else if (exportContext.getType().equalsIgnoreCase("TYPE_HTML")) {
            contentOption = "visibleOnly";
        }
        ExportSpaceLongRunningTask task = new ExportSpaceLongRunningTask(authenticatedUser, this.getContextPath(), (ExportContext)exportContext, (Set)Sets.newHashSet((Object[])ArrayUtils.toObject((long[])emptyContentToExInclude)), (Set)Sets.newHashSet((Object[])ArrayUtils.toObject((long[])emptyContentToExInclude)), this.gateKeeper, this.importExportManager, this.permissionManager, this.spaceManager, space.getKey(), exportContext.getType(), contentOption);
        if (this.isLongRunningTaskSupported() && !synchronous) {
            LongRunningTaskId taskId = this.longRunningTaskManager.startLongRunningTask((User)authenticatedUser, (LongRunningTask)task);
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), EXPORT_TASK + authenticatedUser.getKey(), (Object)(taskId.toString() + "@@@@" + space.getKey()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started log-running task " + taskId + " for export of space " + space.getKey()));
            }
            response.put("status", "in progress");
            response.put("message", "writing export");
            response.put("taskId", taskId + "");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting synchronous export of space " + space.getKey() + "; long-running tasks not enabled"));
            }
            task.run();
            String downloadPath = task.getDownloadPath();
            response.put("status", "done");
            response.put("downloadPath", downloadPath);
        }
        return Response.ok(response).build();
    }

    private boolean isLongRunningTaskSupported() {
        String runningServer = this.getServletContext().getServerInfo().toLowerCase();
        String unsupportedContainers = this.getServletContext().getInitParameter("unsupportedContainersForExportLongRunningTask");
        if (StringUtils.isNotBlank((CharSequence)unsupportedContainers)) {
            String[] containers = unsupportedContainers.split(",");
            for (int i = 0; i < containers.length; ++i) {
                String container = StringUtils.trim((String)containers[i]);
                if (!runningServer.contains(container)) continue;
                return false;
            }
        }
        return true;
    }

    public ServletContext getServletContext() {
        return ServletActionContext.getServletContext();
    }

    private String getContextPath() {
        if (this.getServletContext() == null || this.getServletContext().getContextPath() == null) {
            this.toolsHelper.getBaseUrl();
        }
        return this.getServletContext().getContextPath();
    }

    private boolean longRunningTaskExist(LongRunningTask longRunningTask) {
        return longRunningTask != null && longRunningTask.getName() != null;
    }

    private boolean isCurrentUserHasSpaceExportPermission(Space space) throws EntityException {
        UserProfile userProfile = this.toolsHelper.getCurrentUserProfile();
        User user = this.toolsHelper.getUserByName(userProfile.getUsername());
        Map groups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("EXPORTSPACE", space);
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("EXPORTSPACE", space);
        if (log.isDebugEnabled()) {
            log.debug((Object)("groups: " + groups));
            log.debug((Object)("users: " + users));
        }
        if (users.get(userProfile.getUsername()) != null) {
            return true;
        }
        for (Map.Entry entry : groups.entrySet()) {
            Group group = this.groupManager.getGroup((String)entry.getKey());
            if (!this.groupManager.hasMembership(group, user)) continue;
            return true;
        }
        return false;
    }
}

