/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.trash;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/trash")
public class TrashRestApi {
    private static final Logger log = Logger.getLogger(TrashRestApi.class);
    private final ToolsHelper toolsHelper;
    private final TrashManager trashManager;
    private final PageManager pageManager;

    public TrashRestApi(@ConfluenceImport TrashManager trashManager, @ConfluenceImport PageManager pageManager, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.trashManager = trashManager;
        this.pageManager = pageManager;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/restoreContent")
    public Response restoreContent(String jsonString, @PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("trashRestoreContent"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("contentId")) {
            return this.toolsHelper.fieldRequired("contentId");
        }
        JSONArray contentIds = jsonObject.getJSONArray("contentId");
        ArrayList<Long> restoredArrayList = new ArrayList<Long>();
        if (contentIds != null) {
            int len = contentIds.length();
            for (int i = 0; i < len; ++i) {
                if (!this.toolsHelper.isNumeric(contentIds.get(i).toString())) continue;
                Long contentId = Long.parseLong(contentIds.get(i).toString());
                Page page = this.toolsHelper.getPageFormPageDao(contentId);
                BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
                if ((page == null || !page.isDeleted() || !page.getSpaceKey().equals(spaceKey)) && (blogPost == null || !blogPost.isDeleted() || !blogPost.getSpaceKey().equals(spaceKey))) continue;
                if (!restoredArrayList.contains(contentId)) {
                    restoredArrayList.add(contentId);
                }
                this.pageManager.restorePage((AbstractPage)(page != null ? page : blogPost));
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "success");
        response.put("restoredContent", restoredArrayList);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/purgeContent")
    public Response purgeContent(String jsonString, @PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("trashPurgeContent"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("contentId")) {
            return this.toolsHelper.fieldRequired("contentId");
        }
        JSONArray contentIds = jsonObject.getJSONArray("contentId");
        ArrayList<Long> removedArrayList = new ArrayList<Long>();
        if (contentIds != null) {
            int len = contentIds.length();
            for (int i = 0; i < len; ++i) {
                if (!this.toolsHelper.isNumeric(contentIds.get(i).toString())) continue;
                Long contentId = Long.parseLong(contentIds.get(i).toString());
                Page page = this.toolsHelper.getPageFormPageDao(contentId);
                BlogPost blogPost = this.toolsHelper.getBlogPostFormPageDao(contentId);
                if ((page == null || !page.isDeleted() || !page.getSpaceKey().equals(spaceKey)) && (blogPost == null || !blogPost.isDeleted() || !blogPost.getSpaceKey().equals(spaceKey))) continue;
                if (!removedArrayList.contains(contentId)) {
                    removedArrayList.add(contentId);
                }
                this.trashManager.purge(spaceKey, contentId.longValue());
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "success");
        response.put("removedContent", removedArrayList);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/purgeAll")
    public Response purgeAll(@PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("trashPurgeAll"))) {
            return this.toolsHelper.permissionViolation();
        }
        this.trashManager.emptyTrash(space);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "success");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}")
    public Response getMaintenanceState(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showAttachments") boolean showAttachments, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.currentUserIsInConfluenceAdministratorGroup() || this.toolsHelper.getSpacePermissionManager().hasPermission("SETSPACEPERMISSIONS", space, (User)this.toolsHelper.getCurrentUser()))) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        if (maxResults == 0) {
            maxResults = 50;
        }
        List trashObjects = this.trashManager.getTrashContents(space, startAt, startAt + maxResults);
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        ArrayList objectInTrash = new ArrayList();
        for (ContentEntityObject trashObject : trashObjects) {
            HashMap<String, Object> contentEntityObject = new HashMap<String, Object>();
            contentEntityObject.put("title", trashObject.getTitle());
            contentEntityObject.put("contentId", trashObject.getContentId());
            contentEntityObject.put("type", trashObject.getType());
            if (this.toolsHelper.confluenceVersionIsGreaterThanOrEqualTo(7, 14)) {
                long trashDate = this.toolsHelper.getTrashData(trashObject);
                contentEntityObject.put("trashDate", trashDate == -1L ? null : Long.valueOf(trashDate));
                contentEntityObject.put("trashDateString", trashDate == -1L ? null : sdfFull.format(trashDate));
            }
            ArrayList attachments = new ArrayList();
            List attachmentsInTrashObject = trashObject.getAttachments();
            contentEntityObject.put("type", trashObject.getType());
            if (showAttachments) {
                contentEntityObject.put("totalAttachments", attachmentsInTrashObject.size());
                for (Attachment attachment : attachmentsInTrashObject) {
                    HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
                    attachmentMap.put("fileName", attachment.getFileName());
                    attachmentMap.put("version", attachment.getVersion());
                    attachmentMap.put("comment", attachment.getVersionComment() == null ? "" : attachment.getVersionComment());
                    attachmentMap.put("fileSize", attachment.getFileSize());
                    attachmentMap.put("creatorName", attachment.getCreator() != null ? attachment.getCreator().getName() : "unknown user");
                    attachmentMap.put("creationDate", attachment.getCreationDate());
                    attachmentMap.put("creationDateString", attachment.getCreationDate() == null ? null : sdfFull.format(attachment.getCreationDate()));
                    attachmentMap.put("fileSizeNice", attachment.getNiceFileSize());
                    attachments.add(attachmentMap);
                }
                contentEntityObject.put("attachments", attachments);
            }
            objectInTrash.add(contentEntityObject);
        }
        response.put("total", Integer.valueOf(this.trashManager.getTrashContents(space, 0, 1000000).size()));
        response.put("totalWithAttachments", Integer.valueOf(this.trashManager.getNumberOfItemsInTrash(space)));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("trash", objectInTrash);
        return Response.ok(response).build();
    }
}

