/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.template;

import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/template")
public class TemplateRestApi {
    private static final Logger log = Logger.getLogger(TemplateRestApi.class);
    private final PageTemplateManager pageTemplateManager;
    private final FormatConverter formatConverter;
    private ToolsHelper toolsHelper;

    public TemplateRestApi(ToolsHelper toolsHelper, @ConfluenceImport PageTemplateManager pageTemplateManager, @ConfluenceImport FormatConverter formatConverter) {
        this.pageTemplateManager = pageTemplateManager;
        this.toolsHelper = toolsHelper;
        this.formatConverter = formatConverter;
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceIdOrKey}/create")
    public Response putSpaceTemplateByIdOrKey(@PathParam(value="spaceIdOrKey") String spaceIdOrKey, String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("title") || jsonObject.getString("title").equals("")) {
            return this.toolsHelper.fieldRequired("title");
        }
        String title = jsonObject.getString("title");
        String description = jsonObject.has("description") ? jsonObject.getString("description") : null;
        String content = jsonObject.has("content") ? jsonObject.getString("content") : null;
        boolean isTemplateExist = false;
        long spaceId = -1L;
        Space space = null;
        boolean checkSpaceByKey = false;
        if (this.isNumeric(spaceIdOrKey)) {
            spaceId = Long.parseLong(spaceIdOrKey);
        } else {
            checkSpaceByKey = true;
        }
        space = checkSpaceByKey ? this.toolsHelper.getSpaceFromSpaceDao(spaceIdOrKey) : this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            response.put("status", "error");
            response.put("message", "Space with " + (checkSpaceByKey ? "key" : "id") + " '" + spaceIdOrKey + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            response.put("status", "error");
            response.put("message", "You are not authorized to create template in this space");
            return Response.serverError().entity(response).build();
        }
        PageTemplate pageTemplateToCreate = new PageTemplate();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getPageTemplates(space)) {
            if (pageTemplate.isGlobalPageTemplate() || !pageTemplate.getTitle().equals(title)) continue;
            isTemplateExist = true;
            break;
        }
        if (isTemplateExist) {
            response.put("status", "error");
            response.put("message", "Template with name '" + title + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (title != null && !title.equals("")) {
            pageTemplateToCreate.setName(title);
        }
        if (description != null) {
            pageTemplateToCreate.setDescription(description);
        }
        try {
            if (content != null) {
                pageTemplateToCreate.setContent(this.formatConverter.convertToStorageFormat(content, (RenderContext)new PageContext()));
                pageTemplateToCreate.setBodyType(BodyType.XHTML);
            }
        }
        catch (XhtmlException e) {
            response.put("status", "error");
            response.put("message", "Incorrect content format " + e.getLocalizedMessage());
            return Response.serverError().entity(response).build();
        }
        space.addPageTemplate(pageTemplateToCreate);
        this.pageTemplateManager.savePageTemplate(pageTemplateToCreate, null);
        response.put("status", "done");
        response.put("templateId", pageTemplateToCreate.getId());
        response.put("message", "Template '" + pageTemplateToCreate.getTitle() + " (Id: " + pageTemplateToCreate.getId() + ")' created");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceIdOrKey}/edit/{templateId}")
    public Response editSpaceTemplateByIdOrKey(@PathParam(value="spaceIdOrKey") String spaceIdOrKey, @PathParam(value="templateId") long templateId, String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        String title = jsonObject.has("title") ? jsonObject.getString("title") : null;
        String description = jsonObject.has("description") ? jsonObject.getString("description") : null;
        String content = jsonObject.has("content") ? jsonObject.getString("content") : null;
        boolean isTemplateExist = false;
        long spaceId = -1L;
        Space space = null;
        boolean checkSpaceByKey = false;
        boolean isAnotherTemplateHasThisName = false;
        if (this.isNumeric(spaceIdOrKey)) {
            spaceId = Long.parseLong(spaceIdOrKey);
        } else {
            checkSpaceByKey = true;
        }
        space = checkSpaceByKey ? this.toolsHelper.getSpaceFromSpaceDao(spaceIdOrKey) : this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            response.put("status", "error");
            response.put("message", "Space with " + (checkSpaceByKey ? "key" : "id") + " '" + spaceIdOrKey + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(space)) {
            response.put("status", "error");
            response.put("message", "You are not authorized to edit template in this space");
            return Response.serverError().entity(response).build();
        }
        PageTemplate pageTemplateToEdit = new PageTemplate();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getPageTemplates(space)) {
            if (!pageTemplate.isGlobalPageTemplate() && pageTemplate.getId() == templateId) {
                pageTemplateToEdit = pageTemplate;
                isTemplateExist = true;
            }
            if (pageTemplate.isGlobalPageTemplate() || title == null || title.equals("") || !pageTemplate.getTitle().equals(title) || pageTemplate.getId() == templateId) continue;
            isAnotherTemplateHasThisName = true;
        }
        if (!isTemplateExist) {
            response.put("status", "error");
            response.put("message", "Template with id '" + templateId + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (isAnotherTemplateHasThisName) {
            response.put("status", "error");
            response.put("message", "Another template is already named '" + title + "', please provide a different name.");
            return Response.serverError().entity(response).build();
        }
        if (title != null && !title.equals("")) {
            pageTemplateToEdit.setName(title);
        }
        if (description != null) {
            pageTemplateToEdit.setDescription(description);
        }
        try {
            if (content != null) {
                pageTemplateToEdit.setContent(this.formatConverter.convertToStorageFormat(content, (RenderContext)new PageContext()));
                pageTemplateToEdit.setBodyType(BodyType.XHTML);
            }
        }
        catch (XhtmlException e) {
            response.put("status", "error");
            response.put("message", "Incorrect content format " + e.getLocalizedMessage());
            return Response.serverError().entity(response).build();
        }
        space.addPageTemplate(pageTemplateToEdit);
        this.pageTemplateManager.savePageTemplate(pageTemplateToEdit, null);
        response.put("status", "done");
        response.put("templateId", pageTemplateToEdit.getId());
        response.put("message", "Template '" + pageTemplateToEdit.getTitle() + " (Id: " + pageTemplateToEdit.getId() + ")' saved");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/page/{templateId}")
    public Response getPageById(@PathParam(value="templateId") Long templateId, @Context HttpServletRequest request) {
        log.debug((Object)("RESTAPI - getPageById - " + templateId));
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        PageTemplate pageTemplate = this.pageTemplateManager.getPageTemplate(templateId.longValue());
        if (pageTemplate == null) {
            response.put("status", "error");
            response.put("message", "Template with id '" + templateId + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserHasSpaceViewPermission(pageTemplate.getSpace()) && this.toolsHelper.isCurrentUserHasSpaceCreatePagePermission(pageTemplate.getSpace()) || this.toolsHelper.isCurrentUserIsSpaceAdministrator(pageTemplate.getSpace()))) {
            response.put("status", "error");
            response.put("message", "You are not authorized to view this template");
            return Response.serverError().entity(response).build();
        }
        response.put("status", "success");
        HashMap<String, Object> template = new HashMap<String, Object>();
        template.put("id", pageTemplate.getId());
        template.put("isGlobal", pageTemplate.isGlobalPageTemplate());
        template.put("content", pageTemplate.getContent());
        template.put("description", pageTemplate.getDescription());
        template.put("name", pageTemplate.getName());
        template.put("title", pageTemplate.getTitle());
        response.put("template", template);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/create")
    public Response putGlobalTemplateGlobal(String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        if (!jsonObject.has("title") || jsonObject.getString("title").equals("")) {
            return this.toolsHelper.fieldRequired("title");
        }
        String title = jsonObject.getString("title");
        String description = jsonObject.has("description") ? jsonObject.getString("description") : null;
        String content = jsonObject.has("content") ? jsonObject.getString("content") : null;
        boolean isTemplateExist = false;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            response.put("status", "error");
            response.put("message", "You are not authorized to create global template");
            return Response.serverError().entity(response).build();
        }
        PageTemplate pageTemplateToCreate = new PageTemplate();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getGlobalPageTemplates()) {
            if (!pageTemplate.isGlobalPageTemplate() || !pageTemplate.getTitle().equals(title)) continue;
            isTemplateExist = true;
            break;
        }
        if (isTemplateExist) {
            response.put("status", "error");
            response.put("message", "Template with name '" + title + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (title != null && !title.equals("")) {
            pageTemplateToCreate.setName(title);
        }
        if (description != null) {
            pageTemplateToCreate.setDescription(description);
        }
        try {
            if (content != null) {
                pageTemplateToCreate.setContent(this.formatConverter.convertToStorageFormat(content, (RenderContext)new PageContext()));
                pageTemplateToCreate.setBodyType(BodyType.XHTML);
            }
        }
        catch (XhtmlException e) {
            response.put("status", "error");
            response.put("message", "Incorrect content format " + e.getLocalizedMessage());
            return Response.serverError().entity(response).build();
        }
        this.pageTemplateManager.savePageTemplate(pageTemplateToCreate, null);
        response.put("status", "done");
        response.put("templateId", pageTemplateToCreate.getId());
        response.put("message", "Template '" + pageTemplateToCreate.getTitle() + " (Id: " + pageTemplateToCreate.getId() + ")' created");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/edit/{templateId}")
    public Response editGlobalTemplateByIdOrKey(@PathParam(value="templateId") long templateId, String jsonString, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        JSONObject jsonObject = new JSONObject(jsonString);
        String title = jsonObject.has("title") ? jsonObject.getString("title") : null;
        String description = jsonObject.has("description") ? jsonObject.getString("description") : null;
        String content = jsonObject.has("content") ? jsonObject.getString("content") : null;
        boolean isTemplateExist = false;
        boolean isAnotherTemplateHasThisName = false;
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            response.put("status", "error");
            response.put("message", "You are not authorized to edit global template");
            return Response.serverError().entity(response).build();
        }
        PageTemplate pageTemplateToEdit = new PageTemplate();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getGlobalPageTemplates()) {
            if (pageTemplate.isGlobalPageTemplate() && pageTemplate.getId() == templateId) {
                pageTemplateToEdit = pageTemplate;
                isTemplateExist = true;
            }
            if (!pageTemplate.isGlobalPageTemplate() || title == null || title.equals("") || !pageTemplate.getTitle().equals(title) || pageTemplate.getId() == templateId) continue;
            isAnotherTemplateHasThisName = true;
        }
        if (!isTemplateExist) {
            response.put("status", "error");
            response.put("message", "Template with id '" + templateId + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (isAnotherTemplateHasThisName) {
            response.put("status", "error");
            response.put("message", "Another template is already named '" + title + "', please provide a different name.");
            return Response.serverError().entity(response).build();
        }
        if (title != null && !title.equals("")) {
            pageTemplateToEdit.setName(title);
        }
        if (description != null) {
            pageTemplateToEdit.setDescription(description);
        }
        try {
            if (content != null) {
                pageTemplateToEdit.setContent(this.formatConverter.convertToStorageFormat(content, (RenderContext)new PageContext()));
                pageTemplateToEdit.setBodyType(BodyType.XHTML);
            }
        }
        catch (XhtmlException e) {
            response.put("status", "error");
            response.put("message", "Incorrect content format " + e.getLocalizedMessage());
            return Response.serverError().entity(response).build();
        }
        this.pageTemplateManager.savePageTemplate(pageTemplateToEdit, null);
        response.put("status", "done");
        response.put("templateId", pageTemplateToEdit.getId());
        response.put("message", "Template '" + pageTemplateToEdit.getTitle() + " (Id: " + pageTemplateToEdit.getId() + ")' saved");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/{templateName}")
    public Response getGlobalByName(@PathParam(value="templateName") String templateName, @Context HttpServletRequest request) {
        log.debug((Object)("RESTAPI - getGlobalByName - " + templateName));
        templateName = this.toolsHelper.decodeUrlParam(templateName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        PageTemplate pageTemplate = this.pageTemplateManager.getGlobalPageTemplate(templateName);
        if (pageTemplate == null) {
            response.put("status", "error");
            response.put("message", "Template with id '" + templateName + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        response.put("status", "success");
        HashMap<String, Object> template = new HashMap<String, Object>();
        template.put("id", pageTemplate.getId());
        template.put("isGlobal", pageTemplate.isGlobalPageTemplate());
        template.put("content", pageTemplate.getContent());
        template.put("description", pageTemplate.getDescription());
        template.put("name", pageTemplate.getName());
        template.put("title", pageTemplate.getTitle());
        response.put("template", template);
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/page/{templateId}")
    public Response deleteById(@PathParam(value="templateId") Long templateId, @Context HttpServletRequest request) {
        log.debug((Object)("RESTAPI - deleteById - " + templateId));
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        PageTemplate pageTemplate = this.pageTemplateManager.getPageTemplate(templateId.longValue());
        if (pageTemplate == null) {
            response.put("status", "error");
            response.put("message", "Template with id '" + templateId + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!(pageTemplate.isGlobalPageTemplate() && this.toolsHelper.isConfluenceAdministrator() || !pageTemplate.isGlobalPageTemplate() && (this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.isCurrentUserIsSpaceAdministrator(pageTemplate.getSpace()) && !this.toolsHelper.isDisabledForSpaceAdministrator("templateDelete")))) {
            response.put("status", "error");
            response.put("message", "You are not authorized to delete this template");
            return Response.serverError().entity(response).build();
        }
        this.pageTemplateManager.removePageTemplate(pageTemplate);
        response.put("status", "success");
        response.put("message", "Template with id '" + templateId + "' has been deleted");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global")
    public Response getGlobalAll(@Context HttpServletRequest request) {
        log.debug((Object)"RESTAPI - getGlobalAll - ");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap response = new HashMap();
        ArrayList pageTemplates = new ArrayList();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getGlobalPageTemplates()) {
            HashMap<String, Object> template = new HashMap<String, Object>();
            template.put("id", pageTemplate.getId());
            template.put("content", pageTemplate.getContent());
            template.put("description", pageTemplate.getDescription());
            template.put("name", pageTemplate.getName());
            template.put("title", pageTemplate.getTitle());
            pageTemplates.add(template);
        }
        response.put("templates", pageTemplates);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceIdOrKey}")
    public Response getSpaceTemplateByIdOrKey(@PathParam(value="spaceIdOrKey") String spaceIdOrKey, @Context HttpServletRequest request) {
        log.debug((Object)("RESTAPI - getSpaceTemplateByIdOrKey - " + spaceIdOrKey));
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        long spaceId = -1L;
        Space space = null;
        boolean checkSpaceByKey = false;
        if (this.isNumeric(spaceIdOrKey)) {
            spaceId = Long.parseLong(spaceIdOrKey);
        } else {
            checkSpaceByKey = true;
        }
        space = checkSpaceByKey ? this.toolsHelper.getSpaceFromSpaceDao(spaceIdOrKey) : this.toolsHelper.getSpaceFromSpaceDao(spaceId);
        if (space == null) {
            response.put("status", "error");
            response.put("message", "Space with " + (checkSpaceByKey ? "key" : "id") + " '" + spaceIdOrKey + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        ArrayList pageTemplates = new ArrayList();
        for (PageTemplate pageTemplate : this.pageTemplateManager.getPageTemplates(space)) {
            if (pageTemplate.isGlobalPageTemplate() || !this.toolsHelper.isConfluenceAdministrator() && (!this.toolsHelper.isCurrentUserHasSpaceViewPermission(pageTemplate.getSpace()) || !this.toolsHelper.isCurrentUserHasSpaceCreatePagePermission(pageTemplate.getSpace())) && !this.toolsHelper.isCurrentUserIsSpaceAdministrator(pageTemplate.getSpace())) continue;
            HashMap<String, Object> template = new HashMap<String, Object>();
            template.put("id", pageTemplate.getId());
            template.put("isGlobal", pageTemplate.isGlobalPageTemplate());
            template.put("content", pageTemplate.getContent());
            template.put("description", pageTemplate.getDescription());
            template.put("name", pageTemplate.getName());
            template.put("title", pageTemplate.getTitle());
            pageTemplates.add(template);
        }
        response.put("templates", pageTemplates);
        return Response.ok(response).build();
    }

    private boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

