/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import com.itlab.confluence.plugins.restextender.helper.RequestWrapper;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import com.itlab.confluence.plugins.restextender.tokens.model.Token;
import com.itlab.confluence.plugins.restextender.tokens.model.TokenContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class FilterTokens
implements Filter {
    private static final Logger log = Logger.getLogger(FilterTokens.class);
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    private final ToolsHelper toolsHelper;
    private final UserAccessor userAccessor;

    public FilterTokens(ToolsHelper toolsHelper, @ConfluenceImport UserAccessor userAccessor) {
        this.toolsHelper = toolsHelper;
        this.userAccessor = userAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public List<com.atlassian.user.User> findUserByEmail(String email) {
        List<Object> userList = new ArrayList<com.atlassian.user.User>();
        try {
            userList = this.userAccessor.findUsersAsList((Query)new EmailTermQuery(email));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userList;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String authHeader;
        ConfluenceUser confluenceUser = null;
        boolean useTokenForUser = false;
        RequestWrapper httpRequest = new RequestWrapper((HttpServletRequest)request);
        if (httpRequest.getRemoteUser() == null && (authHeader = httpRequest.getHeader("Authorization")) != null && !authHeader.equals("") && authHeader.split(" ").length > 1 && authHeader.split(" ")[0].equalsIgnoreCase("basic")) {
            String decodeAuthHeader;
            String base64authHeader;
            block27: {
                base64authHeader = authHeader.split(" ")[1];
                decodeAuthHeader = "";
                try {
                    decodeAuthHeader = new String(Base64.getDecoder().decode(base64authHeader));
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block27;
                    log.debug((Object)("decodeAuthHeader Exception -> Base64 -> String :: " + base64authHeader));
                }
            }
            String restUrl = httpRequest.getRequestURI();
            if (decodeAuthHeader != null && !decodeAuthHeader.equals("") && decodeAuthHeader.split(":").length >= 2) {
                String userData = decodeAuthHeader.split(":")[0];
                String tokenString = decodeAuthHeader.split(":")[1];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("authHeader " + authHeader));
                    log.debug((Object)("base64authHeader " + base64authHeader));
                    log.debug((Object)("decodeAuthHeader " + decodeAuthHeader));
                    log.debug((Object)("userData " + userData));
                    log.debug((Object)("tokenString " + tokenString));
                    log.debug((Object)("restUrl " + restUrl));
                }
                if (userData.contains("@")) {
                    List<com.atlassian.user.User> result = this.findUserByEmail(userData);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("result " + result.toString()));
                    }
                    for (com.atlassian.user.User user : result) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("check user '" + user.getEmail() + "'"));
                        }
                        if (!user.getEmail().equalsIgnoreCase(userData)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("found user '" + user.getName() + "' '" + user.getEmail() + "'"));
                        }
                        confluenceUser = this.userAccessor.getUserByName(user.getName());
                    }
                } else {
                    confluenceUser = this.userAccessor.getUserByName(userData);
                }
                if (confluenceUser == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RestAPI @tokens - confluenceUser does not exist " + userData));
                    }
                } else if (this.toolsHelper.getTokensConfig().equalsIgnoreCase("limit") && restUrl.toLowerCase().contains("rest/extender/1.0") || !this.toolsHelper.getTokensConfig().equalsIgnoreCase("limit")) {
                    TokenContainer tokenContainer = this.toolsHelper.getSavedTokens();
                    ArrayList<Token> tokens = tokenContainer.getTokens();
                    if (tokens.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"RestAPI @tokens - no tokens");
                        }
                    } else {
                        String restMethod = httpRequest.getMethod();
                        for (Token token : tokens) {
                            if (!this.checkToken(token, tokenString, confluenceUser.getKey().getStringValue(), restUrl, restMethod)) continue;
                            useTokenForUser = true;
                            if (tokenContainer.getCollectUsageDetails()) {
                                token.setLastUsed(new Date());
                                token.setIp(FilterTokens.getClientIpAddress((HttpServletRequest)httpRequest));
                                token.addCounter();
                                this.toolsHelper.saveTokens(tokenContainer);
                            }
                            if (!tokenContainer.getAddAuditRecord()) break;
                            String requestMethod = httpRequest.getMethod().toLowerCase();
                            UserProfile currentUserProfile = this.toolsHelper.getUserProfile(confluenceUser.getKey().getStringValue());
                            User author = this.toolsHelper.getPeopleUser(currentUserProfile);
                            String objectType = this.toolsHelper.getUntransformedRawText("audit.logging.affected.object.user");
                            AffectedObject targetAffectedUser = AffectedObject.builder().name(confluenceUser.getName()).objectType(objectType).build();
                            HashSet<AffectedObject> associatedObjects = new HashSet<AffectedObject>();
                            associatedObjects.add(targetAffectedUser);
                            ArrayList<Map<String, String>> changedValueList = new ArrayList<Map<String, String>>();
                            HashMap<String, String> changedValue = new HashMap<String, String>();
                            changedValue.put("name", "Url");
                            changedValue.put("oldValue", "");
                            changedValue.put("newValue", "[" + requestMethod.toUpperCase() + "] " + restUrl);
                            changedValueList.add(changedValue);
                            String jsonBody = this.toolsHelper.getJsonBodyForAuditRecord((HttpServletRequest)httpRequest);
                            if (jsonBody != null && !jsonBody.equals("")) {
                                changedValue = new HashMap();
                                changedValue.put("name", "Payload");
                                changedValue.put("oldValue", "");
                                changedValue.put("newValue", jsonBody);
                                changedValueList.add(changedValue);
                            }
                            this.toolsHelper.addAuditRecord(author, "Token \"" + token.getLabel() + "\" was used", "System", "Token \"" + token.getLabel() + "\" was used", true, targetAffectedUser, null, changedValueList);
                            break;
                        }
                        if (!this.toolsHelper.isLicenseIsValid()) {
                            useTokenForUser = false;
                        }
                    }
                    if (useTokenForUser) {
                        ConfluenceUserPrincipal userPrincipal = new ConfluenceUserPrincipal(confluenceUser);
                        HttpSession session = httpRequest.getSession(true);
                        session.setAttribute("samlNameID", (Object)userData);
                        session.setAttribute("seraph_defaultauthenticator_user", (Object)userPrincipal);
                        AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("samlNameID :: " + userData));
                            log.debug((Object)("seraph_defaultauthenticator_user name :: " + userPrincipal.getName()));
                            log.debug((Object)("seraph_defaultauthenticator_user key :: " + userPrincipal.getUserKey()));
                            log.debug((Object)("request :: " + httpRequest.getAttribute("os_authstatus")));
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("request :: " + httpRequest.getAttribute("os_authstatus")));
        }
        if (useTokenForUser) {
            chain.doFilter((ServletRequest)new RemoveAuthHeaderRequestWrapper((HttpServletRequest)httpRequest), response);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    private boolean matchesRegexp(Token token, String restUrl, String restMethod) {
        String limitTo = token.getLimitTo();
        if (limitTo == null || limitTo.equals("")) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("restUrl " + restUrl));
            log.debug((Object)("limitTo " + limitTo));
        }
        for (String limitUrlRegexp : limitTo.split("<br>")) {
            boolean checkMethod = false;
            String methodFromUrl = "";
            if (log.isDebugEnabled()) {
                log.debug((Object)("limitUrlRegexp in " + limitUrlRegexp));
            }
            if (limitUrlRegexp.toLowerCase().startsWith("[post]")) {
                limitUrlRegexp = limitUrlRegexp.substring(6);
                checkMethod = true;
                methodFromUrl = "post";
            } else if (limitUrlRegexp.toLowerCase().startsWith("[get]")) {
                limitUrlRegexp = limitUrlRegexp.substring(5);
                checkMethod = true;
                methodFromUrl = "get";
            } else if (limitUrlRegexp.toLowerCase().startsWith("[put]")) {
                limitUrlRegexp = limitUrlRegexp.substring(5);
                checkMethod = true;
                methodFromUrl = "put";
            } else if (limitUrlRegexp.toLowerCase().startsWith("[patch]")) {
                limitUrlRegexp = limitUrlRegexp.substring(7);
                checkMethod = true;
                methodFromUrl = "patch";
            } else if (limitUrlRegexp.toLowerCase().startsWith("[delete]")) {
                limitUrlRegexp = limitUrlRegexp.substring(8);
                checkMethod = true;
                methodFromUrl = "delete";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("limitUrlRegexp out " + limitUrlRegexp));
            }
            if ((checkMethod || !restUrl.matches(limitUrlRegexp)) && (!checkMethod || !restUrl.matches(limitUrlRegexp) || !methodFromUrl.equalsIgnoreCase(restMethod))) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidDate(Token token) {
        if (token.getValidUntil() == null) {
            return true;
        }
        Date validUntil = token.getValidUntil();
        Date now = new Date();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" validUntil " + validUntil.getTime()));
            log.debug((Object)(" now " + now.getTime()));
        }
        return now.getTime() <= validUntil.getTime();
    }

    private boolean userWithTokenExist(Token token, String tokenString, String userKey) {
        if (token.getToken().equals(tokenString) && token.getUserKey().equals(userKey)) {
            return true;
        }
        return token.getToken().equals(tokenString) && token.getUserKey().equals("") && token.getUser().equals("");
    }

    public void destroy() {
    }

    private boolean checkToken(Token token, String tokenString, String userKey, String restUrl, String restMethod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("token check 1 " + this.userWithTokenExist(token, tokenString, userKey)));
            log.debug((Object)("token check 2 " + this.hasValidDate(token)));
            log.debug((Object)("token check 3 " + this.matchesRegexp(token, restUrl, restMethod)));
        }
        if (this.userWithTokenExist(token, tokenString, userKey) && this.hasValidDate(token) && this.matchesRegexp(token, restUrl, restMethod)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("RestAPI @tokens - token exist BASICAUTH:" + userKey + ":" + tokenString + " TOKEN:" + token.getUser() + ":" + token.getToken()));
            }
            return true;
        }
        return false;
    }

    private static String getClientIpAddress(HttpServletRequest request) {
        for (String header : IP_HEADER_CANDIDATES) {
            String ip = request.getHeader(header);
            if (log.isDebugEnabled()) {
                log.debug((Object)("header:" + header));
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    class RemoveAuthHeaderRequestWrapper
    extends HttpServletRequestWrapper {
        public RemoveAuthHeaderRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            return "Authorization".equalsIgnoreCase(name) && !this.isWebSudoCheck() ? null : request.getHeader(name);
        }

        public Object getAttribute(String name) {
            return "os_authstatus".equals(name) ? "success" : super.getAttribute(name);
        }

        private boolean isWebSudoCheck() {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            return Arrays.stream(stacktrace).map(StackTraceElement::getMethodName).anyMatch("shouldEnforceWebSudoProtection"::equals);
        }
    }
}

