/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.notifyWatchers;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/notifyWatchers")
public class NotifyWatchersUtils {
    private static final Logger log = Logger.getLogger(NotifyWatchersUtils.class);
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    private static final String BUTTONS = "com.itlab.confluence.plugins.restextender.notifyWatchers.button.primary";
    private static final String BUTTONS_GROUP = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";

    public NotifyWatchersUtils(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    @GET
    @Path(value="/set/save")
    public Response setPrimarySave() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS, (Object)"save");
        return Response.ok().build();
    }

    @GET
    @Path(value="/set/saveAndNotify")
    public Response setPrimarySaveAndNotify() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS, (Object)"saveAndNotify");
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    public Response get(@Context HttpServletRequest request) {
        String notifyForUserLang;
        HashMap<String, String> response = new HashMap<String, String>();
        Object primaryButton = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS);
        if (log.isDebugEnabled()) {
            log.debug((Object)("primaryButton : " + primaryButton));
        }
        if (primaryButton == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("primaryButton NULL : " + primaryButton));
            }
            response.put("primaryButton", "save");
        } else if (primaryButton.toString().equalsIgnoreCase("saveAndNotify")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("primaryButton saveAndNotify : " + primaryButton));
            }
            response.put("primaryButton", "saveAndNotify");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("primaryButton SAVE : " + primaryButton));
            }
            response.put("primaryButton", "save");
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        response.put("notifyText", "Notify");
        response.put("notifyTextType", "fixed");
        response.put("userLang", "");
        if (user != null && localeManager.getLocale((User)user) != null && localeManager.getLocale((User)user).getLanguage() != null) {
            response.put("userLang", localeManager.getLocale((User)user).getLanguage());
        }
        if (!(notifyForUserLang = this.getNotifyForUserLang((User)user, localeManager)).equals("")) {
            response.put("notifyText", notifyForUserLang);
        } else {
            response.put("notifyText", i18NBeanFactory.getI18NBean(localeManager.getLocale((User)user)).getText("editor.minor.edit"));
            response.put("notifyTextType", "i18key");
        }
        return Response.ok(response).build();
    }

    private String getNotifyForUserLang(User user, LocaleManager localeManager) {
        String lang;
        String string = lang = user != null && localeManager.getLocale(user) != null && localeManager.getLocale(user).getLanguage() != null ? localeManager.getLocale(user).getLanguage().toLowerCase() : "";
        if (lang != null) {
            if (lang.equals("de") || lang.equals("de_de")) {
                return "Benachrichtigen";
            }
            if (lang.equals("en") || lang.equals("gb") || lang.equals("us") || lang.equals("en_gb") || lang.equals("en_us")) {
                return "Notify";
            }
            if (lang.equals("fr") || lang.equals("fr_fr")) {
                return "Notifier";
            }
            if (lang.equals("pl") || lang.equals("pl_pl")) {
                return "Powiadom";
            }
            if (lang.equals("nl") || lang.equals("nl_nl")) {
                return "Notificeer";
            }
        }
        return "";
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getGroups")
    public Response getGroups() {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap response = new HashMap();
        ArrayList<String> groupsArray = new ArrayList<String>();
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    groupsArray.add(groupsTable[i]);
                }
            } else if (!groups.toString().equals("")) {
                groupsArray.add(groups.toString());
            }
        }
        response.put("groups", groupsArray);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/removeGroup/{groupName}")
    public Response removeGroup(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        String newGroups = "";
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (groupsTable[i].equalsIgnoreCase(groupName)) continue;
                    if (!newGroups.equals("")) {
                        newGroups = newGroups + "@@@";
                    }
                    newGroups = newGroups + groupsTable[i];
                }
            } else if (!groups.toString().equals("")) {
                newGroups = groups.toString().replace(groupName, "");
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP, (Object)newGroups);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/addGroup/{groupName}")
    public Response setGroups(@PathParam(value="groupName") String groupName) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        if (groups != null && !groups.toString().equals("")) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP, (Object)(groups.toString() + "@@@" + groupName));
        } else {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP, (Object)groupName);
        }
        return Response.ok().build();
    }
}

