/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.space;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/space")
public class SpaceRestApi {
    private static final Logger log = Logger.getLogger(SpaceRestApi.class);
    private final SpaceManager spaceManager;
    private final SpaceDao spaceDao;
    private final GroupManager groupManager;
    private final PageManager pageManager;
    private final ConfluenceIndexer confluenceIndexer;
    private ToolsHelper toolsHelper;

    public SpaceRestApi(@ConfluenceImport PageManager pageManager, @ConfluenceImport SpaceManager spaceManager, @ConfluenceImport GroupManager groupManager, ToolsHelper toolsHelper) {
        this.spaceManager = spaceManager;
        this.groupManager = groupManager;
        this.pageManager = pageManager;
        this.confluenceIndexer = (ConfluenceIndexer)ComponentLocator.getComponent(ConfluenceIndexer.class);
        this.toolsHelper = toolsHelper;
        this.spaceDao = (SpaceDao)ComponentLocator.getComponent(SpaceDao.class);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceCreator/user/{userNameOrKey}")
    public Response changeSpaceCreator(String jsonString, @PathParam(value="userNameOrKey") String userNameOrKey) {
        userNameOrKey = this.toolsHelper.decodeUrlParam(userNameOrKey);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String newCreatorName = "";
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        ConfluenceUser oldConfluenceUser = this.toolsHelper.getConfluenceUserByName(userNameOrKey);
        if (oldConfluenceUser == null) {
            oldConfluenceUser = this.toolsHelper.getConfluenceUserByKey(userNameOrKey);
        }
        if (oldConfluenceUser == null) {
            return this.toolsHelper.userNotFound(userNameOrKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("userNameOrKey : " + userNameOrKey));
            log.debug((Object)("newCreatorName : " + newCreatorName));
        }
        ArrayList<String> spacesChanged = new ArrayList<String>();
        ArrayList<String> spacesSkipped = new ArrayList<String>();
        int spaceCount = 0;
        for (Space space : this.spaceDao.getSpacesCreatedByUser(oldConfluenceUser.getName())) {
            if (space != null && space.getSpaceType() != SpaceType.PERSONAL) {
                space.setCreator(confluenceUser);
                this.spaceManager.saveSpace(space);
                spacesChanged.add(space.getKey());
                ++spaceCount;
                continue;
            }
            spacesSkipped.add(space.getKey());
        }
        response.put("spacesSipped", spacesSkipped);
        response.put("spacesChanged", spacesChanged);
        response.put("total", spaceCount);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceCreator/space/{spaceKey}")
    public Response changeSpaceCreatorBySpaceKey(String jsonString, @PathParam(value="spaceKey") String spaceKey) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        HashMap<String, String> response = new HashMap<String, String>();
        String newCreatorName = "";
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (space.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(spaceKey);
        }
        if (jsonObject.isNull("newCreatorName") || jsonObject.getString("newCreatorName").equals("")) {
            return this.toolsHelper.fieldRequired("newCreatorName");
        }
        newCreatorName = jsonObject.getString("newCreatorName");
        ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByName(newCreatorName);
        if (confluenceUser == null) {
            return this.toolsHelper.userNotFound(newCreatorName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("spaceKey : " + spaceKey));
            log.debug((Object)("newCreatorName : " + newCreatorName));
        }
        space.setCreator(confluenceUser);
        this.spaceManager.saveSpace(space);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceStatus")
    public Response editSpace(String jsonString) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        String spaceKey = "";
        String status = "";
        if (!jsonObject.has("spaceKey") || jsonObject.isNull("spaceKey")) {
            return this.toolsHelper.fieldRequired("spaceKey");
        }
        spaceKey = jsonObject.getString("spaceKey");
        if (jsonObject.has("status") && !jsonObject.isNull("status")) {
            status = jsonObject.getString("status");
            if (!status.equalsIgnoreCase("archived") && !status.equalsIgnoreCase("current")) {
                return this.toolsHelper.fieldRequired("status");
            }
        } else {
            return this.toolsHelper.fieldRequired("status");
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        space.setSpaceStatus(status.equalsIgnoreCase("archived") ? SpaceStatus.ARCHIVED : SpaceStatus.CURRENT);
        this.spaceManager.saveSpace(space);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space status set to '" + status.toLowerCase() + "'");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/changeSpaceKey")
    public Response changeSpaceKey(String jsonString) {
        Space spaceOld;
        boolean reindexSpace;
        String newSpaceKey;
        String currentSpaceKey;
        block19: {
            JSONObject jsonObject;
            block18: {
                if (!this.toolsHelper.isLicenseIsValid()) {
                    return this.toolsHelper.licenseIsInvalid();
                }
                if (!this.toolsHelper.isConfluenceAdministrator()) {
                    return this.toolsHelper.permissionViolation();
                }
                jsonObject = new JSONObject(jsonString);
                currentSpaceKey = "";
                newSpaceKey = "";
                reindexSpace = false;
                try {
                    currentSpaceKey = jsonObject.getString("currentSpaceKey");
                }
                catch (Exception ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"currentSpaceKey is empty");
                    }
                    return this.toolsHelper.fieldRequired("currentSpaceKey");
                }
                if (currentSpaceKey == null || currentSpaceKey.equals("")) {
                    return this.toolsHelper.fieldRequired("newSpaceKey");
                }
                try {
                    newSpaceKey = jsonObject.getString("newSpaceKey");
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)"newSpaceKey is empty");
                }
            }
            if (newSpaceKey == null || newSpaceKey.equals("")) {
                return this.toolsHelper.fieldRequired("newSpaceKey");
            }
            try {
                reindexSpace = jsonObject.getBoolean("reindexSpace");
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block19;
                log.debug((Object)"reindexSpace is set - serror");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentSpaceKey : " + currentSpaceKey));
            log.debug((Object)("newSpaceKey : " + newSpaceKey));
            log.debug((Object)("reindexSpace : " + reindexSpace));
        }
        if ((spaceOld = this.toolsHelper.getSpaceFromSpaceDao(currentSpaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(currentSpaceKey);
        }
        if (spaceOld.getSpaceType().equals((Object)SpaceType.PERSONAL)) {
            return this.toolsHelper.spaceIsNotGlobal(currentSpaceKey);
        }
        Space spaceNew = this.toolsHelper.getSpaceFromSpaceDao(newSpaceKey);
        if (spaceNew != null) {
            return this.toolsHelper.spaceExists(newSpaceKey);
        }
        if (!Space.isValidGlobalSpaceKey((String)newSpaceKey)) {
            return this.toolsHelper.invalidSpaceKey(newSpaceKey);
        }
        spaceOld.setKey(newSpaceKey);
        this.spaceManager.saveSpace(spaceOld);
        if (reindexSpace) {
            List pages = this.pageManager.getPages(this.toolsHelper.getSpaceFromSpaceDao(newSpaceKey), true);
            for (Page page : pages) {
                this.rebuildAncestors(page);
                this.confluenceIndexer.reIndex((Searchable)page);
            }
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "space key '" + currentSpaceKey + "' changed to '" + newSpaceKey + "'");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getAllSpaces")
    public Response getAllSpaces(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="creationDateFrom") String creationDateFrom, @QueryParam(value="creationDateTo") String creationDateTo, @QueryParam(value="dateFormat") String dateFormatApi) throws ParseException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Map<String, String>> spaces = new HashMap<String, Map<String, String>>();
        Date from = new Date();
        Date to = new Date();
        boolean checkDateFrom = false;
        boolean checkDateTo = false;
        String dateFormat = "";
        String fullDateFormat = "";
        if (dateFormatApi == null || dateFormatApi.equals("")) {
            dateFormat = "yyyy-MM-dd";
            fullDateFormat = dateFormat + " HH:mm:ss";
        } else {
            dateFormat = dateFormatApi;
            fullDateFormat = dateFormatApi + " HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (creationDateFrom != null && !creationDateFrom.equals("")) {
            checkDateFrom = true;
            from = sdf.parse(creationDateFrom);
        }
        if (creationDateTo != null && !creationDateTo.equals("")) {
            checkDateTo = true;
            to = sdf.parse(creationDateTo);
        }
        int iterator = 0;
        int total = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        List<Space> spaceList = this.toolsHelper.getAllSpacesFormSpaceDao();
        for (Space space : spaceList) {
            if (!(!checkDateFrom && !checkDateTo || !checkDateFrom && checkDateTo && space.getCreationDate().compareTo(to) <= 0 || checkDateFrom && !checkDateTo && space.getCreationDate().compareTo(from) >= 0) && (!checkDateFrom || space.getCreationDate().compareTo(from) < 0 || !checkDateTo || space.getCreationDate().compareTo(to) > 0)) continue;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                String spaceKey = space.getKey();
                Map<String, String> spaceDetails = spaces.get(spaceKey) == null ? new HashMap() : (Map)spaces.get(spaceKey);
                spaceDetails.put("creationDate", (String)((Object)space.getCreationDate()));
                spaceDetails.put("creationDateString", sdfFull.format(space.getCreationDate()));
                spaceDetails.put("lastModificationDate", (String)((Object)space.getLastModificationDate()));
                spaceDetails.put("lastModificationDateString", sdfFull.format(space.getLastModificationDate()));
                spaceDetails.put("creatorName", space.getCreator() != null ? space.getCreator().getName() : "not exist");
                spaceDetails.put("key", space.getKey());
                spaceDetails.put("id", (String)((Object)Long.valueOf(space.getId())));
                spaceDetails.put("name", space.getName());
                spaceDetails.put("status", space.isArchived() ? "archived" : "current");
                spaces.put(spaceKey, spaceDetails);
            }
            ++iterator;
            ++total;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("spaces", spaces);
        response.put("total", Integer.valueOf(total));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getSpace/{spaceKey}")
    public Response getSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="dateFormat") String dateFormatApi) throws EntityException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        String fullDateFormat = "";
        fullDateFormat = dateFormatApi == null || dateFormatApi.equals("") ? "yyyy-MM-dd HH:mm:ss" : dateFormatApi + " HH:mm:ss";
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        response.put("creationDate", space.getCreationDate());
        response.put("creationDateString", sdfFull.format(space.getCreationDate()));
        response.put("lastModificationDate", space.getLastModificationDate());
        response.put("lastModificationDateString", sdfFull.format(space.getLastModificationDate()));
        response.put("creatorName", space.getCreator() != null ? space.getCreator().getName() : "not exist");
        response.put("key", space.getKey());
        response.put("id", space.getId());
        response.put("name", space.getName());
        response.put("status", space.isArchived() ? "archived" : "current");
        return Response.ok(response).build();
    }

    private boolean isCurrentUserIsSpaceAdministrator(Space space) throws EntityException {
        UserProfile userProfile = this.toolsHelper.getCurrentUserProfile();
        User user = this.toolsHelper.getUserByName(userProfile.getUsername());
        Map groups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        if (log.isDebugEnabled()) {
            log.debug((Object)("groups: " + groups));
            log.debug((Object)("users: " + users));
        }
        if (users.get(userProfile.getUsername()) != null) {
            return true;
        }
        for (Map.Entry entry : groups.entrySet()) {
            Group group = this.groupManager.getGroup((String)entry.getKey());
            if (!this.groupManager.hasMembership(group, user)) continue;
            return true;
        }
        return false;
    }

    private void rebuildAncestors(Page page) {
        page.getAncestors().clear();
        if (page.getParent() != null) {
            page.getAncestors().addAll(page.getParent().getAncestors());
            page.getAncestors().add(page.getParent());
        }
    }
}

