/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.permission;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.administrators.PermissionsAdministrator;
import com.atlassian.confluence.security.administrators.PermissionsAdministratorBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/permission")
public class PermissionRestApi {
    private static final Logger log = Logger.getLogger(PermissionRestApi.class);
    private final GroupManager groupManager;
    private final ContentPermissionManager contentPermissionManager;
    private final UserAccessor userAccessor;
    private ToolsHelper toolsHelper;
    List<String> globalPermissions = new ArrayList<String>(Arrays.asList("USECONFLUENCE", "PERSONALSPACE", "CREATESPACE", "ADMINISTRATECONFLUENCE", "SYSTEMADMINISTRATOR"));

    public PermissionRestApi(@ConfluenceImport GroupManager groupManager, @ConfluenceImport ContentPermissionManager contentPermissionManager, @ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.contentPermissionManager = contentPermissionManager;
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getInheritedContentTreePermissions")
    public Response getInheritedContentTreePermissions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="permissionType") String permissionType, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        Page page;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentId :: " + contentId));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(contentId)) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        return this.getInheritedContentPermissionsResponse(page, showContentDetails, true, permissionType, startAt, maxResults);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getInheritedContentPermissions")
    public Response getInheritedContentPermissions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="permissionType") String permissionType, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        Page page;
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentId :: " + contentId));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(contentId)) == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        return this.getInheritedContentPermissionsResponse(page, showContentDetails, false, permissionType, startAt, maxResults);
    }

    private Set<String> getGroupFullContentPermissionList(Set<String> fullContentPermissionList, String groupName, Space space, List<Page> tree, String permissionType) {
        boolean hasSpaceViewPermission = false;
        boolean hasSpaceEditPermission = false;
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
            hasSpaceViewPermission = this.spaceHasAnonymousPermission(space, "VIEWSPACE") ? true : this.groupHasSpacePermission(groupName, space, "VIEWSPACE");
        }
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
            hasSpaceEditPermission = this.spaceHasAnonymousPermission(space, "EDITSPACE") ? true : this.groupHasSpacePermission(groupName, space, "EDITSPACE");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        for (Page pageFromTree : tree) {
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
                boolean bl = inheriteViewPermission = inheriteViewPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "View", (ContentEntityObject)pageFromTree) : false;
            }
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
                inheriteEditPermission = hasSpaceEditPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "Edit", (ContentEntityObject)pageFromTree) : false;
            }
            String temp = "";
            if ((permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) && !fullContentPermissionList.contains(temp = "group@@" + groupName + "@@" + pageFromTree.getIdAsString() + "@@view" + inheriteViewPermission)) {
                fullContentPermissionList.add(temp);
            }
            if (!permissionType.equalsIgnoreCase("all") && !permissionType.equalsIgnoreCase("edit") || fullContentPermissionList.contains(temp = "group@@" + groupName + "@@" + pageFromTree.getIdAsString() + "@@edit" + inheriteEditPermission)) continue;
            fullContentPermissionList.add(temp);
        }
        return fullContentPermissionList;
    }

    private Set<String> getUserFullContentPermissionList(Set<String> fullContentPermissionList, String userName, Space space, List<Page> tree, String permissionType) {
        boolean hasSpaceViewPermission = false;
        boolean hasSpaceEditPermission = false;
        ConfluenceUser user = this.toolsHelper.getConfluenceUserByName(userName);
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
            hasSpaceViewPermission = this.spaceHasAnonymousPermission(space, "VIEWSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("VIEWSPACE", space, (User)user);
        }
        if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
            hasSpaceEditPermission = this.spaceHasAnonymousPermission(space, "EDITSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("EDITSPACE", space, (User)user);
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        for (Page pageFromTree : tree) {
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) {
                boolean bl = inheriteViewPermission = inheriteViewPermission ? this.userHasInheritedContentPermissionPersonalOrGroup((User)user, "View", (ContentEntityObject)pageFromTree) : false;
            }
            if (permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("edit")) {
                inheriteEditPermission = hasSpaceEditPermission ? this.userHasInheritedContentPermissionPersonalOrGroup((User)user, "Edit", (ContentEntityObject)pageFromTree) : false;
            }
            String temp = "";
            if ((permissionType.equalsIgnoreCase("all") || permissionType.equalsIgnoreCase("view")) && !fullContentPermissionList.contains(temp = "user@@" + userName + "@@" + pageFromTree.getIdAsString() + "@@view" + inheriteViewPermission)) {
                fullContentPermissionList.add(temp);
            }
            if (!permissionType.equalsIgnoreCase("all") && !permissionType.equalsIgnoreCase("edit") || fullContentPermissionList.contains(temp = "user@@" + userName + "@@" + pageFromTree.getIdAsString() + "@@edit" + inheriteEditPermission)) continue;
            fullContentPermissionList.add(temp);
        }
        return fullContentPermissionList;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/getContentTreeRestrictions")
    public Response getContentTreeRestrictions(@PathParam(value="contentId") long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentId :: " + contentId));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        ArrayList<Page> tree = new ArrayList<Page>();
        if (page.getParent() != null) {
            this.buildTree(tree, page);
        } else {
            tree.add(page);
        }
        Collections.reverse(tree);
        int level = 1;
        ArrayList treeArray = new ArrayList();
        for (Page pageFromTree : tree) {
            HashMap<String, Object> treeMap = new HashMap<String, Object>();
            if (showContentDetails) {
                treeMap.put("contentName", pageFromTree.getTitle());
                treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
            }
            treeMap.put("contentId", pageFromTree.getId());
            treeMap.put("level", level);
            treeMap.put("restrictions", this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults));
            ++level;
            treeArray.add(treeMap);
        }
        response.put("contentTree", treeArray);
        return Response.ok(response).build();
    }

    private Response getInheritedContentPermissionsResponse(Page page, boolean showContentDetails, boolean fullTree, String permissionType, int startAt, int maxResults) {
        Map viewMap;
        Map editMap;
        Map<String, Object> pageRestrictions;
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (permissionType == null || !permissionType.equalsIgnoreCase("edit") && !permissionType.equalsIgnoreCase("view")) {
            permissionType = "all";
        }
        Set<String> fullContentPermissionList = new HashSet<String>();
        ArrayList<String> groupsWithPermissionsList = new ArrayList<String>();
        ArrayList<String> usersWithPermissionsList = new ArrayList<String>();
        Map groupsWithPermissions = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("VIEWSPACE", page.getSpace());
        Map usersWithPermissions = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", page.getSpace());
        for (Map.Entry entry : groupsWithPermissions.entrySet()) {
            groupsWithPermissionsList.add((String)entry.getKey());
        }
        for (Map.Entry entry : usersWithPermissions.entrySet()) {
            usersWithPermissionsList.add((String)entry.getKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("groupsWithPermissionsList: " + groupsWithPermissionsList));
            log.debug((Object)("usersWithPermissionsList: " + usersWithPermissionsList));
        }
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        ArrayList<Page> tree = new ArrayList<Page>();
        if (page.getParent() != null) {
            this.buildTree(tree, page);
        } else {
            tree.add(page);
        }
        Collections.reverse(tree);
        int level = 1;
        for (String userName : usersWithPermissionsList) {
            fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userName, page.getSpace(), tree, permissionType);
        }
        for (Page pageFromTree : tree) {
            List users;
            pageRestrictions = this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults);
            if (pageRestrictions.get("edit") != null && (editMap = (Map)pageRestrictions.get("edit")).get("users") != null) {
                users = (List)editMap.get("users");
                for (String userContentRestriction : users) {
                    fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userContentRestriction, page.getSpace(), tree, permissionType);
                }
            }
            if (pageRestrictions.get("view") == null || (viewMap = (Map)pageRestrictions.get("view")).get("users") == null) continue;
            users = (List)viewMap.get("users");
            for (String userContentRestriction : users) {
                fullContentPermissionList = this.getUserFullContentPermissionList(fullContentPermissionList, userContentRestriction, page.getSpace(), tree, permissionType);
            }
        }
        for (String groupName : groupsWithPermissionsList) {
            fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupName, page.getSpace(), tree, permissionType);
        }
        for (Page pageFromTree : tree) {
            List groups;
            pageRestrictions = this.getContentRestrictionMap((ContentEntityObject)pageFromTree, startAt, maxResults);
            if (pageRestrictions.get("edit") != null && (editMap = (Map)pageRestrictions.get("edit")).get("groups") != null) {
                groups = (List)editMap.get("groups");
                for (String groupContentRestriction : groups) {
                    fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupContentRestriction, page.getSpace(), tree, permissionType);
                }
            }
            if (pageRestrictions.get("view") == null || (viewMap = (Map)pageRestrictions.get("view")).get("groups") == null) continue;
            groups = (List)viewMap.get("groups");
            for (String groupContentRestriction : groups) {
                fullContentPermissionList = this.getGroupFullContentPermissionList(fullContentPermissionList, groupContentRestriction, page.getSpace(), tree, permissionType);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fullContentPermissionList: " + fullContentPermissionList));
        }
        if (fullTree) {
            ArrayList treeArray = new ArrayList();
            for (Page pageFromTree : tree) {
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("permissions", this.getInheritedContentTreePermissionsResponse((ContentEntityObject)pageFromTree, fullContentPermissionList, startAt, maxResults));
                ++level;
                treeArray.add(treeMap);
            }
            response.put("contentTree", treeArray);
        } else {
            response.put("level", tree.size());
            response.put("permissions", this.getInheritedContentTreePermissionsResponse((ContentEntityObject)tree.get(tree.size() - 1), fullContentPermissionList, startAt, maxResults));
        }
        return Response.ok(response).build();
    }

    private Map<String, Object> getInheritedContentTreePermissionsResponse(ContentEntityObject contentObject, Set<String> fullContentPermissionList, int startAt, int maxResults) {
        HashMap viewPermissions = new HashMap();
        HashMap editPermissions = new HashMap();
        ArrayList<String> viewGroups = new ArrayList<String>();
        ArrayList<String> viewUsers = new ArrayList<String>();
        ArrayList<String> editGroups = new ArrayList<String>();
        ArrayList<String> editUsers = new ArrayList<String>();
        if (maxResults == 0) {
            maxResults = 50;
        }
        int viewUsersTotal = 0;
        int editUsersTotal = 0;
        int viewGroupsTotal = 0;
        int editGroupsTotal = 0;
        String contentId = contentObject.getIdAsString();
        for (String text : fullContentPermissionList) {
            if (!text.contains("@@" + contentId + "@@")) continue;
            if (text.startsWith("user") && text.contains("@@viewtrue")) {
                if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                    viewUsers.add(text.split("@@")[1]);
                }
                ++viewUsersTotal;
                continue;
            }
            if (text.startsWith("user") && text.contains("@@edittrue")) {
                if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                    editUsers.add(text.split("@@")[1]);
                }
                ++editUsersTotal;
                continue;
            }
            if (text.startsWith("group") && text.contains("@@viewtrue")) {
                if (startAt <= viewGroupsTotal && viewGroupsTotal < startAt + maxResults) {
                    viewGroups.add(text.split("@@")[1]);
                }
                ++viewGroupsTotal;
                continue;
            }
            if (!text.startsWith("group") || !text.contains("@@edittrue")) continue;
            if (startAt <= editGroupsTotal && editGroupsTotal < startAt + maxResults) {
                editGroups.add(text.split("@@")[1]);
            }
            ++editGroupsTotal;
        }
        if (!viewGroups.isEmpty()) {
            viewPermissions.put("groups", viewGroups);
        }
        if (!viewUsers.isEmpty()) {
            viewPermissions.put("users", viewUsers);
        }
        if (!editGroups.isEmpty()) {
            editPermissions.put("groups", editGroups);
        }
        if (!editUsers.isEmpty()) {
            editPermissions.put("users", editUsers);
        }
        HashMap<String, Object> allPermissions = new HashMap<String, Object>();
        if (!(viewGroups.isEmpty() && viewUsers.isEmpty() && editGroups.isEmpty() && editUsers.isEmpty())) {
            allPermissions.put("edit", editPermissions);
            allPermissions.put("view", viewPermissions);
        }
        allPermissions.put("viewUsersTotal", viewUsersTotal);
        allPermissions.put("editUsersTotal", editUsersTotal);
        allPermissions.put("viewGroupsTotal", viewGroupsTotal);
        allPermissions.put("editGroupsTotal", editGroupsTotal);
        return allPermissions;
    }

    private Map<String, Object> getContentRestrictionMap(ContentEntityObject contentObject, int startAt, int maxResults) {
        List viewPermissionsList = this.contentPermissionManager.getContentPermissionSets(contentObject, "View");
        List editPermissionsList = this.contentPermissionManager.getContentPermissionSets(contentObject, "Edit");
        String everyone = "can view";
        HashMap viewPermissions = new HashMap();
        HashMap editPermissions = new HashMap();
        if (maxResults == 0) {
            maxResults = 50;
        }
        int viewUsersTotal = 0;
        int editUsersTotal = 0;
        int viewGroupsTotal = 0;
        int editGroupsTotal = 0;
        ArrayList<String> viewGroups = new ArrayList<String>();
        ArrayList<String> viewUsers = new ArrayList<String>();
        for (ContentPermissionSet contentPermissionSet : viewPermissionsList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(contentObject.getContentId().toString() + " :viewPermissions: " + contentPermissionSet.getType().toLowerCase()));
            }
            for (String groupName : contentPermissionSet.getGroupNames()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(contentObject.getContentId().toString() + " :viewPermissions: group: " + groupName + " | " + contentPermissionSet.getOwningContent().getIdAsString()));
                }
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || viewGroups.contains(groupName)) continue;
                if (startAt <= viewGroupsTotal && viewGroupsTotal < startAt + maxResults) {
                    viewGroups.add(groupName);
                }
                ++viewGroupsTotal;
            }
            for (UserKey userKey : contentPermissionSet.getUserKeys()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(contentObject.getContentId().toString() + " :viewPermissions: userKey: " + userKey + " | " + contentPermissionSet.getOwningContent().getIdAsString()));
                }
                ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(userKey.getStringValue());
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || confluenceUser == null || viewUsers.contains(confluenceUser.getName())) continue;
                if (startAt <= viewUsersTotal && viewUsersTotal < startAt + maxResults) {
                    viewUsers.add(confluenceUser.getName());
                }
                ++viewUsersTotal;
            }
        }
        if (!viewGroups.isEmpty()) {
            viewPermissions.put("groups", viewGroups);
        }
        if (!viewUsers.isEmpty()) {
            viewPermissions.put("users", viewUsers);
        }
        ArrayList<String> editGroups = new ArrayList<String>();
        ArrayList<String> editUsers = new ArrayList<String>();
        for (ContentPermissionSet contentPermissionSet : editPermissionsList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(contentObject.getContentId().toString() + " :editPermissions: " + contentPermissionSet.getType().toLowerCase()));
            }
            for (String groupName : contentPermissionSet.getGroupNames()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(contentObject.getContentId().toString() + " :editPermissions: group: " + groupName + " | " + contentPermissionSet.getOwningContent().getIdAsString()));
                }
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || editGroups.contains(groupName)) continue;
                if (startAt <= editGroupsTotal && editGroupsTotal < startAt + maxResults) {
                    editGroups.add(groupName);
                }
                ++editGroupsTotal;
                if (!viewGroups.contains(groupName)) continue;
                everyone = "has no access";
            }
            for (UserKey userKey : contentPermissionSet.getUserKeys()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(contentObject.getContentId().toString() + " :editPermissions: userKey: " + userKey + " | " + contentPermissionSet.getOwningContent().getIdAsString()));
                }
                ConfluenceUser confluenceUser = this.toolsHelper.getConfluenceUserByKey(userKey.getStringValue());
                if (!contentObject.getIdAsString().equals(contentPermissionSet.getOwningContent().getIdAsString()) || confluenceUser == null || editUsers.contains(confluenceUser.getName())) continue;
                if (startAt <= editUsersTotal && editUsersTotal < startAt + maxResults) {
                    editUsers.add(confluenceUser.getName());
                }
                ++editUsersTotal;
                if (!viewUsers.contains(confluenceUser.getName())) continue;
                everyone = "has no access";
            }
        }
        if (!editGroups.isEmpty()) {
            editPermissions.put("groups", editGroups);
        }
        if (!editUsers.isEmpty()) {
            editPermissions.put("users", editUsers);
        }
        HashMap<String, Object> allPermissions = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.debug((Object)(contentObject.getIdAsString() + " viewGroups: " + viewGroups));
            log.debug((Object)(contentObject.getIdAsString() + " viewUsers: " + viewUsers));
            log.debug((Object)(contentObject.getIdAsString() + " editGroups: " + editGroups));
            log.debug((Object)(contentObject.getIdAsString() + " editUsers: " + editUsers));
        }
        if (!(viewGroups.isEmpty() && viewUsers.isEmpty() && editGroups.isEmpty() && editUsers.isEmpty())) {
            allPermissions.put("edit", editPermissions);
            allPermissions.put("view", viewPermissions);
            allPermissions.put("everyone", everyone);
        }
        allPermissions.put("viewUsersTotal", viewUsersTotal);
        allPermissions.put("editUsersTotal", editUsersTotal);
        allPermissions.put("viewGroupsTotal", viewGroupsTotal);
        allPermissions.put("editGroupsTotal", editGroupsTotal);
        return allPermissions;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/permissionTypes")
    public Response getGlobalPermissions() {
        return Response.ok(this.globalPermissions).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/getAllGlobalPermissions")
    public Response globalGetAllPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, Object> permissionObject = new HashMap<String, Object>();
                permissionObject.put("isGroupPermission", spacePermission.isGroupPermission());
                if (spacePermission.isGroupPermission()) {
                    permissionObject.put("groupName", spacePermission.getGroup());
                }
                permissionObject.put("isAnonymousPermission", spacePermission.isAnonymousPermission());
                permissionObject.put("isUserPermission", spacePermission.isUserPermission());
                if (spacePermission.isUserPermission()) {
                    if (spacePermission.getUserSubject() != null) {
                        permissionObject.put("userName", spacePermission.getUserSubject().getName());
                    } else {
                        permissionObject.put("userName", "unknown user");
                    }
                }
                permissionObject.put("permissionType", spacePermission.getType());
                allPermissions.add(permissionObject);
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(permissionsAdministrator.getPermissions().size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/group/getAllGlobalPermissions")
    public Response getAllGroupsGlobalPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        int totalPermissions = 0;
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, String> permissionObject = new HashMap<String, String>();
                if (spacePermission.isGroupPermission()) {
                    permissionObject.put("groupName", spacePermission.getGroup());
                    permissionObject.put("permissionType", spacePermission.getType());
                    allPermissions.add(permissionObject);
                }
            }
            if (spacePermission.isGroupPermission()) {
                ++totalPermissions;
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(totalPermissions));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/global/user/getAllGlobalPermissions")
    public Response getAllUsersGlobalPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
        PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
        ArrayList allPermissions = new ArrayList();
        int totalPermissions = 0;
        for (SpacePermission spacePermission : permissionsAdministrator.getPermissions()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                HashMap<String, String> permissionObject = new HashMap<String, String>();
                if (spacePermission.isUserPermission()) {
                    if (spacePermission.getUserSubject() != null) {
                        permissionObject.put("userName", spacePermission.getUserSubject().getName());
                    } else {
                        permissionObject.put("userName", "unknown user");
                    }
                    permissionObject.put("permissionType", spacePermission.getType());
                    allPermissions.add(permissionObject);
                }
            }
            if (spacePermission.isUserPermission()) {
                ++totalPermissions;
            }
            ++iterator;
        }
        response.put("permissions", allPermissions);
        response.put("total", Integer.valueOf(totalPermissions));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/group/{groupName}/permission/{permissionType}/addGlobalPermission")
    public Response globalAddGroupPermission(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator()) {
            if (permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
            if (this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
        }
        if (groupName.equalsIgnoreCase("confluence-administrators")) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.objectHasGlobalPermission("group", groupName, permissionType)) {
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permissionType, null, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            response.put("status", "permission added");
        } else {
            response.put("status", "permission is omitted, group '" + groupName + "' has '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/global/user/{userName}/permission/{permissionType}/addGlobalPermission")
    public Response globalAddUserPermission(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.isSystemAdministrator(userName)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        User user = this.toolsHelper.getUserByName(userName);
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.objectHasGlobalPermission("user", userName, permissionType)) {
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permissionType, null, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            response.put("status", "permission added");
        } else {
            response.put("status", "permission is omitted, user '" + userName + "' has '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/global/group/{groupName}/permission/{permissionType}/removeGlobalPermission")
    public Response globalRemoveGroupPermission(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator()) {
            if (permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
            if (this.toolsHelper.objectHasGlobalPermission("group", groupName, "SYSTEMADMINISTRATOR")) {
                return this.toolsHelper.permissionViolation();
            }
        }
        if (groupName.equalsIgnoreCase("confluence-administrators")) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (this.toolsHelper.objectHasGlobalPermission("group", groupName, permissionType)) {
            PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
            PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
            for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
                if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !permission.getType().equalsIgnoreCase(permissionType)) continue;
                this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            }
            response.put("status", "permission removed");
        } else {
            response.put("status", "permission is omitted, group '" + groupName + "' does not have '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/global/user/{userName}/permission/{permissionType}/removeGlobalPermission")
    public Response globalRemoveUserPermission(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && permissionType.equalsIgnoreCase("SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.isSystemAdministrator(userName)) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidGlobalPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (this.toolsHelper.objectHasGlobalPermission("user", userName, permissionType)) {
            PermissionsAdministratorBuilder permissionsAdministratorBuilder = (PermissionsAdministratorBuilder)ComponentLocator.getComponent(PermissionsAdministratorBuilder.class);
            PermissionsAdministrator permissionsAdministrator = permissionsAdministratorBuilder.buildGlobalPermissionAdministrator();
            for (SpacePermission permission : permissionsAdministrator.getPermissions()) {
                if (!permission.isUserPermission() || !permission.getType().equalsIgnoreCase(permissionType) || permission.getUserSubject() == null || !permission.getUserSubject().getName().equals(userName)) continue;
                this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            }
            response.put("status", "permission removed");
        } else {
            response.put("status", "permission is omitted, user '" + userName + "' does not have '" + permissionType + "' permission");
        }
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/removeAllContentPermission")
    public Response removeAllGroupContentPermissions(@PathParam(value="groupName") String groupName) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        this.contentPermissionManager.removeAllGroupPermissions(groupName);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/removeAllContentPermission")
    public Response removeAllUserContentPermissions(@PathParam(value="userName") String userName) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        this.contentPermissionManager.removeAllUserPermissions(confluenceUser);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "done");
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/addContentPermission")
    public Response addGroupContentIdPermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        return this.addGroupContentIdPermission(groupName, jsonString, permissionType);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/space/{spaceKey}/addContentPermission")
    public Response addGroupContentNamePermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.addGroupContentNamePermission(groupName, spaceKey, jsonString, permissionType);
    }

    private Response addGroupContentNamePermission(String groupName, String spaceKey, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("groupName :: " + groupName));
                    log.debug((Object)("contentId :: " + contentName));
                    log.debug((Object)("permissionType :: " + permissionType));
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equals("edit") ? this.addGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.addGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                added.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response addGroupContentIdPermission(String groupName, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> added = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("groupName :: " + groupName));
                    log.debug((Object)("contentId :: " + contentId));
                    log.debug((Object)("permissionType :: " + permissionType));
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equals("edit") ? this.addGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.addGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                added.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean addGroupContentPermission(String permissionType, ContentEntityObject contentObject, String groupName) {
        if (!this.groupIsAddedToContentPermission(contentObject, permissionType, groupName)) {
            ContentPermission newPermission = ContentPermission.createGroupPermission((String)permissionType, (String)groupName);
            this.contentPermissionManager.addContentPermission(newPermission, contentObject);
            return false;
        }
        return true;
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/addContentPermission")
    public Response addUserContentIdPermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) {
        return this.addUserContentIdPermission(userName, jsonString, permissionType);
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/space/{spaceKey}/addContentPermission")
    public Response addUserContentNamePermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) {
        return this.addUserContentNamePermission(userName, spaceKey, jsonString, permissionType);
    }

    private Response addUserContentIdPermission(String userName, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> added = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("userName :: " + userName));
                    log.debug((Object)("contentId :: " + contentId));
                }
                boolean skippedFlag = false;
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                skippedFlag = permissionType.equals("edit") ? this.addUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser) : this.addUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                added.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response addUserContentNamePermission(String userName, String spaceKey, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("userName :: " + userName));
                    log.debug((Object)("spaceKey :: " + spaceKey));
                    log.debug((Object)("contentName :: " + contentName));
                    log.debug((Object)("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#")));
                }
                boolean skippedFlag = false;
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                skippedFlag = permissionType.equals("edit") ? this.addUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser) : this.addUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                added.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("added", added);
        response.put("total", added.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean addUserContentPermission(String permissionType, ContentEntityObject contentObject, ConfluenceUser user) {
        if (!this.userIsAddedToContentPermission(contentObject, permissionType, user)) {
            ContentPermission permission = ContentPermission.createUserPermission((String)permissionType, (ConfluenceUser)user);
            this.contentPermissionManager.addContentPermission(permission, contentObject);
            return false;
        }
        return true;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/removeContentPermission")
    public Response removeGroupContentIdPermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType) throws EntityException {
        return this.removeGroupContentIdPermission(groupName, jsonString, permissionType);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/group/{groupName}/permission/{permissionType}/space/{spaceKey}/removeContentPermission")
    public Response removeGroupContentNamePermissionView(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        return this.removeGroupContentNamePermission(groupName, spaceKey, jsonString, permissionType);
    }

    private Response removeGroupContentNamePermission(String groupName, String spaceKey, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("groupName :: " + groupName));
                    log.debug((Object)("spaceKey :: " + spaceKey));
                    log.debug((Object)("contentName :: " + contentName));
                    log.debug((Object)("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#")));
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equalsIgnoreCase("edit") ? this.removeGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.removeGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentName);
                    continue;
                }
                removed.add(contentName);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response removeGroupContentIdPermission(String groupName, String jsonString, String permissionType) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> removed = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("groupName :: " + groupName));
                    log.debug((Object)("contentId :: " + contentId));
                    log.debug((Object)("permissionType :: " + permissionType));
                }
                boolean skippedFlag = false;
                skippedFlag = permissionType.equalsIgnoreCase("edit") ? this.removeGroupContentPermission("Edit", (ContentEntityObject)page, groupName) : this.removeGroupContentPermission("View", (ContentEntityObject)page, groupName);
                if (skippedFlag) {
                    skipped.add(contentId);
                    continue;
                }
                removed.add(contentId);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private boolean removeGroupContentPermission(String permissionType, ContentEntityObject contentObject, String groupName) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        ArrayList<ContentPermission> contentPermissionToRemove = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                contentPermissionToRemove.add(contentPermission);
            }
        }
        for (ContentPermission contentPermission : contentPermissionToRemove) {
            this.contentPermissionManager.removeContentPermission(contentPermission);
        }
        return contentPermissionToRemove.isEmpty();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/removeContentPermission")
    public Response removeUserContentIdPermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType) {
        return this.removeUserContentIdPermission(userName, jsonString, permissionType);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/content/user/{userName}/permission/{permissionType}/space/{spaceKey}/removeContentPermission")
    public Response removeUserContentNamePermissionView(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="permissionType") String permissionType, @PathParam(value="spaceKey") String spaceKey) {
        return this.removeUserContentNamePermission(userName, spaceKey, jsonString, permissionType);
    }

    private Response removeUserContentNamePermission(String userName, String spaceKey, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> contentList = this.toolsHelper.getJSONarray(jsonObject, "contents");
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String contentName : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName);
            if (page != null) {
                removed.add(contentName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("userName :: " + userName));
                    log.debug((Object)("spaceKey :: " + spaceKey));
                    log.debug((Object)("contentName :: " + contentName));
                    log.debug((Object)("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#")));
                }
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                if (permissionType.equalsIgnoreCase("edit")) {
                    this.removeUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser);
                    continue;
                }
                this.removeUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                continue;
            }
            skipped.add(contentName);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private Response removeUserContentIdPermission(String userName, String jsonString, String permissionType) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.isValidPermissionType(permissionType)) {
            return this.toolsHelper.permissionTypeNotExist(permissionType);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<Long> contentList = this.toolsHelper.getLongJSONarray(jsonObject, "contents");
        ArrayList<Long> removed = new ArrayList<Long>();
        ArrayList<Long> skipped = new ArrayList<Long>();
        for (Long contentId : contentList) {
            Page page = this.toolsHelper.getPageFormPageDao(contentId);
            if (page != null) {
                removed.add(contentId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("userName :: " + userName));
                    log.debug((Object)("contentId :: " + contentId));
                }
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
                if (permissionType.equals("edit")) {
                    this.removeUserContentPermission("Edit", (ContentEntityObject)page, confluenceUser);
                    continue;
                }
                this.removeUserContentPermission("View", (ContentEntityObject)page, confluenceUser);
                continue;
            }
            skipped.add(contentId);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("skipped", skipped);
        response.put("removed", removed);
        response.put("total", removed.size());
        response.put("status", "done");
        return Response.ok(response).build();
    }

    private void removeUserContentPermission(String permissionType, ContentEntityObject contentObject, ConfluenceUser user) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        ArrayList<ContentPermission> contentPermissionToRemove = new ArrayList<ContentPermission>();
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isUserPermission() || !contentPermission.getUserSubject().getKey().equals((Object)user.getKey())) continue;
                contentPermissionToRemove.add(contentPermission);
            }
        }
        for (ContentPermission contentPermission : contentPermissionToRemove) {
            this.contentPermissionManager.removeContentPermission(contentPermission);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/user/{userName}/getContentPermission")
    public Response getUserContentRestrictionsPageAll(@PathParam(value="userName") String userName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails) {
        return this.getUserContentWithRestrictions(userName, contentId, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/user/{userName}/space/{spaceKey}/getContentPermission")
    public Response getUserContentRestrictionsPageByNameAll(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails) {
        return this.getUserContentWithRestrictionsByName(userName, spaceKey, contentName, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/group/{groupName}/getContentPermission")
    public Response getGroupContentRestrictionsPageAll(@PathParam(value="groupName") String groupName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails) throws EntityException {
        return this.getGroupContentWithRestrictions(groupName, contentId, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/group/{groupName}/space/{spaceKey}/getContentPermission")
    public Response getGroupContentRestrictionsPageByNameAll(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails) throws EntityException {
        return this.getGroupContentWithRestrictionsByName(groupName, spaceKey, contentName, showContentDetails, false, false, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/user/{userName}/getInheritedContentPermission")
    public Response getUserInheriteContentRestrictionsPageAll(@PathParam(value="userName") String userName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) {
        return this.getUserContentWithRestrictions(userName, contentId, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/user/{userName}/space/{spaceKey}/getInheritedContentPermission")
    public Response getUserInheriteContentRestrictionsPageByNameAll(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) {
        return this.getUserContentWithRestrictionsByName(userName, spaceKey, contentName, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentId}/group/{groupName}/getInheritedContentPermission")
    public Response getGroupInheriteGroupContentRestrictionsPageAll(@PathParam(value="groupName") String groupName, @PathParam(value="contentId") Long contentId, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) throws EntityException {
        return this.getGroupContentWithRestrictions(groupName, contentId, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/content/{contentName}/group/{groupName}/space/{spaceKey}/getInheritedContentPermission")
    public Response getGroupInheriteGroupContentRestrictionsPageByNameAll(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey, @PathParam(value="contentName") String contentName, @QueryParam(value="showContentDetails") boolean showContentDetails, @QueryParam(value="showSpaceAdministrators") boolean showSpaceAdministrators, @QueryParam(value="showBasicDetails") boolean showBasicDetails) throws EntityException {
        return this.getGroupContentWithRestrictionsByName(groupName, spaceKey, contentName, showContentDetails, true, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictionsByName(String groupName, String spaceKey, String contentName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) throws EntityException {
        Page page;
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("groupName :: " + groupName));
            log.debug((Object)("spaceKey :: " + spaceKey));
            log.debug((Object)("contentTree :: " + contentTree));
            log.debug((Object)("contentName :: " + contentName));
            log.debug((Object)("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#")));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"))) == null) {
            return this.toolsHelper.contentNameNotExist(contentName);
        }
        return this.getGroupContentWithRestrictionsGlobal(page, groupName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictions(String groupName, Long contentId, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("groupName :: " + groupName));
            log.debug((Object)("contentId :: " + contentId));
            log.debug((Object)("contentTree :: " + contentTree));
        }
        return this.getGroupContentWithRestrictionsGlobal(page, groupName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getGroupContentWithRestrictionsGlobal(Page page, String groupName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        boolean hasSpaceViewPermission = this.spaceHasAnonymousPermission(page.getSpace(), "VIEWSPACE") ? true : this.groupHasSpacePermission(groupName, page.getSpace(), "VIEWSPACE");
        boolean hasSpaceEditPermission = this.spaceHasAnonymousPermission(page.getSpace(), "EDITSPACE") ? true : this.groupHasSpacePermission(groupName, page.getSpace(), "EDITSPACE");
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        if (contentTree) {
            response.put("hasSpaceViewPermission", hasSpaceViewPermission);
            response.put("hasSpaceEditPermission", hasSpaceEditPermission);
            ArrayList<Page> tree = new ArrayList<Page>();
            if (page.getParent() != null) {
                this.buildTree(tree, page);
            } else {
                tree.add(page);
            }
            Collections.reverse(tree);
            int level = 1;
            ArrayList treeArray = new ArrayList();
            for (Page pageFromTree : tree) {
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                inheriteViewPermission = inheriteViewPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "View", (ContentEntityObject)pageFromTree) : false;
                boolean bl = inheriteEditPermission = hasSpaceEditPermission ? this.groupHasInheritedContentPermission(inheriteViewPermission, groupName, "Edit", (ContentEntityObject)pageFromTree) : false;
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("hasContentViewPermission", inheriteViewPermission);
                treeMap.put("hasContentEditPermission", inheriteEditPermission);
                ++level;
                treeArray.add(treeMap);
            }
            response.put("hasContentViewPermission", inheriteViewPermission);
            response.put("hasContentEditPermission", inheriteEditPermission);
            response.put("contentTree", treeArray);
        } else {
            response.put("hasContentViewPermission", this.groupHasContentPermission(groupName, "View", (ContentEntityObject)page));
            response.put("hasContentEditPermission", this.groupHasContentPermission(groupName, "Edit", (ContentEntityObject)page));
        }
        if (showSpaceAdministrators) {
            response.put("spaceAdministrators", this.getSpaceAdministrators(page.getSpace(), showBasicDetails));
        }
        return Response.ok(response).build();
    }

    private Response getUserContentWithRestrictionsByName(String userName, String spaceKey, String contentName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        Page page;
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("userName :: " + userName));
            log.debug((Object)("spaceKey :: " + spaceKey));
            log.debug((Object)("contentName :: " + contentName));
            log.debug((Object)("contentName :: " + contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#")));
        }
        if ((page = this.toolsHelper.getPageFormPageDao(spaceKey, contentName.replaceAll("@hash@", "#").replaceAll("@HASH@", "#"))) == null) {
            return this.toolsHelper.contentNameNotExist(contentName);
        }
        return this.getUserContentWithRestrictionsGlobal(page, userName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getUserContentWithRestrictions(String userName, Long contentId, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Page page = this.toolsHelper.getPageFormPageDao(contentId);
        if (page == null) {
            return this.toolsHelper.contentIdNotExist(contentId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("userName :: " + userName));
            log.debug((Object)("contentId :: " + contentId));
        }
        return this.getUserContentWithRestrictionsGlobal(page, userName, showContentDetails, contentTree, showSpaceAdministrators, showBasicDetails);
    }

    private Response getUserContentWithRestrictionsGlobal(Page page, String userName, boolean showContentDetails, boolean contentTree, boolean showSpaceAdministrators, boolean showBasicDetails) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        User user = this.toolsHelper.getUserByName(userName);
        boolean hasSpaceViewPermission = this.spaceHasAnonymousPermission(page.getSpace(), "VIEWSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("VIEWSPACE", page.getSpace(), user);
        boolean hasSpaceEditPermission = this.spaceHasAnonymousPermission(page.getSpace(), "EDITSPACE") ? true : this.toolsHelper.getSpacePermissionManager().hasPermission("EDITSPACE", page.getSpace(), user);
        response.put("contentId", page.getId());
        if (showContentDetails) {
            response.put("spaceKey", page.getSpace().getKey());
            response.put("spaceName", page.getSpace().getName());
            response.put("contentName", page.getTitle());
            response.put("contentType", page.getContentTypeObject().getType());
            response.put("contentCreatorName", page.getCreator() != null ? page.getCreator().getName() : "not exist");
        }
        boolean inheriteViewPermission = hasSpaceViewPermission;
        boolean inheriteEditPermission = hasSpaceEditPermission;
        if (contentTree) {
            response.put("hasSpaceViewPermission", hasSpaceViewPermission);
            response.put("hasSpaceEditPermission", hasSpaceEditPermission);
            ArrayList<Page> tree = new ArrayList<Page>();
            if (page.getParent() != null) {
                this.buildTree(tree, page);
            } else {
                tree.add(page);
            }
            Collections.reverse(tree);
            int level = 1;
            ArrayList treeArray = new ArrayList();
            for (Page pageFromTree : tree) {
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                inheriteViewPermission = inheriteViewPermission ? this.userHasInheritedContentPermissionPersonalOrGroup(user, "View", (ContentEntityObject)pageFromTree) : false;
                boolean bl = inheriteEditPermission = hasSpaceEditPermission ? this.userHasInheritedContentPermissionPersonalOrGroup(user, "Edit", (ContentEntityObject)pageFromTree) : false;
                if (showContentDetails) {
                    treeMap.put("contentName", pageFromTree.getTitle());
                    treeMap.put("contentType", pageFromTree.getContentTypeObject().getType());
                    treeMap.put("contentCreatorName", pageFromTree.getCreator() != null ? pageFromTree.getCreator().getName() : "not exist");
                }
                treeMap.put("contentId", pageFromTree.getId());
                treeMap.put("level", level);
                treeMap.put("hasContentViewPermission", inheriteViewPermission);
                treeMap.put("hasContentEditPermission", inheriteEditPermission);
                ++level;
                treeArray.add(treeMap);
            }
            response.put("hasContentViewPermission", inheriteViewPermission);
            response.put("hasContentEditPermission", inheriteEditPermission);
            response.put("contentTree", treeArray);
        } else {
            response.put("hasContentViewPermission", this.userIsAddedToContentPermission((ContentEntityObject)page, "View", userName));
            response.put("hasContentEditPermission", this.userIsAddedToContentPermission((ContentEntityObject)page, "Edit", userName));
        }
        if (showSpaceAdministrators) {
            response.put("spaceAdministrators", this.getSpaceAdministrators(page.getSpace(), showBasicDetails));
        }
        return Response.ok(response).build();
    }

    private boolean spaceHasAnonymousPermission(Space space, String permissionType) {
        List permissions = space.getPermissions();
        for (SpacePermission spacePermission : permissions) {
            if (!spacePermission.isAnonymousPermission() || !spacePermission.getType().equals(permissionType)) continue;
            return true;
        }
        return false;
    }

    private boolean groupHasSpacePermission(String groupName, Space space, String permissionType) {
        Map groupsWithPermissions = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType(permissionType, space);
        if (log.isDebugEnabled()) {
            log.debug((Object)("groupsWithPermissions ::: " + groupsWithPermissions));
        }
        return groupsWithPermissions.get(groupName) != null;
    }

    private void buildTree(List<Page> tree, Page page) {
        tree.add(page);
        if (page.getParent() != null) {
            this.buildTree(tree, page.getParent());
        }
    }

    private boolean groupHasContentPermission(String groupName, String permissionType, ContentEntityObject contentObject) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupHasInheritedContentPermission(boolean inheritePermission, String groupName, String permissionType, ContentEntityObject contentObject) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" check permission :: inheritePermission=" + inheritePermission));
            log.debug((Object)(" check permission :: groupName=" + groupName));
            log.debug((Object)(" check permission :: permissionType=" + permissionType));
            log.debug((Object)(" check permission :: contentObject=" + contentObject.getId()));
        }
        if (!inheritePermission) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" return false :: inheritePermission=" + inheritePermission));
            }
            return false;
        }
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" return true :: permissions.isEmpty()");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" check permission  :: permissions=" + permissions.toString()));
        }
        boolean permissionFound = false;
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            permissionFound = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" check content :: content=" + contentObject.getId()));
                log.debug((Object)(" check content :: getType=" + contentPermissionSet.getType()));
            }
            if (contentPermissionSet.getType().equalsIgnoreCase("all")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" return true :: getType=" + contentPermissionSet.getType()));
                }
                return true;
            }
            if (contentPermissionSet.getType().equalsIgnoreCase("edit")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" return ???? :: getType=" + contentPermissionSet.getType()));
                    log.debug((Object)" return ???? :: ContentPermission.VIEW_PERMISSION=View");
                }
                if (permissionType.equals("View")) {
                    return true;
                }
                for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                    if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                    return true;
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(" return ???? :: getType=" + contentPermissionSet.getType()));
            }
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getType().equals(permissionType) || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        if (!permissionFound && !permissions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" check permission after for - inherite :: permissions=" + permissions.toString()));
            }
            return true;
        }
        return false;
    }

    private boolean userIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, String userName) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        return this.userIsAddedToContentPermission(contentObject, permissionType, confluenceUser);
    }

    private boolean userIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, ConfluenceUser user) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.getType().equals(permissionType) || !contentPermission.isUserPermission() || !contentPermission.getUserSubject().getKey().equals((Object)user.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupIsAddedToContentPermission(ContentEntityObject contentObject, String permissionType, String groupName) {
        List permissions = this.contentPermissionManager.getContentPermissionSets(contentObject, permissionType);
        if (permissions == null || permissions.isEmpty()) {
            return false;
        }
        for (ContentPermissionSet contentPermissionSet : permissions) {
            if (contentPermissionSet.getOwningContent().getId() != contentObject.getId()) continue;
            for (ContentPermission contentPermission : this.toolsHelper.getContentPermissionsCopy(contentPermissionSet)) {
                if (!contentPermission.getType().equals(permissionType) || !contentPermission.isGroupPermission() || !contentPermission.getGroupName().equals(groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean userHasInheritedContentPermissionPersonalOrGroup(User user, String permissionType, ContentEntityObject contentObject) {
        return this.contentPermissionManager.hasContentLevelPermission(user, permissionType, contentObject);
    }

    private boolean isValidPermissionType(String permissionType) {
        return permissionType.equalsIgnoreCase("view") || permissionType.equalsIgnoreCase("edit");
    }

    private boolean isValidGlobalPermissionType(String permissionType) {
        String tempPermissionType = permissionType.toUpperCase();
        return this.globalPermissions.contains(tempPermissionType);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/permissionTypes")
    public Response getSpacePermissions() {
        return Response.ok((Object)SpacePermission.GENERIC_SPACE_PERMISSIONS).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/allUsersWithAnyPermission")
    public Response getUsersWithPermForSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) throws EntityException {
        Space space;
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<String> usersList = new ArrayList<String>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if ((space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
        for (String userName : users.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getUser : " + userName));
            }
            if (startAt <= iterator && iterator < startAt + maxResults) {
                usersList.add(userName);
            }
            ++iterator;
        }
        response.put("users", usersList);
        response.put("total", Integer.valueOf(users.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/allGroupsWithAnyPermission")
    public Response getGroupsWithPermForSpace(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults) throws EntityException {
        Space space;
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<String> groupsList = new ArrayList<String>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if ((space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey)) == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        Collection groups = this.toolsHelper.getSpacePermissionManager().getGroupsWithPermissions(space);
        for (Group group : groups) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                groupsList.add(group.getName());
            }
            ++iterator;
        }
        response.put("groups", groupsList);
        response.put("total", Integer.valueOf(groups.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user/{userName}/getAllSpacesWithPermissions")
    public Response getAllSpacesPermissionForUser(@PathParam(value="userName") String userName, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spacesAsArray") boolean spacesAsArray) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap spaces = new HashMap();
        ArrayList spacesArray = new ArrayList();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        Collection spacePermissions = SpacePermission.GENERIC_SPACE_PERMISSIONS;
        int total = 0;
        for (Space space : this.toolsHelper.getAllSpacesFormSpaceDao()) {
            HashMap<String, Object> spaceMap = new HashMap<String, Object>();
            Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
            if (users.get(userName) == null) continue;
            ArrayList<String> permissionList = new ArrayList<String>();
            ++total;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                for (String spacePermission : spacePermissions) {
                    if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(spacePermission, space).get(userName) == null) continue;
                    permissionList.add(spacePermission);
                }
                spaceMap.put("permissions", permissionList);
                spaceMap.put("key", space.getKey());
                spaceMap.put("name", space.getName());
                if (spacesAsArray) {
                    spacesArray.add(spaceMap);
                } else {
                    spaces.put(space.getKey(), spaceMap);
                }
            }
            ++iterator;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        if (spacesAsArray) {
            response.put("spaces", spacesArray);
        } else {
            response.put("spaces", spaces);
        }
        response.put("total", Integer.valueOf(total));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/{groupName}/getAllSpacesWithPermissions")
    public Response getAllSpacesPermissionForGroup(@PathParam(value="groupName") String groupName, @QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="spacesAsArray") boolean spacesAsArray) throws EntityException, UnsupportedEncodingException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap spaces = new HashMap();
        ArrayList spacesArray = new ArrayList();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        List spacePermissions = this.toolsHelper.getSpacePermissionManager().getAllPermissionsForGroup(groupName);
        for (SpacePermission spacePermission : spacePermissions) {
            HashMap<String, Object> space = new HashMap<String, Object>();
            if (spacePermission.getSpace() == null) continue;
            String spaceKey = spacePermission.getSpace().getKey();
            String spaceName = spacePermission.getSpace().getName();
            List<String> permissionList = new ArrayList<String>();
            if (spaces.get(spaceKey) != null) {
                Map temp = (Map)spaces.get(spaceKey);
                permissionList = (List)temp.get("permissions");
            }
            permissionList.add(spacePermission.getType());
            space.put("permissions", permissionList);
            space.put("key", spaceKey);
            space.put("name", spaceName);
            spaces.put(spaceKey, space);
        }
        HashMap spaceToResponse = new HashMap();
        for (Map.Entry entry : spaces.entrySet()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                spaceToResponse.put((String)entry.getKey(), entry.getValue());
            }
            ++iterator;
        }
        if (spacesAsArray) {
            for (Map.Entry entry : spaceToResponse.entrySet()) {
                spacesArray.add(entry.getValue());
            }
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        if (spacesAsArray) {
            response.put("spaces", spacesArray);
        } else {
            response.put("spaces", spaceToResponse);
        }
        response.put("total", Integer.valueOf(spaces.size()));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/manageSpacePermissions")
    public Response manageUserSpacePermissions(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap response = new HashMap();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> addPermissions = this.toolsHelper.getJSONarray(jsonObject, "addPermissions");
        ArrayList<String> removePermissions = this.toolsHelper.getJSONarray(jsonObject, "removePermissions");
        ArrayList<String> addedPermissions = new ArrayList<String>();
        User user = this.toolsHelper.getUserByName(userName);
        for (String permission : addPermissions) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission) || this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(permission, space).get(userName) != null) continue;
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permission, (Space)space, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            addedPermissions.add(permission);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName) || !removePermissions.contains(permission.getType())) continue;
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            removedPermissions.add(permission.getType());
        }
        response.put("addedPermissions", addedPermissions);
        response.put("removedPermissions", removedPermissions);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/addSpacePermissions")
    public Response addUserPermissionToSpace(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        User user = this.toolsHelper.getUserByName(userName);
        for (String permission : permissionsList) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission)) continue;
            if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(permission, space).get(userName) != null) {
                skipped.add(permission);
                continue;
            }
            SpacePermission newSpacePermission = SpacePermission.createUserSpacePermission((String)permission, (Space)space, (ConfluenceUser)((ConfluenceUser)user));
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            added.add(permission);
        }
        response.put("added", added);
        response.put("skipped", skipped);
        response.put("total", Integer.valueOf(added.size()));
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/manageSpacePermissions")
    public Response manageGroupSpacePermissions(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap response = new HashMap();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> addPermissions = this.toolsHelper.getJSONarray(jsonObject, "addPermissions");
        ArrayList<String> removePermissions = this.toolsHelper.getJSONarray(jsonObject, "removePermissions");
        ArrayList<String> addedPermissions = new ArrayList<String>();
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (String permission : addPermissions) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission) || this.toolsHelper.getSpacePermissionManager().groupHasPermission(permission, space, groupName)) continue;
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permission, (Space)space, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            addedPermissions.add(permission);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !removePermissions.contains(permission.getType())) continue;
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
            removedPermissions.add(permission.getType());
        }
        response.put("addedPermissions", addedPermissions);
        response.put("removedPermissions", removedPermissions);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/addSpacePermissions")
    public Response addGroupsPermissionToSpace(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceAddPermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        for (String permission : permissionsList) {
            if (!SpacePermission.PERMISSION_TYPES.contains(permission)) continue;
            if (this.toolsHelper.getSpacePermissionManager().groupHasPermission(permission, space, groupName)) {
                skipped.add(permission);
                continue;
            }
            SpacePermission newSpacePermission = SpacePermission.createGroupSpacePermission((String)permission, (Space)space, (String)groupName);
            this.toolsHelper.getSpacePermissionManager().savePermission(newSpacePermission);
            added.add(permission);
        }
        response.put("added", added);
        response.put("skipped", skipped);
        response.put("total", Integer.valueOf(added.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/removeSpacePermissions")
    public Response removeUserWithPermForSpace(String jsonString, @PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemovePermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName) || !permissionsList.contains(permission.getType())) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/removeSpacePermissions")
    public Response removeGroupsWithPermForSpace(String jsonString, @PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemovePermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<String> permissionsList = this.toolsHelper.getJSONarray(jsonObject, "permissions");
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName) || !permissionsList.contains(permission.getType())) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/user/{userName}/removeAllSpacePermissions")
    public Response removeUserWithPermForSpace(@PathParam(value="userName") String userName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemoveAllPermissionForUser"))) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isUserPermission() || !permission.getUserSubject().getName().equalsIgnoreCase(userName)) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/group/{groupName}/removeAllSpacePermissions")
    public Response removeGroupsWithPermForSpace(@PathParam(value="groupName") String groupName, @PathParam(value="spaceKey") String spaceKey) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.isCurrentUserIsSpaceAdministrator(space) && !this.toolsHelper.isDisabledForSpaceAdministrator("spaceRemoveAllPermissionForGroup"))) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        ArrayList spacePermissionsToRemove = new ArrayList(space.getPermissions());
        ArrayList<String> removedPermissions = new ArrayList<String>();
        for (SpacePermission permission : spacePermissionsToRemove) {
            if (!permission.isGroupPermission() || !permission.getGroup().equalsIgnoreCase(groupName)) continue;
            removedPermissions.add(permission.getType());
            this.toolsHelper.getSpacePermissionManager().removePermission(permission);
        }
        response.put("removed", removedPermissions);
        response.put("total", Integer.valueOf(removedPermissions.size()));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}/getSpacePermissionActors/{spacePermissionType}")
    public Response getSpacesWithPermissions(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="spacePermissionType") String spacePermissionType) throws EntityException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (spacePermissionType == null || spacePermissionType.equals("") || !SpacePermission.GENERIC_SPACE_PERMISSIONS.contains(spacePermissionType) && !spacePermissionType.equalsIgnoreCase("all")) {
            response.put("message", "permission type '" + spacePermissionType + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator() && !this.isCurrentUserIsSpaceAdministrator(space)) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap permissionMatrix = new HashMap();
        for (SpacePermission spacePermission : space.getPermissions()) {
            Map permissionTypeMatrix;
            if (!spacePermissionType.equalsIgnoreCase("all") && !spacePermission.getType().equalsIgnoreCase(spacePermissionType)) continue;
            if (permissionMatrix.get(spacePermission.getType()) == null) {
                permissionTypeMatrix = new HashMap<String, Boolean>();
                permissionTypeMatrix.put("anonymousAccess", false);
            } else {
                permissionTypeMatrix = (Map)permissionMatrix.get(spacePermission.getType());
            }
            if (spacePermission.isAnonymousPermission()) {
                permissionTypeMatrix.put("anonymousAccess", true);
            } else if (spacePermission.isGroupPermission()) {
                List<String> permissionTypeGroup = permissionTypeMatrix.get("groups") == null ? new ArrayList() : (List)permissionTypeMatrix.get("groups");
                permissionTypeGroup.add(spacePermission.getGroup());
                permissionTypeMatrix.put("groups", permissionTypeGroup);
            } else {
                List<String> permissionTypeUser;
                List list = permissionTypeUser = permissionTypeMatrix.get("users") == null ? new ArrayList() : (List)permissionTypeMatrix.get("users");
                if (spacePermission.getUserSubject() != null) {
                    permissionTypeUser.add(spacePermission.getUserSubject().getName());
                }
                permissionTypeMatrix.put("users", permissionTypeUser);
            }
            permissionMatrix.put(spacePermission.getType(), permissionTypeMatrix);
        }
        response.put("key", space.getKey());
        response.put("name", space.getName());
        response.put("permissions", permissionMatrix);
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/getSpacesWithAnonymousPermissions")
    public Response getSpacesWithAnonymousPermissions(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="creationDateFrom") String creationDateFrom, @QueryParam(value="creationDateTo") String creationDateTo, @QueryParam(value="dateFormat") String dateFormatApi) throws ParseException {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        HashMap<String, Map<String, List<String>>> spaces = new HashMap<String, Map<String, List<String>>>();
        Date from = new Date();
        Date to = new Date();
        boolean checkDateFrom = false;
        boolean checkDateTo = false;
        String dateFormat = "";
        String fullDateFormat = "";
        if (dateFormatApi == null || dateFormatApi.equals("")) {
            dateFormat = "yyyy-MM-dd";
            fullDateFormat = dateFormat + " HH:mm:ss";
        } else {
            dateFormat = dateFormatApi;
            fullDateFormat = dateFormatApi + " HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        SimpleDateFormat sdfFull = new SimpleDateFormat(fullDateFormat);
        if (creationDateFrom != null && !creationDateFrom.equals("")) {
            checkDateFrom = true;
            from = sdf.parse(creationDateFrom);
        }
        if (creationDateTo != null && !creationDateTo.equals("")) {
            checkDateTo = true;
            to = sdf.parse(creationDateTo);
        }
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 100;
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        List<Space> spaceList = this.toolsHelper.getAllSpacesFormSpaceDao();
        for (Space space : spaceList) {
            if (!(!checkDateFrom && !checkDateTo || !checkDateFrom && checkDateTo && space.getCreationDate().compareTo(to) <= 0 || checkDateFrom && !checkDateTo && space.getCreationDate().compareTo(from) >= 0) && (!checkDateFrom || space.getCreationDate().compareTo(from) < 0 || !checkDateTo || space.getCreationDate().compareTo(to) > 0)) continue;
            for (SpacePermission spacePermission : space.getPermissions()) {
                List<String> permissionsList;
                if (!spacePermission.isAnonymousPermission()) continue;
                String spaceKey = space.getKey();
                String permissionType = spacePermission.getType();
                Map<String, List<String>> spaceDetails = spaces.get(spaceKey) == null ? new HashMap() : (Map)spaces.get(spaceKey);
                List list = permissionsList = spaceDetails.get("permissions") == null ? new ArrayList() : (List)spaceDetails.get("permissions");
                if (!permissionsList.contains(permissionType)) {
                    permissionsList.add(permissionType);
                    spaceDetails.put("permissions", permissionsList);
                }
                spaceDetails.put("creationDate", (List<String>)((Object)space.getCreationDate()));
                spaceDetails.put("creationDateString", (List<String>)((Object)sdfFull.format(space.getCreationDate())));
                spaceDetails.put("lastModificationDate", (List<String>)((Object)space.getLastModificationDate()));
                spaceDetails.put("lastModificationDateString", (List<String>)((Object)sdfFull.format(space.getLastModificationDate())));
                spaceDetails.put("creatorName", (List<String>)((Object)(space.getCreator() != null ? space.getCreator().getName() : "not exist")));
                spaceDetails.put("key", (List<String>)((Object)space.getKey()));
                spaceDetails.put("name", (List<String>)((Object)space.getName()));
                spaces.put(spaceKey, spaceDetails);
            }
        }
        HashMap spaceToResponse = new HashMap();
        for (Map.Entry entry : spaces.entrySet()) {
            if (startAt <= iterator && iterator < startAt + maxResults) {
                spaceToResponse.put((String)entry.getKey(), entry.getValue());
            }
            ++iterator;
        }
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("spaces", spaceToResponse);
        response.put("total", Integer.valueOf(spaces.size()));
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user/{userName}/getPermissionsForSpace/space/{spaceKey}")
    public Response getPermissionsForSpaceUser(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="userName") String userName) throws EntityException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("VIEWSPACE", space);
        if (users.get(userName) != null) {
            for (String spacePermission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                if (this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType(spacePermission, space).get(userName) == null) continue;
                permissionList.add(spacePermission);
            }
        }
        response.put("permissions", permissionList);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/{groupName}/getPermissionsForSpace/space/{spaceKey}")
    public Response getPermissionsForSpaceGroup(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="groupName") String groupName) throws EntityException {
        groupName = this.toolsHelper.decodeUrlParam(groupName);
        HashMap<String, Object> response = new HashMap<String, Object>();
        Space space = this.toolsHelper.getSpaceFromSpaceDao(spaceKey);
        if (space == null) {
            return this.toolsHelper.spaceNotExist(spaceKey);
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (this.groupManager.getGroup(groupName) == null) {
            return this.toolsHelper.groupNotExit(groupName);
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        if (this.toolsHelper.getSpacePermissionManager().getGroupsWithPermissions(space).contains(this.groupManager.getGroup(groupName))) {
            for (String spacePermission : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                Map groupsForPermissionType = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType(spacePermission, space);
                if (groupsForPermissionType.get(groupName) == null) continue;
                permissionList.add(spacePermission);
            }
        }
        response.put("permissions", permissionList);
        response.put("key", space.getKey());
        response.put("name", space.getName());
        return Response.ok(response).build();
    }

    private boolean isCurrentUserIsSpaceAdministrator(Space space) throws EntityException {
        UserProfile userProfile = this.toolsHelper.getCurrentUserProfile();
        User user = this.toolsHelper.getUserByName(userProfile.getUsername());
        Map groups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        Map users = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        if (log.isDebugEnabled()) {
            log.debug((Object)("groups: " + groups));
            log.debug((Object)("users: " + users));
        }
        if (users.get(userProfile.getUsername()) != null) {
            return true;
        }
        for (Map.Entry entry : groups.entrySet()) {
            Group group = this.groupManager.getGroup((String)entry.getKey());
            if (!this.groupManager.hasMembership(group, user)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getSpaceAdministrators(Space space, boolean showBasicDetails) {
        ArrayList usersList = new ArrayList();
        HashSet<String> spaceAdministrators = new HashSet<String>();
        Map adminUsers = this.toolsHelper.getSpacePermissionManager().getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        for (Map.Entry entry : adminUsers.entrySet()) {
            spaceAdministrators.add((String)entry.getKey());
        }
        Map adminGroups = this.toolsHelper.getSpacePermissionManager().getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        for (Map.Entry entry : adminGroups.entrySet()) {
            Group group = this.userAccessor.getGroup((String)entry.getKey());
            if (group == null) continue;
            spaceAdministrators.addAll(this.userAccessor.getMemberNamesAsList(group));
        }
        return spaceAdministrators;
    }
}

