/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.maintenance;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;

@Path(value="/maintenance")
public class ReadOnlyModeRestApi {
    private static final Logger log = Logger.getLogger(ReadOnlyModeRestApi.class);
    private final ToolsHelper toolsHelper;

    public ReadOnlyModeRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status")
    public Response getMaintenanceState(@Context HttpServletRequest request) {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (this.toolsHelper.isLicensedForDataCenter()) {
            response.put("status", "error");
            response.put("message", "The instance is not a Data Center");
            return Response.serverError().entity(response).build();
        }
        Settings settings = this.toolsHelper.getGlobalSettings();
        response.put("readOnlyMode", this.toolsHelper.isReadOnly());
        response.put("bannerMessageOn", settings.isMaintenanceBannerMessageOn());
        response.put("bannerMessageText", settings.getMaintenanceBannerMessage() == null ? "" : settings.getMaintenanceBannerMessage());
        return Response.ok(response).build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Path(value="/set")
    public Response setMaintenanceState(String requestJson, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isSystemAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (this.toolsHelper.isLicensedForDataCenter()) {
            response.put("status", "error");
            response.put("message", "The instance is not a Data Center");
            return Response.serverError().entity(response).build();
        }
        JSONObject jsonObject = new JSONObject(requestJson);
        if (!jsonObject.has("readOnlyMode") && !jsonObject.has("bannerMessageOn")) {
            response.put("message", "field 'readOnlyMode' or 'bannerMessageOn' is required");
            return Response.serverError().entity(response).build();
        }
        boolean isReadOnlyModeEnabled = false;
        if (jsonObject.has("readOnlyMode")) {
            isReadOnlyModeEnabled = jsonObject.getBoolean("readOnlyMode");
        }
        boolean isBannerMessageOn = false;
        if (jsonObject.has("bannerMessageOn")) {
            isBannerMessageOn = jsonObject.getBoolean("bannerMessageOn");
        }
        AccessModeService accessModeService = (AccessModeService)ComponentLocator.getComponent(AccessModeService.class);
        Settings settings = this.toolsHelper.getGlobalSettings();
        if (jsonObject.has("bannerMessageText")) {
            String bannerMessageText = jsonObject.getString("bannerMessageText");
            settings.setMaintenanceBannerMessage(StringEscapeUtils.escapeHtml4((String)bannerMessageText));
        }
        if (jsonObject.has("readOnlyMode") && jsonObject.getBoolean("readOnlyMode")) {
            settings.setMaintenanceBannerMessageOn(true);
            accessModeService.updateAccessMode(AccessMode.READ_ONLY);
        }
        if (jsonObject.has("readOnlyMode") && !jsonObject.getBoolean("readOnlyMode")) {
            if (jsonObject.has("bannerMessageOn") && jsonObject.getBoolean("bannerMessageOn")) {
                settings.setMaintenanceBannerMessageOn(true);
                accessModeService.updateAccessMode(AccessMode.READ_WRITE);
            } else if (jsonObject.has("bannerMessageOn") && !jsonObject.getBoolean("bannerMessageOn")) {
                settings.setMaintenanceBannerMessageOn(false);
                accessModeService.updateAccessMode(AccessMode.READ_WRITE);
            } else {
                accessModeService.updateAccessMode(AccessMode.READ_WRITE);
            }
        }
        if (!jsonObject.has("readOnlyMode")) {
            if (jsonObject.has("bannerMessageOn") && jsonObject.getBoolean("bannerMessageOn")) {
                settings.setMaintenanceBannerMessageOn(true);
            } else if (jsonObject.has("bannerMessageOn") && !jsonObject.getBoolean("bannerMessageOn") && !this.toolsHelper.isReadOnly()) {
                settings.setMaintenanceBannerMessageOn(false);
            }
        }
        response.put("status", "done");
        String message = "Read-only mode set to '" + (this.toolsHelper.isReadOnly() ? "ON" : "OFF") + "', the banner set to '" + (settings.isMaintenanceBannerMessageOn() ? "ON" : "OFF") + "' and its message is set to '" + StringEscapeUtils.escapeHtml4((String)settings.getMaintenanceBannerMessage()) + "'";
        response.put("message", message);
        return Response.ok(response).build();
    }
}

