/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.helper.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

@Path(value="/idHelper")
public class IdHelperApi {
    private static final Logger log = Logger.getLogger(IdHelperApi.class);
    private final EntityManagerProvider entityManagerProvider;
    private final ToolsHelper toolsHelper;
    private final UserAccessor userAccessor;
    private final BandanaManager bandanaManager;

    public IdHelperApi(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.toolsHelper = toolsHelper;
        this.entityManagerProvider = (EntityManagerProvider)ComponentLocator.getComponent(EntityManagerProvider.class);
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    private String getNotNullValue(Object value) {
        if (value == null) {
            return "";
        }
        return this.getNotNullValue(value + "");
    }

    private String getNotNullValue(String value) {
        if (value == null || value.equalsIgnoreCase("null")) {
            return "";
        }
        return value;
    }

    private boolean passContainsCondition(Long elementId, String elementName, String elementDescription, String searchString) {
        return this.passContainsCondition(Long.toString(elementId), elementName, elementDescription, searchString);
    }

    private boolean passContainsCondition(String elementId, String elementName, String elementDescription, String searchString) {
        elementId = this.unescapeHtml(elementId);
        elementName = this.unescapeHtml(elementName);
        elementDescription = this.unescapeHtml(elementDescription);
        return this.containsIgnoreCase(elementId, searchString = this.unescapeHtml(searchString)) || this.containsIgnoreCase(elementName, searchString) || this.containsIgnoreCase(elementDescription, searchString);
    }

    private String unescapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return StringEscapeUtils.unescapeHtml((String)text);
    }

    private boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    private Map transformResponse(Map firstElementValue) {
        return this.transformResponse("results", firstElementValue);
    }

    private Map transformResponse(final String firstElementName, final Map firstElementValue) {
        return new HashMap<String, Object>(){
            {
                this.put(firstElementName, firstElementValue);
            }
        };
    }

    private Response findAndReturn(String configType, String search, List values) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("findAndReturn - START " + configType));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashSet<String> addedObjects = new HashSet<String>();
        if (search.equals("")) {
            for (Object object : values) {
                String groupName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - object " + object));
                }
                List<?> value = IdHelperApi.convertObjectToList(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - value " + value));
                }
                if (configType.equalsIgnoreCase("spaces")) {
                    response.put(value.get(1).toString().trim(), value.get(0));
                    continue;
                }
                if (!configType.equalsIgnoreCase("groups") || addedObjects.contains(groupName = this.getNotNullValue(value.get(1)))) continue;
                addedObjects.add(groupName);
                response.put(groupName, groupName);
            }
        } else {
            for (Object object : values) {
                String groupName;
                List<?> value = IdHelperApi.convertObjectToList(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findAndReturn - value " + value));
                }
                if (configType.equalsIgnoreCase("spaces")) {
                    String spaceDescription = this.getNotNullValue(value.get(13)).toString().replaceAll("^clob[0-9]+:", "");
                    if (!this.passContainsCondition(this.getNotNullValue(value.get(0)) + " " + this.getNotNullValue(value.get(2)), this.getNotNullValue(value.get(1)), spaceDescription, search)) continue;
                    response.put(value.get(1).toString().trim(), this.getNotNullValue(value.get(0)) + " | " + this.getNotNullValue(value.get(2)));
                    continue;
                }
                if (!configType.equalsIgnoreCase("groups") || !this.passContainsCondition(groupName = this.getNotNullValue(value.get(1)), "", "", search) || addedObjects.contains(groupName)) continue;
                addedObjects.add(groupName);
                response.put(groupName, groupName);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findAndReturn - DONE " + configType));
        }
        return Response.ok((Object)this.transformResponse(response)).build();
    }

    public static List<?> convertObjectToList(Object obj) {
        List<Object> list = new ArrayList();
        if (obj.getClass().isArray()) {
            list = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            list = new ArrayList((Collection)obj);
        }
        return list;
    }

    private boolean useNativeQuery() {
        Object useNativeQueryObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "com.itlab.confluence.plugins.restextender.configuration.global.search");
        boolean useNativeQuery = false;
        if (useNativeQueryObject != null) {
            try {
                useNativeQuery = (Boolean)useNativeQueryObject;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("global search :: use native query = " + useNativeQuery));
        }
        return useNativeQuery;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/space/all")
    public Response getSpaces(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.useNativeQuery()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"spaces :: use native query");
            }
            List matchingContentResults = this.entityManagerProvider.getEntityManager().createNativeQuery("select * from SPACES s left join BODYCONTENT bc on s.SPACEDESCID = bc.CONTENTID").getResultList();
            return this.findAndReturn("spaces", search, matchingContentResults);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"spaces :: use internal JAVA API");
        }
        List<Space> spaces = this.toolsHelper.getAllSpacesFormSpaceDao();
        HashMap<String, String> response = new HashMap<String, String>();
        if (search.equals("")) {
            for (Space space : spaces) {
                response.put(space.getName().trim(), this.getNotNullValue(space.getId()) + " | " + this.getNotNullValue(space.getKey()));
            }
        } else {
            for (Space space : spaces) {
                String description;
                String string = description = space.getDescription() != null && space.getDescription().getLatestVersion() != null ? this.toolsHelper.getSpaceDescription(space.getDescription()) : "";
                if (!this.passContainsCondition(this.getNotNullValue(space.getId()) + " " + this.getNotNullValue(space.getKey()), this.getNotNullValue(space.getName()), this.getNotNullValue(description), search)) continue;
                response.put(space.getName().trim(), this.getNotNullValue(space.getId()) + " | " + this.getNotNullValue(space.getKey()));
            }
        }
        return Response.ok((Object)this.transformResponse(response)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/group/all")
    public Response getGroups(@DefaultValue(value="") @QueryParam(value="search") String search, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.useNativeQuery()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"groups :: use native query");
            }
            List matchingContentResults = this.entityManagerProvider.getEntityManager().createNativeQuery("select * from CWD_GROUP").getResultList();
            return this.findAndReturn("groups", search, matchingContentResults);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"groups :: use internal JAVA API");
        }
        Pager groups = this.userAccessor.getGroups();
        HashMap<String, String> response = new HashMap<String, String>();
        if (search.equals("")) {
            for (Group group : groups) {
                response.put(group.getName().trim(), this.getNotNullValue(group.getName()));
            }
        } else {
            for (Group group : groups) {
                if (!this.passContainsCondition(this.getNotNullValue(group.getName()), "", "", search)) continue;
                response.put(group.getName().trim(), this.getNotNullValue(group.getName()));
            }
        }
        return Response.ok((Object)this.transformResponse(response)).build();
    }
}

