/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.condition;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.List;
import org.apache.log4j.Logger;

public class NotifyWatchersCondition
extends SimpleUrlReadingCondition {
    private static final Logger log = Logger.getLogger(NotifyWatchersCondition.class);
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    private static final String BUTTONS_GROUP = "com.itlab.confluence.plugins.restextender.notifyWatchers.groups";

    public NotifyWatchersCondition(@ConfluenceImport UserAccessor userAccessor, ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        this.userAccessor = userAccessor;
    }

    protected boolean isConditionTrue() {
        Object groups = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BUTTONS_GROUP);
        List userGroups = this.userAccessor.getGroupNamesForUserName(this.toolsHelper.getAuthenticatedUser().getName());
        boolean isInGroup = false;
        if (groups != null) {
            if (groups.toString().contains("@@@")) {
                String[] groupsTable = groups.toString().split("@@@");
                for (int i = 0; i < groupsTable.length; ++i) {
                    if (!userGroups.contains(groupsTable[i])) continue;
                    isInGroup = true;
                    break;
                }
            } else if (!groups.toString().equals("") && userGroups.contains(groups.toString())) {
                isInGroup = true;
            }
        }
        return this.toolsHelper.isLicenseIsValid() && isInGroup;
    }

    protected String queryKey() {
        return "re.condition.notifyWatchers";
    }
}

