/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.userDirectories;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

@Path(value="/userDirectories")
public class UserDirectoriesRestApi {
    private static final Logger log = Logger.getLogger(UserDirectoriesRestApi.class);
    private ToolsHelper toolsHelper;
    private final DirectoryManager directoryManager;

    public UserDirectoriesRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.directoryManager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/all")
    public Response getAllUserDirectories(@Context HttpServletRequest request) throws DirectoryInstantiationException, DirectoryNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUserDirectories");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)ComponentLocator.getComponent(CrowdDirectoryService.class);
        response.put("results", "" + crowdDirectoryService.findAllDirectories().size());
        ArrayList directoryArray = new ArrayList();
        int position = 1;
        for (Directory directory : crowdDirectoryService.findAllDirectories()) {
            HashMap<String, Object> directoryMap = new HashMap<String, Object>();
            directoryMap.put("name", directory.getName());
            directoryMap.put("description", directory.getDescription());
            directoryMap.put("position", position);
            ++position;
            directoryMap.put("id", directory.getId());
            directoryMap.put("active", directory.isActive());
            DirectorySynchronisationInformation directorySynchronisationInformation = this.directoryManager.getDirectorySynchronisationInformation(directory.getId().longValue());
            if (directorySynchronisationInformation != null) {
                DirectorySynchronisationRoundInformation directorySynchronisationRoundInformation = directorySynchronisationInformation.getLastRound();
                directoryMap.put("lastSyncStartDate", directorySynchronisationRoundInformation.getStartTime());
                directoryMap.put("lastSyncDuration", directorySynchronisationRoundInformation.getDurationMs());
                directoryMap.put("lastSyncStatusKey", directorySynchronisationRoundInformation.getStatusKey());
            }
            directoryArray.add(directoryMap);
        }
        response.put("userDirectories", directoryArray);
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{directoryId}/synchronize")
    public Response synchronizeUserDirectories(@PathParam(value="directoryId") Long directoryId, @QueryParam(value="fullSynchronisation") boolean fullSynchronisation, @QueryParam(value="runInBackground") boolean runInBackground, @Context HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("synchronizeUserDirectories: directoryId:" + directoryId));
            log.debug((Object)("synchronizeUserDirectories: fullSynchronisation:" + fullSynchronisation));
            log.debug((Object)("synchronizeUserDirectories: runInBackground:" + runInBackground));
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            SynchronisationMode synchronisationMode;
            Directory directory = this.directoryManager.findDirectoryById(directoryId.longValue());
            if (!directory.isActive()) {
                response.put("message", "directory '" + directoryId + "' is not active");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            if (!directory.isActive()) {
                response.put("message", "directory '" + directoryId + "' is not active");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            if (!this.directoryManager.isSynchronisable(directoryId.longValue())) {
                response.put("message", "directory '" + directoryId + "' is not synchronisable");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            if (this.directoryManager.isSynchronising(directoryId.longValue())) {
                response.put("message", "directory '" + directoryId + "' is currently being synced, cannot start a new synchronization");
                response.put("status", "error");
                return Response.serverError().entity(response).build();
            }
            SynchronisationMode synchronisationMode2 = synchronisationMode = fullSynchronisation ? SynchronisationMode.FULL : SynchronisationMode.INCREMENTAL;
            if (runInBackground) {
                this.directoryManager.synchroniseCache(directoryId.longValue(), synchronisationMode, runInBackground);
            } else {
                this.directoryManager.synchroniseCache(directoryId.longValue(), synchronisationMode);
            }
        }
        catch (DirectoryNotFoundException e) {
            response.put("message", "directory '" + directoryId + "' not found");
            response.put("status", "error");
            return Response.serverError().entity(response).build();
        }
        catch (Exception ex) {
            response.put("message", "internal '" + directoryId + "' error");
            response.put("status", "error");
            response.put("details", ExceptionUtils.getStackTrace((Throwable)ex));
            return Response.serverError().entity(response).build();
        }
        if (runInBackground) {
            response.put("message", "synchronization request for directory '" + directoryId + "' has been sent");
            response.put("status", "success");
        } else {
            response.put("message", "directory '" + directoryId + "' has been synchronized");
            response.put("status", "success");
        }
        return Response.ok(response).build();
    }
}

