/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.license;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.component.ComponentLocator;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="/license")
public class ApplicationLicenseTypeRestApi {
    private static final Logger log = Logger.getLogger(ApplicationLicenseTypeRestApi.class);
    private final ToolsHelper toolsHelper;
    private final BandanaManager bandanaManager;
    protected static final String EXT_L_KEY = "com.itlab.confluence.plugins.extender.server.license";

    public ApplicationLicenseTypeRestApi(ToolsHelper toolsHelper) {
        this.toolsHelper = toolsHelper;
        this.bandanaManager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/type")
    public Response getLicenseType(@Context HttpServletRequest request) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("isDataCenter", this.toolsHelper.isLicensedForDataCenter());
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/key")
    public Response updateKey(String json, @Context HttpServletRequest request) {
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(json);
        String extenderKey = "";
        if (jsonObject.has("extenderKey")) {
            extenderKey = jsonObject.getString("extenderKey");
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), EXT_L_KEY, (Object)extenderKey);
        return Response.ok().build();
    }
}

