/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.user;

import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.actions.UserDetailsMap;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

@Path(value="/user")
public class UserRestApi {
    private static final Logger log = Logger.getLogger(UserRestApi.class);
    private final UserAccessor userAccessor;
    private final UserDetailsManager userDetailsManager;
    private final CrowdService crowdService;
    private final PersonalInformationManager personalInformationManager;
    private ToolsHelper toolsHelper;

    public UserRestApi(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport CrowdService crowdService, @ConfluenceImport UserDetailsManager userDetailsManager, ToolsHelper toolsHelper) {
        this.userAccessor = userAccessor;
        this.userDetailsManager = userDetailsManager;
        this.toolsHelper = toolsHelper;
        this.crowdService = crowdService;
        this.personalInformationManager = (PersonalInformationManager)ComponentLocator.getComponent(PersonalInformationManager.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/test/{string}")
    public Response test(@PathParam(value="string") String string, @Context HttpServletRequest request) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("test", string);
        response.put("testDecode", this.toolsHelper.decodeUrlParam(string));
        return Response.ok(response).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/captcha/{userName}")
    public Response resetCaptcha(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RESTAPI - get properties");
            log.debug((Object)("RESTAPI - userName: " + userName));
        }
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!(this.toolsHelper.isConfluenceAdministrator() || this.toolsHelper.getAuthenticatedUser() != null && this.toolsHelper.getAuthenticatedUser().getName().equals(userName))) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        this.toolsHelper.resetCaptcha(confluenceUser);
        response.put("message", "done");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/property/{userName}/{propertyKey}")
    public Response propertiesGet(@PathParam(value="userName") String userName, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) throws JSONException {
        userName = this.toolsHelper.decodeUrlParam(userName);
        log.debug((Object)"RESTAPI - get properties");
        log.debug((Object)("RESTAPI - userName: " + userName));
        log.debug((Object)("RESTAPI - propertyKey: " + propertyKey));
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        String propertyValue = this.userDetailsManager.getStringProperty(confluenceUser, propertyKey);
        response.put("value", propertyValue == null ? "" : propertyValue);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/property/{userName}/{propertyKey}")
    public Response propertiesSet(String userJSON, @PathParam(value="userName") String userName, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - get properties");
        log.debug((Object)("RESTAPI - userName: " + userName));
        log.debug((Object)("RESTAPI - propertyKey: " + propertyKey));
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        JSONObject jsonObject = new JSONObject(userJSON);
        String value = jsonObject.getString("value");
        this.userDetailsManager.setStringProperty(confluenceUser, propertyKey, value);
        response.put("message", "success");
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getUserDetails/{userName}")
    public Response getUser(@PathParam(value="userName") String userName, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        User confluenceUser;
        log.debug((Object)"RESTAPI - getUser");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESTAPI - userName:" + userName));
        }
        if ((confluenceUser = this.toolsHelper.getUserByName(userName)) == null) {
            return this.toolsHelper.userNotFound(userName);
        }
        Map<String, Object> response = new HashMap<String, Object>();
        UserProfile userProfile = this.toolsHelper.getUserProfileByName(userName);
        response = this.toolsHelper.addUserGroupDetails(response, confluenceUser, dateFormatApi);
        response.put("name", confluenceUser.getName());
        response.put("key", userProfile.getUserKey().getStringValue());
        response.put("fullName", confluenceUser.getFullName());
        response.put("email", confluenceUser.getEmail());
        if (this.userAccessor.getUserNamesWithConfluenceAccess().contains(confluenceUser.getName())) {
            response.put("hasAccessToUseConfluence", true);
        } else {
            response.put("hasAccessToUseConfluence", false);
        }
        return Response.ok(response).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getInactiveUsers")
    public Response getInactiveUsers(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        log.debug((Object)"RESTAPI - getInactiveUsers");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> usersList = new ArrayList<HashMap<String, Object>>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        log.debug((Object)("RESTAPI - getInactiveUsers - startAt:" + startAt));
        log.debug((Object)("RESTAPI - getInactiveUsers - maxResults:" + maxResults));
        log.debug((Object)("RESTAPI - getInactiveUsers - show: " + maxResults));
        PropertyRestriction restriction = Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false);
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1);
        Iterable inactiveUsers = this.crowdService.search((Query)query);
        for (String userName : inactiveUsers) {
            if (iterator > startAt + maxResults) break;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                Map<String, Object> map = new HashMap<String, Object>();
                if ((showBasicDetails || showExtendedDetails) && (confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName(userName)) != null) {
                    if (showExtendedDetails) {
                        map = this.toolsHelper.addUserGroupDetails(map, userName, dateFormatApi);
                    }
                    map.put("key", confluenceUser.getKey().getStringValue());
                    map.put("fullName", confluenceUser.getFullName());
                    map.put("email", confluenceUser.getEmail());
                    log.debug((Object)"RESTAPI - getUsers - using - getUserByName");
                }
                map.put("name", userName);
                usersList.add((HashMap<String, Object>)map);
            }
            ++iterator;
        }
        response.put("total", Integer.valueOf(UserRestApi.size(inactiveUsers)));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("users", usersList);
        return Response.ok(response).build();
    }

    public static int size(Iterable data) {
        if (data instanceof Collection) {
            return ((Collection)data).size();
        }
        int counter = 0;
        for (Object i : data) {
            ++counter;
        }
        return counter;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getUsers")
    public Response getUsers(@QueryParam(value="startAt") int startAt, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="showBasicDetails") boolean showBasicDetails, @QueryParam(value="showExtendedDetails") boolean showExtendedDetails, @QueryParam(value="dateFormat") String dateFormatApi, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - getUsers");
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> usersList = new ArrayList<HashMap<String, Object>>();
        int iterator = 0;
        if (maxResults == 0) {
            maxResults = 50;
        }
        log.debug((Object)("RESTAPI - getUsers - startAt:" + startAt));
        log.debug((Object)("RESTAPI - getUsers - maxResults:" + maxResults));
        log.debug((Object)("RESTAPI - getUsers - show: " + maxResults));
        List users = this.userAccessor.getUserNamesWithConfluenceAccess();
        log.debug((Object)"RESTAPI - getUsers - getAllAsString");
        for (String userName : users) {
            if (iterator > startAt + maxResults) break;
            if (startAt <= iterator && iterator < startAt + maxResults) {
                ConfluenceUser confluenceUser;
                Map<String, Object> map = new HashMap<String, Object>();
                if ((showBasicDetails || showExtendedDetails) && (confluenceUser = (ConfluenceUser)this.toolsHelper.getUserByName(userName)) != null) {
                    if (showExtendedDetails) {
                        map = this.toolsHelper.addUserGroupDetails(map, userName, dateFormatApi);
                    }
                    map.put("key", confluenceUser.getKey().getStringValue());
                    map.put("fullName", confluenceUser.getFullName());
                    map.put("email", confluenceUser.getEmail());
                    log.debug((Object)"RESTAPI - getUsers - using - getUserByName");
                }
                map.put("name", userName);
                usersList.add((HashMap<String, Object>)map);
            }
            ++iterator;
        }
        log.debug((Object)"RESTAPI - getUsers - entIterator");
        response.put("total", Integer.valueOf(users.size()));
        response.put("startAt", Integer.valueOf(startAt));
        response.put("maxResults", Integer.valueOf(maxResults));
        response.put("users", usersList);
        return Response.ok(response).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/add")
    public Response addUser(String userJSON, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - addUser");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        boolean sendMail = false;
        try {
            sendMail = jsonObject.getBoolean("sendMail");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - sendMail - sendMail:empty");
        }
        String bcc = "";
        try {
            bcc = jsonObject.getString("bcc");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - bcc - debug:empty");
        }
        String header = "";
        try {
            header = jsonObject.getString("header");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - header - debug:empty");
        }
        String footer = "";
        try {
            footer = jsonObject.getString("footer");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - header - debug:empty");
        }
        String name = "";
        try {
            name = jsonObject.getString("name");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - name:empty");
        }
        String fullName = "";
        try {
            fullName = jsonObject.getString("fullName");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - fullName:empty");
        }
        String email = "";
        try {
            email = jsonObject.getString("email");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - email:empty");
        }
        String password = "";
        try {
            password = jsonObject.getString("password");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - password:empty");
        }
        if (password == null || password.equals("")) {
            password = UUID.randomUUID().toString();
        }
        ArrayList<Object> groups = new ArrayList();
        try {
            groups = this.toolsHelper.getJSONarray(jsonObject, "groups");
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - groups:empty");
        }
        if (name.equals("") || email.equals("") || fullName.equals("")) {
            response.put("message", "User parameters: name, fullName, email is required");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isUserExistByName(name)) {
            response.put("message", "User with name '" + name + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"\\,+<>'\"")) {
            response.put("message", "Usernames cannot contain the characters +, <, >, comma, backslash, apostrophe, or quote");
            return Response.serverError().entity(response).build();
        }
        if (!name.matches("[^\\s]+")) {
            response.put("message", "Usernames cannot contain any whitespace characters");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(name) || "anonymous".equalsIgnoreCase(name)) {
            response.put("message", "This username is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        if (!name.equals(name.toLowerCase())) {
            response.put("message", "The username must be in lower case");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
            response.put("message", "Full Names cannot contain < or >");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(fullName) || "anonymous".equalsIgnoreCase(fullName)) {
            response.put("message", "This name is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        try {
            DefaultUser defaultUser = new DefaultUser(name, fullName, email);
            ConfluenceUser newUser = this.userAccessor.createUser((User)defaultUser, Credential.unencrypted((String)password));
            Group confluenceDefaultGroup = this.userAccessor.getGroup(this.toolsHelper.getDefaultUsersGroup());
            if (confluenceDefaultGroup != null) {
                this.userAccessor.addMembership(confluenceDefaultGroup, (User)newUser);
            }
            for (String string : groups) {
                Group group = this.userAccessor.getGroup(string);
                if (group == null) continue;
                if (this.toolsHelper.isSystemAdministrator()) {
                    this.userAccessor.addMembership(group, (User)newUser);
                    continue;
                }
                if (string.equalsIgnoreCase("confluence-administrators") || this.toolsHelper.objectHasGlobalPermission("group", string, "SYSTEMADMINISTRATOR")) {
                    return this.toolsHelper.permissionViolation();
                }
                this.userAccessor.addMembership(group, (User)newUser);
            }
            response.put("message", "User " + newUser.getName() + " (" + newUser.getFullName() + ") was created");
            if (sendMail) {
                ConfluenceMailServerManager confluenceMailServerManager = (ConfluenceMailServerManager)ComponentLocator.getComponent(ConfluenceMailServerManager.class);
                SMTPMailServer sMTPMailServer = confluenceMailServerManager.getDefaultSMTPMailServer();
                if (sMTPMailServer != null) {
                    Email mail = new Email(email);
                    if (bcc != null && !bcc.equals("")) {
                        mail.setBcc(bcc);
                    }
                    mail.setBody((header != null && !header.equals("") ? header : "") + "<b>User:</b> " + name + "<br><b>Full name:</b> " + fullName + "<br><b>Password:</b> " + password + (footer != null && !footer.equals("") ? footer : ""));
                    mail.setSubject("Your account has been successfully created");
                    mail.setMimeType("text/html");
                    ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(SMTPMailServer.class.getClassLoader());
                    sMTPMailServer.send(mail);
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                    response.put("mailStatus", "successfully sent");
                } else {
                    response.put("mailStatus", "not sent, mail server does not exist");
                }
            }
        }
        catch (LicenseUserLimitExceededException e) {
            response.put("message", "License User Limit Exceeded ");
            return Response.serverError().entity(response).build();
        }
        catch (InfrastructureException e) {
            response.put("message", "Failed to create user: '" + name + "' :: InfrastructureException");
            return Response.serverError().entity(response).build();
        }
        catch (MailException e) {
            response.put("mailStatus", "error while sending :: " + e.getMessage());
        }
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/rename/{userName}")
    public Response rename(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - rename");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String name = "";
        try {
            name = jsonObject.get("name").toString();
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - addUser - name:empty");
        }
        if (name.equals("")) {
            response.put("message", "parameter 'name' is required");
            return Response.serverError().entity(response).build();
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(userName);
        if (confluenceUser == null) {
            response.put("message", "User '" + userName + "' does not exist");
            return Response.serverError().entity(response).build();
        }
        if (this.userAccessor.isReadOnly((User)confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isUserExistByName(name)) {
            response.put("message", "User with name '" + name + "' already exist");
            return Response.serverError().entity(response).build();
        }
        if (StringUtils.containsAny((CharSequence)name, (CharSequence)"\\,+<>'\"")) {
            response.put("message", "Usernames cannot contain the characters +, <, >, comma, backslash, apostrophe, or quote");
            return Response.serverError().entity(response).build();
        }
        if (!name.matches("[^\\s]+")) {
            response.put("message", "Usernames cannot contain any whitespace characters");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(name) || "anonymous".equalsIgnoreCase(name)) {
            response.put("message", "This username is reserved for use by Confluence");
            return Response.serverError().entity(response).build();
        }
        if (!name.equals(name.toLowerCase())) {
            response.put("message", "The username must be in lower case");
            return Response.serverError().entity(response).build();
        }
        String oldName = confluenceUser.getName();
        confluenceUser = this.userAccessor.getUserByName(name);
        if (confluenceUser != null) {
            response.put("message", "New user name '" + name + "' exist");
            return Response.serverError().entity(response).build();
        }
        try {
            this.userAccessor.renameUser(this.userAccessor.getUserByName(userName), name);
        }
        catch (Exception e) {
            response.put("message", "Internal error " + e);
            return Response.serverError().entity(response).build();
        }
        response.put("message", "User name '" + oldName + "' was changed into '" + name + "'");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/changeDetails/{userName}")
    public Response changeDetails(String userJSON, @PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - changeDetails");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        JSONObject jsonObject = new JSONObject(userJSON);
        String fullName = "";
        try {
            fullName = jsonObject.get("fullName").toString();
            if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
                response.put("message", "Full Names cannot contain < or >");
                return Response.serverError().entity(response).build();
            }
            if (this.toolsHelper.getTranslation("anonymous.name").equalsIgnoreCase(fullName) || "anonymous".equalsIgnoreCase(fullName)) {
                response.put("message", "This name is reserved for use by Confluence");
                return Response.serverError().entity(response).build();
            }
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - changeDetails - fullName:empty");
        }
        String email = "";
        try {
            email = jsonObject.get("email").toString();
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - changeDetails - email:empty");
        }
        String password = "";
        try {
            password = jsonObject.get("password").toString();
        }
        catch (JSONException e) {
            log.debug((Object)"RESTAPI - changeDetails - password:empty");
        }
        if (email.equals("") && fullName.equals("") && password.equals("")) {
            response.put("message", "Please provide some details to change");
            return Response.serverError().entity(response).build();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (!this.canUpdateUser(confluenceUser)) {
            response.put("message", "User '" + userName + "' is externally managed or read-only user");
            return Response.serverError().entity(response).build();
        }
        boolean shouldUpdatePersonalInfo = false;
        DefaultUser userTemplate = new DefaultUser(confluenceUser);
        try {
            if (!fullName.equals("")) {
                userTemplate.setFullName(fullName);
                shouldUpdatePersonalInfo = this.shouldUpdatePersonalInfo(confluenceUser, fullName, this.getPersonalInformation(confluenceUser));
            }
            if (!email.equals("")) {
                userTemplate.setEmail(email);
            }
            if (!password.equals("")) {
                userTemplate.setPassword(password);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("save fullName:" + fullName));
                log.debug((Object)("save email:" + email));
                log.debug((Object)("save password:" + password));
                log.debug((Object)("save shouldUpdatePersonalInfo:" + shouldUpdatePersonalInfo));
            }
            this.userAccessor.saveUser((User)userTemplate);
            UserDetailsMap userDetailsMap = new UserDetailsMap(confluenceUser, this.userDetailsManager);
            userDetailsMap.copyPropertiesToManager();
            if (shouldUpdatePersonalInfo) {
                this.personalInformationManager.savePersonalInformation(confluenceUser, this.getPersonalInformation(confluenceUser), fullName);
            }
        }
        catch (Exception e) {
            String rootCause = ExceptionUtils.getRootCauseMessage((Throwable)e);
            response.put("message", "Failed to update user profile. Cause: " + rootCause);
            return Response.serverError().entity(response).build();
        }
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") was changed");
        return Response.ok(response).build();
    }

    public String getPersonalInformation(User user) {
        return this.getPersonalInformationEntity(user).getBodyContent().getBody();
    }

    private PersonalInformation getPersonalInformationEntity(User user) {
        return this.personalInformationManager.getOrCreatePersonalInformation(user);
    }

    private boolean shouldUpdatePersonalInfo(User user, String fullName, String newInfo) {
        PersonalInformation oldInfo = this.getPersonalInformationEntity(user);
        return oldInfo == null || !newInfo.equals(oldInfo.getBodyContent().getBody()) || this.hasFullNameChanged(user, fullName);
    }

    private boolean hasFullNameChanged(User user, String fullName) {
        return fullName != null && !fullName.trim().equals(user.getFullName());
    }

    private boolean canUpdateUser(User user) {
        return !this.toolsHelper.isExternalUserManagement() && !this.userAccessor.isReadOnly(user);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/delete/{userName}")
    public Response delete(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - delete");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        try {
            if (!this.userAccessor.isUserRemovable(confluenceUser)) {
                response.put("message", "User '" + userName + "' cannot be deleted");
                return Response.serverError().entity(response).build();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.objectHasGlobalPermission("user", userName, "SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        this.userAccessor.removeUser(confluenceUser);
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") was deleted");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/activate/{userName}")
    public Response activate(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - activate");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        this.userAccessor.reactivateUser(confluenceUser);
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") activated");
        return Response.ok(response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/deactivate/{userName}")
    public Response deactivate(@PathParam(value="userName") String userName, @Context HttpServletRequest request) throws JSONException {
        log.debug((Object)"RESTAPI - deactivate");
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.toolsHelper.isLicenseIsValid()) {
            return this.toolsHelper.licenseIsInvalid();
        }
        if (this.toolsHelper.isReadOnly()) {
            return this.toolsHelper.readOnlyMode();
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            return this.toolsHelper.permissionViolation();
        }
        User confluenceUser = this.toolsHelper.getUserByName(userName);
        if (!this.toolsHelper.isUserExistByName(userName)) {
            return this.toolsHelper.userNotFound(userName);
        }
        if (this.userAccessor.isReadOnly(confluenceUser)) {
            response.put("message", "User '" + userName + "' is read only");
            return Response.serverError().entity(response).build();
        }
        if (this.toolsHelper.isConfluenceAdministrator() && !this.toolsHelper.isSystemAdministrator() && this.toolsHelper.objectHasGlobalPermission("user", userName, "SYSTEMADMINISTRATOR")) {
            return this.toolsHelper.permissionViolation();
        }
        this.userAccessor.deactivateUser(confluenceUser);
        response.put("message", "User " + confluenceUser.getName() + " (" + confluenceUser.getFullName() + ") deactivated");
        return Response.ok(response).build();
    }
}

