/*
 * Decompiled with CFR 0.152.
 */
package com.itlab.confluence.plugins.restextender.ui;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.itlab.confluence.plugins.restextender.helper.ToolsHelper;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestApiConfigurationServlet
extends HttpServlet {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    private ToolsHelper toolsHelper;

    @Inject
    public RestApiConfigurationServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ToolsHelper toolsHelper) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.toolsHelper = toolsHelper;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.toolsHelper.isConfluenceAdministrator()) {
            String baseUrl = this.toolsHelper.getBaseUrl();
            response.sendRedirect(baseUrl);
        }
        response.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isLicenseIsValid", this.isLicenseIsValid());
        params.put("isReadOnly", this.toolsHelper.isReadOnly());
        params.put("baseUrl", this.toolsHelper.getBaseUrl());
        params.put("isSensitiveCustomer", this.isLicenseIsValid() ? Boolean.valueOf(this.toolsHelper.isSensitiveCustomer()) : "");
        this.renderer.render("templates/extender-restApiConfiguration.vm", params, (Writer)response.getWriter());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String baseUrl = this.toolsHelper.getBaseUrl();
        response.sendRedirect(baseUrl);
    }

    public boolean isLicenseIsValid() {
        return this.toolsHelper.isLicenseIsValid();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

