pluginConfiguration={};

AJS.$(document).ready(function() {
	console.log("config confl .pp");
	pluginConfiguration.hideEditElements();
	pluginConfiguration.addDialogsTriggers();
	pluginConfiguration.addSwitchToEditModeTriggers();
	pluginConfiguration.addSwitchToViewModeTriggers();
	pluginConfiguration.addChangeDisplayedGroupTriggers();
	pluginConfiguration.hideErrors();


	/* Translated fields custom behavior*/
    pluginConfiguration.addLanguageConfListeners("passwordExpirationNotifierEmailSubject","passwordExpirationNotifierEmailSubject","passwordExpirationNotifierEmailSubjectSelect");
    pluginConfiguration.addLanguageConfListeners("passwordExpirationNotifierEmailBody","passwordExpirationNotifierEmailBody","passwordExpirationNotifierEmailBodySelect");
    pluginConfiguration.addLanguageConfListeners("passwordExpirationNotifierEmailFromName","passwordExpirationNotifierEmailFromName","passwordExpirationNotifierEmailFromNameSelect");
    pluginConfiguration.addLanguageConfListeners("passwordExpiredNotifierEmailSubject","passwordExpiredNotifierEmailSubject","passwordExpiredNotifierEmailSubjectSelect");
    pluginConfiguration.addLanguageConfListeners("passwordExpiredNotifierEmailBody","passwordExpiredNotifierEmailBody","passwordExpiredNotifierEmailBodySelect");
});

pluginConfiguration.addDialogsTriggers = function addDialogsTriggers() {
	jQuery(".config-dialog-trigger").each(function(){
		var id = jQuery(this).attr("href");
		pluginConfiguration.addDialogTrigger(id);
	});
};

pluginConfiguration.addDialogTrigger = function addDialogTrigger(id) {
};

pluginConfiguration.hideErrors = function hideErrors() {
	var errors = pluginConfiguration.getErrorsSelector();
	errors.hide();
};

pluginConfiguration.showErrors = function showErrors() {
	var errors = pluginConfiguration.getErrorsSelector();
	errors.show();
};

pluginConfiguration.addSwitchToEditModeTriggers= function addSwitchToEditModeTriggers(){
	var editButtons = pluginConfiguration.getEditButtonsSelector();
	editButtons.click(function(){
		var configId = jQuery(this).attr("identifier");
		pluginConfiguration.switchConfigElementToEditMode(configId);
		pluginConfiguration.hideError(configId);
		return false;
	});
};

pluginConfiguration.addSwitchToViewModeTriggers = function addSwitchToViewModeTriggers(){
	pluginConfiguration.addSwitchToViewModeOnEnterClickTriggers();
	pluginConfiguration.addSwichToViewModeOnFocusoutTriggers();
};

pluginConfiguration.switchedToViewOnEnterClick = false;

pluginConfiguration.addSwitchToViewModeOnEnterClickTriggers = function addSwitchToViewModeOnEnterClickTriggers(){
	var editElements = pluginConfiguration.getConfigEditInputElementsSelector();
	editElements.keypress(function(e) {
		if(jQuery(this).attr("confg-fieldtype") === "text-area"){
			return;
		}
		if(e.keyCode == 13){
			pluginConfiguration.switchedToViewOnEnterClick = true;
			pluginConfiguration.submitNewValue(jQuery(this));
		}
	});
};

pluginConfiguration.addSwichToViewModeOnFocusoutTriggers = function addSwichToViewModeOnFocusoutTriggers() {
	var editElements = pluginConfiguration.getConfigEditInputElementsSelector();	
	if(pluginConfiguration.isSafari()) {
		editElements.next().click(function() {
			pluginConfiguration.submitNewValue(jQuery(this).prev());
			return false;
		});
	} else {
		editElements.focusout(function(){
			if(pluginConfiguration.switchedToViewOnEnterClick){
				pluginConfiguration.switchedToViewOnEnterClick = false;
				return;
			}
			pluginConfiguration.submitNewValue(jQuery(this));
			return false;
		}); 
	}
};

pluginConfiguration.submitNewValue = function submitNewValue(inputSelector) {
	var type = inputSelector.attr("confg-fieldtype");
	
	var configId = inputSelector.attr("identifier");
	var insertedValue = "";
	if(type == "text" || type == "select" || type == "text-area"){
		insertedValue = inputSelector.val();
//		console.log("insertedValue: " + insertedValue);
	} else if (type == "boolean"){
		insertedValue = inputSelector.is(":checked");
	}
	pluginConfiguration.tryUpdateConfig(type, configId, insertedValue);
	pluginConfiguration.switchConfigElementToViewMode(configId);
};

pluginConfiguration.isSafari = function() {
	var userAgent = 'navigator' in window && 'userAgent' in navigator && navigator.userAgent.toLowerCase() || '';
	var vendor = 'navigator' in window && 'vendor' in navigator && navigator.vendor.toLowerCase() || '';
    return /safari/i.test(userAgent) && /apple computer/i.test(vendor);
};

pluginConfiguration.addChangeDisplayedGroupTriggers = function addChangeDisplayedGroupTriggers() {
	var buttons = pluginConfiguration.getGroupsButtonsSelector();
	buttons.click(function() {
		var groupNameToShow = jQuery(this).attr("group");
		pluginConfiguration.hideCurrentGroup();
		pluginConfiguration.showGroup(groupNameToShow);
	});
};

pluginConfiguration.getSelectedGroupName = function getSelectedGroupName() {
	var button = pluginConfiguration.getSelectedGroupButtonSelector();
	var groupName = button.attr("group");
	return groupName;
};

pluginConfiguration.getEditButtonsSelector = function getEditButtonsSelector() {
	var buttons = jQuery(".aui-iconfont-edit.config-edit-button");
	return buttons;
};

pluginConfiguration.showGroup = function showGroup(groupName) {
	pluginConfiguration.showGroupElements(groupName);
	pluginConfiguration.showGroupDescription(groupName);
	pluginConfiguration.setGroupButtonSelected(groupName);
};

pluginConfiguration.showGroupElements = function showGroupElements(groupName) {
	var groups = pluginConfiguration.getGroupElementsSelector(groupName);
	groups.each(function() {
		jQuery(this).fadeIn();
	});
};

pluginConfiguration.showGroupDescription = function showGroupDescription(groupName) {
	var description = pluginConfiguration.getGroupDescriptionSelector(groupName);
	description.fadeIn();
};

pluginConfiguration.hideCurrentGroup = function hideCurrentGroup() {
	var selectedGroupName = pluginConfiguration.getSelectedGroupName();
	pluginConfiguration.hideGroup(selectedGroupName);
};

pluginConfiguration.hideGroup = function hideGroup(groupName) {
	pluginConfiguration.hideGroupElements(groupName);
	pluginConfiguration.hideGroupDescription(groupName);
	pluginConfiguration.setGroupButtonDeseleced(groupName);
};
 
pluginConfiguration.setGroupButtonDeseleced = function setGroupButtonDeseleced(groupName) {
	var button = pluginConfiguration.getGroupButtonSelector(groupName);
	button.removeClass("aui-nav-selected");
};

pluginConfiguration.setGroupButtonSelected = function setGroupButtonSelected(groupName) {
	var button = pluginConfiguration.getGroupButtonSelector(groupName);
	button.addClass("aui-nav-selected");
}; 
	
pluginConfiguration.hideGroupElements = function hideGroupElements(groupName) {
	var groupElements = pluginConfiguration.getGroupElementsSelector(groupName);
	groupElements.each(function() {
		jQuery(this).hide();
	});
};

pluginConfiguration.hideGroupDescription = function hideGroupDescription(groupName) {
	var descriptions = pluginConfiguration.getGroupDescriptionSelector(groupName);
	descriptions.each(function() {
		jQuery(this).hide();
	});
};

pluginConfiguration.getGroupDescriptionSelector = function getGroupDescriptionSelector(groupName) {
	var selectedGroupDescription = jQuery(".group-description[group="+ groupName +"]");
	return selectedGroupDescription;
};

pluginConfiguration.getGroupElementsSelector = function getGroupElementsSelector(groupName) {
	var selectedGroups = jQuery(".field-group[group="+ groupName +"]");
	return selectedGroups;
};

pluginConfiguration.getGroupButtonSelector = function getGroupButtonSelector(groupName) {
	var groupButtons = jQuery(".group-button[group="+ groupName +"]");
	return groupButtons;
};

pluginConfiguration.getErrorsSelector = function getErrorsSelector() {
	var errors = jQuery(".conifg-error");
	return errors;
};

pluginConfiguration.getGroupsButtonsSelector = function getGroupsButtonsSelector() {
	var groupButtons = jQuery(".group-button");
	return groupButtons;
};

pluginConfiguration.getSelectedGroupButtonSelector = function getSelectedGroupButtonSelector() {
	var selectedGroupButton = jQuery(".group-button.aui-nav-selected");
	return selectedGroupButton;
};

pluginConfiguration.setErrorMessage = function setErrorMessage(configId, errorMessage) {
	var errorElement = pluginConfiguration.getConfigElement(configId).find(".error");
	errorElement.text(errorMessage);
};

pluginConfiguration.switchConfigElementToEditMode = function switchConfigElementToEditMode(configId) {
	var configEditElement = pluginConfiguration.getConfigEditElement(configId);
	
	var inputElement = configEditElement.find("input");
	if(inputElement.length !== 0){
		configEditElement.show();
		inputElement.focus();
		inputElement.select();
	}
	var selectElement = configEditElement.find("select");
	if(selectElement.length !== 0){
		configEditElement.show();
		selectElement.focus();
	}
	var textareaElement = configEditElement.find("textarea");
	if(textareaElement.length !== 0){
//		configEditElement.css('display', 'flex');
		configEditElement.show();
		textareaElement.focus();
	}	
	pluginConfiguration.getConfigViewElement(configId).hide();
};

pluginConfiguration.switchConfigElementToViewMode = function switchConfigElementToViewMode(configId) {
	pluginConfiguration.getConfigEditElement(configId).hide();
	pluginConfiguration.getConfigViewElement(configId).show();
};

pluginConfiguration.showError = function showError(configId) {
	var configElement = pluginConfiguration.getConfigElement(configId);
	configElement.find(".error").show();
};

pluginConfiguration.hideError = function hideError(configId) {
	var configElement = pluginConfiguration.getConfigElement(configId);
	configElement.find(".error").hide();
};

pluginConfiguration.getConfigElement = function getConfigElement(configId) {
	var selectedElement = jQuery(".field-group."+ configId);
	return selectedElement;
};

pluginConfiguration.getConfigViewElement = function getConfigViewElement(configId) {
	var selectedElement = jQuery(".field-group ."+ configId +".config-item-view");
	return selectedElement;
};

pluginConfiguration.getConfigEditElement = function getConfigEditElement(configId) {
	var selectedElement = jQuery(".field-group ."+ configId +".config-edit");
	return selectedElement;
};

pluginConfiguration.hideEditElements = function hideEditElements() {
	var editElements = pluginConfiguration.getConfigEditElementsSelector();
	editElements.hide();
};

pluginConfiguration.showEditElements = function showEditElements() {
	var editElements = pluginConfiguration.getConfigEditElementsSelector();
	editElements.show();
};

pluginConfiguration.getConfigEditElementsSelector = function getConfigEditElementsSelector() {
	var selectedElement = jQuery(".field-group .config-edit");
	return selectedElement;
};

pluginConfiguration.getConfigEditSelectElementsSelector = function getConfigEditSelectElementsSelector() {
	var selectedElement = jQuery(".field-group .config-edit").find("select");
	return selectedElement;
};

pluginConfiguration.getConfigEditInputElementsSelector = function getConfigEditInputElementsSelector() {
	var selectedElement = jQuery(".field-group .config-edit").find("input, select, textarea");
	return selectedElement;
};

pluginConfiguration.updateView = function updateView(type, configId, newValue) {
	var configViewElement = pluginConfiguration.getConfigViewElement(configId).find(".config-displayed-value");
	
	if(type == "text"){
		configViewElement.html(newValue);
	} else if(type == "boolean"){
		configViewElement.find("input[type=checkbox]").prop("checked", newValue);
	} else if(type == "select"){
		var configEditElement = pluginConfiguration.getConfigEditElement(configId).find("select");
		var toView = pluginConfiguration.getSelectedOptionByValue(configId, newValue);
		configViewElement.html(toView);
	} else if(type == "text-area"){
		configViewElement.val(newValue);
	}
};

pluginConfiguration.getSelectedOptionByValue = function getSelectedOptionByValue(configId, value) {
	var editElement = pluginConfiguration.getConfigEditElement(configId);
	var selectedValue = editElement.find("option[value='" + value + "']");
	var result = selectedValue.attr("to-item-view-value");
	return result;
};

pluginConfiguration.tryUpdateConfig = function tryUpdateConfig(type, configId, newValue,key) {
    jQuery.ajax({
        url: AJS.params.baseUrl + "/rest/password-policy-plugin-configuration/1.0/config/updateConfigValue",
        type: "POST",
        data: JSON.stringify({"type" : type,
            "configId" : configId,
            "newValue" : newValue,
            "updatedKey":key
        }),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function(response){
            if(response.errors.length){
                pluginConfiguration.setErrorMessage(configId, response.errors[0]);
                AJS.messages.error("#error-message-context", {
                    title: 'Config save failed.',
                    body: '<p>' + response.errors[0] + '</p>'
                }).show();
                return;
            }
            AJS.messages.success("#success-message-context", {
                title: response.okMessage,
                fadeout: true,
                closable: true,
                delay: 2000
            }).show();
            pluginConfiguration.updateView(type, configId, newValue);
        }
    });
};

pluginConfiguration.addLanguageSelectListeners = function(selectSelector,viewTextSelector,viewTextId){
    var selectEnabled = jQuery(selectSelector).filter(":enabled");
    $(selectEnabled).change(function () {
        var str = "";
        $( "select option:selected" ).each(function() {
            var selectedKey =  jQuery(selectSelector).filter(":enabled").find(':selected').val();
            //set option for disabled select
            jQuery(selectSelector).find('option[value=' +selectedKey+']').attr('selected','selected')
            pluginConfiguration.getTranslationAndUpdateTextArea(viewTextSelector,viewTextId,selectedKey);
        });
    })
        .change();
}
/*
 * This is a tick confirmation listener. Only works for userAccountLockedContent
 *
 */
pluginConfiguration.addLanguageConfListeners = function(tickId,textAreaSelectorId,selectSelectorId){
    var tickSelector= "a[identifier='"+tickId+"'].config-item-view-button";
    var textAreaSelector="textarea[name='"+textAreaSelectorId+"']";
    var selectSelector="select[identifier='"+selectSelectorId+"']";
    pluginConfiguration.addLanguageSelectListeners(selectSelector,textAreaSelector,textAreaSelectorId);
    pluginConfiguration.disableDefaultBehaviorLanguageConf(tickSelector,selectSelector);

    var confirmTicks = jQuery(tickSelector);
    confirmTicks.click(function(e){
        var inputSelector=jQuery(this).siblings('textarea');
        var configId = inputSelector.attr("identifier");
        var value = inputSelector.val();
        var selectEnabled = jQuery(selectSelector).filter(":enabled");
        var selectedkey = selectEnabled.find(':selected').val();

        pluginConfiguration.updateTranslationTextArea(textAreaSelector,value);
        pluginConfiguration.tryUpdateConfig('text-area-translation', configId, value,selectedkey);
        pluginConfiguration.switchConfigElementToViewMode(configId);


    });
}

pluginConfiguration.disableDefaultBehaviorLanguageConf = function disableDefaultBehaviorLanguageConf(tickSelector,selectSelector) {
    var confirmTicks = jQuery(tickSelector);
    var textarea = confirmTicks.siblings('textarea');
    jQuery(textarea).unbind('focusout')
    var select = jQuery(selectSelector);
    jQuery(select).unbind('focusout');
}

pluginConfiguration.getTranslationAndUpdateTextArea = function getTranslationAndUpdateTextArea(textAreaSelector,configId,key) {
    jQuery.ajax({
        url: AJS.params.baseUrl + "/rest/password-policy-plugin-configuration/1.0/config/getTranslation/"+configId+"/"+key,
        type: "GET",
        success: function(response){
            pluginConfiguration.updateTranslationTextArea(textAreaSelector,response);
        }
    });
};

pluginConfiguration.updateTranslationTextArea = function updateTranslation(textAreaSelector,translation) {
    var viewtext = jQuery(textAreaSelector);
    viewtext.val(translation);
};