INTENSO={};
INTENSO.passwordPolicy={};

AJS.$(document).ready(function(){
	INTENSO.passwordPolicy.initDateTimePickers();
	INTENSO.passwordPolicy.initTriggers();
	jQuery("#new-datetime-picker").val("");
	jQuery("#new-user-name").val("");
});

INTENSO.passwordPolicy.initDateTimePickers = function initDateTimePickers() {
	var currentDate = jQuery("#new-datetime-picker").attr("datepicker-start-date");
	AJS.$("#new-datetime-picker").datetimepicker({
		dayOfWeekStart : 1,
		lang:'en',
		startDate:	currentDate
	});
};

INTENSO.passwordPolicy.initTriggers = function initTriggers(){
	INTENSO.passwordPolicy.addUserPolicyTrigger();
	INTENSO.passwordPolicy.editUserPolicyTrigger();
	INTENSO.passwordPolicy.updateUserPolicyTrigger();
	INTENSO.passwordPolicy.removeUserPolicyTrigger();
};

INTENSO.passwordPolicy.addUserPolicyTrigger = function addUserPolicyTrigger(){
	jQuery("#password-policy-add-user-policy-button").click(function(){
		INTENSO.passwordPolicy.addUserPolicy();
		return false; 
	});
};

INTENSO.passwordPolicy.addUserPolicy = function addUserPolicy(){
	var dateValue = jQuery("#new-datetime-picker").val();
	var userNameValue = jQuery("#new-user-name").val();
	if(dateValue != "" && userNameValue != "" ){
		INTENSO.passwordPolicy.updateLockingPolicy(userNameValue, dateValue);
	}
};

INTENSO.passwordPolicy.editUserPolicyTrigger = function editUserPolicyTrigger(){
	jQuery(".password-policy-edit-user-policy").click(function(){ 
		INTENSO.passwordPolicy.editUserPolicy(jQuery(this).parent().parent());
		return false; 
	});
};

INTENSO.passwordPolicy.updateUserPolicyTrigger = function updateUserPolicyTrigger(){
	jQuery(".password-policy-update-user-policy").click(function(){ 
		INTENSO.passwordPolicy.updateUserPolicy(jQuery(this).parent().parent());
		return false; 
	});
};

INTENSO.passwordPolicy.removeUserPolicyTrigger = function removeUserPolicyTrigger(){
	jQuery(".password-policy-remove-user-policy").click(function(){ 
		INTENSO.passwordPolicy.removeUserPolicy(jQuery(this).parent().parent());
		return false; 
	});
};

INTENSO.passwordPolicy.removeUserPolicy = function removeUserPolicy(tableRow){
	var username = tableRow.attr("username");
	INTENSO.passwordPolicy.removeLockingPolicy(username);
};

INTENSO.passwordPolicy.updateUserPolicy = function updateUserPolicy(tableRow){
	var username = tableRow.attr("username");
	var newDate = tableRow.find(".password-policy-date-picker").val();
	INTENSO.passwordPolicy.updateLockingPolicy(username, newDate);
	
};

INTENSO.passwordPolicy.editUserPolicy = function editUserPolicy(tableRow){
	INTENSO.passwordPolicy.prepareDateToEdit(tableRow);
	INTENSO.passwordPolicy.prepareButtonsToEdit(tableRow);
};

INTENSO.passwordPolicy.prepareDateToEdit = function prepareDateToEdit(tableRow){
	var dateElement = tableRow.find(".password-policy-date-showed");
	
	var previousDate = dateElement.html();
	dateElement.hide();
	
	var datePicker = tableRow.find(".password-policy-date-picker");
	datePicker.show();
	tableRow.find(".password-policy-date-picker").datetimepicker({value: previousDate, dayOfWeekStart : 1, lang:'en'});
};

INTENSO.passwordPolicy.prepareButtonsToEdit = function prepareButtonsToEdit(tableRow){
	var editLink = tableRow.find(".password-policy-edit-user-policy");
	editLink.hide();
	
	var updateLink = tableRow.find(".password-policy-update-user-policy");
	updateLink.show();
	
};

INTENSO.passwordPolicy.removeLockingPolicy = function removeLockingPolicy(userName){
	var webappcontextpath = AJS.Data.get("context-path");
	var pUrl = webappcontextpath + '/rest/passpolicy/1.0/removeUserAccountLockAfterDatePolicy';
	jQuery.ajax({
		dataType : "json",
		url : pUrl,
		type : 'POST',
		contentType: "application/json; charset=utf-8",
		data : JSON.stringify({
			"username" : userName,
		}),
		success : function(data, textStatus, jqXHR) {
			if(data.usernameError){
				
			} else {
				location.reload();
			}
		}
	});
};

INTENSO.passwordPolicy.updateLockingPolicy = function updateLockingPolicy(userName, lockDate){
	var webappcontextpath = AJS.Data.get("context-path");
	var pUrl = webappcontextpath + '/rest/passpolicy/1.0/updateUserAccountLockAfterDatePolicy';
	jQuery.ajax({
		dataType : "json",
		url : pUrl,
		type : 'POST',
		contentType: "application/json; charset=utf-8",
		data : JSON.stringify({
			"username" : userName,
			"lockDate" : lockDate 
		}),
		success : function(data, textStatus, jqXHR) {
			if(data.usernameError){
				INTENSO.passwordPolicy.showError(data.usernameError);
			} else {
				location.reload();
			}
		}
	});
};
INTENSO.passwordPolicy.showError = function showError(message){
	AJS.flag({
		type: 'error',
		body: message,
		close: 'auto'
	})
};

