passwordPolicy = {};
passwordPolicy.lockAfterFailedLogin = {};

passwordPolicy.lockAfterFailedLogin.isLoginPage = function isLoginPage() {
	return window.location.href.indexOf("login.action") !== -1
}

passwordPolicy.lockAfterFailedLogin.isLoginAttemptFailed = function isLoginAttemptFailed(){
	const error = jQuery("#login-container").find(".aui-message-error");
	return typeof error !== undefined && error.length !== 0;
};

passwordPolicy.lockAfterFailedLogin.getUsername= function getUsername(){
	const username = jQuery("#os_username");
	return username.val();
};

passwordPolicy.lockAfterFailedLogin.showWarningMessage = function showWarningMessage(message){
	const warningDiv = "<div id='password-policy-lock-after-login' class='aui-message aui-message-error'>" + message + "</div>";
	jQuery("#login-container").find(".aui-message").after(warningDiv);
};

passwordPolicy.lockAfterFailedLogin.showConfluence9WarningMessage = function showWarningMessage(message){
	const currentWarningDiv = jQuery('#password-policy-lock-after-login');
	const currentWarningDivLength = currentWarningDiv != null
		? currentWarningDiv.length
		: null;
	const currentLength = currentWarningDivLength != null
		? currentWarningDivLength
		: 0;

	const warningDiv = currentLength !== 0
		? currentWarningDiv.detach()
		: "<div id='password-policy-lock-after-login' class='aui-message aui-message-error' style='margin-bottom: 12px'>" + message + "</div>";

	jQuery("#login-header").after(warningDiv);
};

passwordPolicy.lockAfterFailedLogin.getFailedLoginAttempt = function getFailedLoginAttempt(username, passwordPolicyMessageCallback) {
	jQuery.ajax({
		type : "GET",
		url : AJS.params.baseUrl + '/rest/passpolicy/1.0/failedLoginAttempt?username='+username,
		success: function(response){
			if(response.message.length){
				passwordPolicyMessageCallback(response.message);
			}
		}
	});
}

passwordPolicy.lockAfterFailedLogin.getTargetUrl = function getTargetUrl(input) {
	if(input == null) {
		return '';
	}
	if(input.url != null) {
		return input.url;
	}
	const inputString = input.toString();

	return inputString != null
		? inputString
		: '';
}

jQuery(document).ready(function() {
	if(!passwordPolicy.lockAfterFailedLogin.isLoginPage()) {
		return;
	}
	//Legacy login attempt failed
	if(passwordPolicy.lockAfterFailedLogin.isLoginAttemptFailed()){
	    const username = passwordPolicy.lockAfterFailedLogin.getUsername();
	    passwordPolicy.lockAfterFailedLogin.getFailedLoginAttempt(username, passwordPolicy.lockAfterFailedLogin.showWarningMessage);
		return;
	}

	//New login attempt failed
	// Reference to the original prototype method we're overriding
	const originalWindowFetch = window.fetch;

	window.fetch = function(input, init) {
		// Execute the original prototype.open without affecting its execution context
		const responsePromise = originalWindowFetch.call(this, input, init)
		if(!passwordPolicy.lockAfterFailedLogin.isLoginPage()) {
			return responsePromise
		}
		const targetUrl = passwordPolicy.lockAfterFailedLogin.getTargetUrl(input);
		if(targetUrl.indexOf('/rest/tsv/1.0/authenticate') === -1) {
			return responsePromise;
		}
		return responsePromise.then(response => {
			if(response.status !== 200) {
				const body = init != null
					? init.body
					: null;
				const payloadJson = body != null
					? body
					: '{}';
				const parsedObject = JSON.parse(payloadJson);
				const username = parsedObject != null
					? parsedObject.username
					: null;
				passwordPolicy.lockAfterFailedLogin.getFailedLoginAttempt(username, passwordPolicy.lockAfterFailedLogin.showConfluence9WarningMessage);
			} else {
				const passwordPolicyDiv = jQuery('#password-policy-lock-after-login');
				if(passwordPolicyDiv != null) {
					passwordPolicyDiv.detach();
				}
			}
			return response;
		});
	};
});

