AJS.$(document).ready(function(){
	initListeners();
});
		
function initListeners() {
	var userAccountLockingCheckbox = jQuery("#userAccountLockingCheckbox");
	userAccountLockingCheckbox.click(function(){
		userAccountLockingListener(jQuery(this));
	});
	
	var userAccountLockingAfterExpirationCheckbox = jQuery("#userAccountLockingAfterPasswordExpirationCheckbox");
	userAccountLockingAfterExpirationCheckbox.click(function(){
		userAccountLockingAfterExpirationListener(jQuery(this));
	});
}

function userAccountLockingListener(thisElement) {
	var isChecked = thisElement.is(":checked");
	var fieldUsedToTransportValueToModel = jQuery("#userAccountLockingField");
	fieldUsedToTransportValueToModel.val(isChecked);
	
	if(isChecked){
		enableLockingAfterPasswordExpirationCheckbox();
		enableLockedPageContent();
	} else {
		disableLockingAfterPasswordExpirationCheckbox();
		setValueOnLockingAfterPasswordExpirationCheckbox(false);
		disableDaysField();
		disableLockedPageContent();
	}
}

function userAccountLockingAfterExpirationListener(thisElement) {
	var isChecked = thisElement.is(":checked");
	var fieldToTransportValueToModel = jQuery("#userAccountLockingAfterPasswordExpirationDateField");
	fieldToTransportValueToModel.val(isChecked);
	if(isChecked){
		enableDaysField();
	} else {
		disableDaysField();
	}
}

function disableDaysField(){
	var daysField = jQuery("#daysAfterPasswordExpirationToLockUserAccountField");
	daysField.prop('disabled', true);
}

function disableLockingAfterPasswordExpirationCheckbox(){
	var checkbox = jQuery("#userAccountLockingAfterPasswordExpirationCheckbox");
	checkbox.prop('disabled', true);
}

function setValueOnLockingAfterPasswordExpirationCheckbox(booleanValue){
	var checkbox = jQuery("#userAccountLockingAfterPasswordExpirationCheckbox");
	checkbox.prop('checked', booleanValue);
	jQuery("#userAccountLockingAfterPasswordExpirationDateField").val(booleanValue);
}

function disableLockedPageContent(){
	var content = jQuery("#userAccountLockedPageContentField");
	content.prop('disabled', true);
}

function enableDaysField(){
	var daysField = jQuery("#daysAfterPasswordExpirationToLockUserAccountField");
	daysField.prop('disabled', false);
}

function enableLockingAfterPasswordExpirationCheckbox(){
	var checkbox = jQuery("#userAccountLockingAfterPasswordExpirationCheckbox");
	checkbox.prop('disabled', false);
}

function enableLockedPageContent(){
	var content = jQuery("#userAccountLockedPageContentField");
	content.prop('disabled', false);
	if(isLockedPageContentEmpty()){
		setDefaultLockedPageContent();
	}
}

function setDefaultLockedPageContent(){
	var defaultValue = "<h3>Your account has been locked</h3>\n<div>To unlock your account contact your Confluence Administrator</div>";
	jQuery('#userAccountLockedPageContentField').val(defaultValue);
}

function isLockedPageContentEmpty(){
	return jQuery('#userAccountLockedPageContentField').val() == "";
}

var isConfigurationFormSubmited = false;
function toggleFields() {
	var disable = jQuery('#enabledCheckbox').attr('checked') ? false : true;
	var inputs = jQuery('#passwordPolicyConfigurationForm input:text');
	if (disable) {
		inputs.attr('disabled', 'disabled');
		jQuery('#passwordCharacterCharacteristicsCheckbox').removeAttr('checked');
		jQuery('#passwordCharacterCharacteristicsDiv').hide();
		jQuery('#passwordCharacterCharacteristicsField').val('false');
		jQuery('#passwordCharacterCharacteristicsCheckbox').attr('disabled','disabled');
		jQuery('#adminCanSkipPasswordChangeCheckbox').attr('disabled','disabled');
		jQuery('#passwordExpirationNotifierEnabledCheckbox').attr('disabled','disabled');
		jQuery('#userAccountLockingCheckbox').attr('disabled','disabled');
		jQuery('#userAccountLockingAfterFailedLoginsEnabledCheckbox').attr('disabled','disabled');
	} else {
		inputs.removeAttr('disabled');
		jQuery('#passwordCharacterCharacteristicsCheckbox').removeAttr('disabled');
		jQuery('#adminCanSkipPasswordChangeCheckbox').removeAttr('disabled');
		jQuery('#passwordExpirationNotifierEnabledCheckbox').removeAttr('disabled');
		jQuery('#userAccountLockingCheckbox').removeAttr('disabled');
		jQuery('#userAccountLockingAfterFailedLoginsEnabledCheckbox').removeAttr('disabled');
		onPasswordExpirationNotifierEnabledClick();
	}
}

function onPasswordExpirationNotifierEnabledClick() {
	var checkbox = jQuery('#passwordExpirationNotifierEnabledCheckbox')[0];
	jQuery('#passwordExpirationNotifierEnabledField').val(checkbox.checked);
	if (checkbox.checked) {
		jQuery('#passwordExpirationNotifierDurationField').removeAttr('disabled');
		jQuery('#passwordExpirationNotifierEmailSubjectField').removeAttr('disabled');
		jQuery('#passwordExpirationNotifierEmailBodyField').removeAttr('disabled');
		jQuery('#passwordExpirationNotifierEmailFromNameField').removeAttr('disabled');
		jQuery('#passwordExpiredNotifierEmailSubjectField').removeAttr('disabled');
		jQuery('#passwordExpiredNotifierEmailBodyField').removeAttr('disabled');				
		if(jQuery('#passwordExpirationNotifierEmailFromNameField').val() == "") {
			jQuery('#passwordExpirationNotifierEmailFromNameField').val("Confluence Password Expiration Notifier");
		}
		if(jQuery('#passwordExpirationNotifierEmailSubjectField').val() == "") {
			jQuery('#passwordExpirationNotifierEmailSubjectField').val("Password Expiration Notification");
		}
		if(jQuery('#passwordExpirationNotifierEmailBodyField').val() == "") {
			jQuery('#passwordExpirationNotifierEmailBodyField').val("Hi $userFullName,<br />\n<br />Your password for account <b>$userName</b> expires at $expirationDateTime \nPlease change your password <a href=\"$changePasswordUrl\">here</a> as soon as possible to prevent further logon problems.\n<br />\n<br />\nThank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence");
		}
		if(jQuery('#passwordExpiredNotifierEmailSubjectField').val() == "") {
			jQuery('#passwordExpiredNotifierEmailSubjectField').val("Password Expiration Notification");
		}
		if(jQuery('#passwordExpiredNotifierEmailBodyField').val() == "") {
			jQuery('#passwordExpiredNotifierEmailBodyField').val("Hi $userFullName,<br />\n<br />\nYour password for account <b>$userName</b> is expired. Please change your password <a href=\"$changePasswordUrl\">here</a>\n<br />\n<br />Thank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence");
		}
	} else {
		jQuery('#passwordExpirationNotifierDurationField').attr('disabled','disabled');
		jQuery('#passwordExpirationNotifierEmailSubjectField').attr('disabled','disabled');
		jQuery('#passwordExpirationNotifierEmailBodyField').attr('disabled','disabled');
		jQuery('#passwordExpirationNotifierEmailFromNameField').attr('disabled','disabled');
		jQuery('#passwordExpiredNotifierEmailSubjectField').attr('disabled','disabled');
		jQuery('#passwordExpiredNotifierEmailBodyField').attr('disabled','disabled');
	}
}

function onLockingAfterFailedLoginsChboxClick() {
	var checkbox = jQuery('#userAccountLockingAfterFailedLoginsEnabledCheckbox')[0];
	jQuery('#userAccountLockingAfterFailedLoginsEnabled').val(checkbox.checked);
}
