/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class UsernameRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_USERNAME";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_USERNAME_REVERSED";
    private boolean matchBackwards;
    private boolean ignoreCase;

    public UsernameRule() {
    }

    public UsernameRule(boolean mb, boolean ic) {
        this.setMatchBackwards(mb);
        this.setIgnoreCase(ic);
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword().getText();
        String user = passwordData.getUsername();
        String reverseUser = new StringBuilder(user).reverse().toString();
        if (this.ignoreCase) {
            text = text.toLowerCase();
            user = user.toLowerCase();
            reverseUser = reverseUser.toLowerCase();
        }
        if (text.contains(user)) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(user)));
        }
        if (this.matchBackwards && text.contains(reverseUser)) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE_REVERSED, this.createRuleResultDetailParameters(user)));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(String username) {
        LinkedHashMap<String, String> m4 = new LinkedHashMap<String, String>();
        m4.put("username", username);
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::ignoreCase=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.ignoreCase, this.matchBackwards);
    }
}

