/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_MATCH";
    protected final Pattern pattern;

    public RegexRule(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        Matcher m4 = this.pattern.matcher(passwordData.getPassword().getText());
        if (m4.find()) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(m4.group())));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(String match) {
        LinkedHashMap<String, Object> m4 = new LinkedHashMap<String, Object>();
        m4.put("match", match);
        m4.put("pattern", this.pattern);
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::pattern=%s", this.getClass().getName(), this.hashCode(), this.pattern);
    }
}

