/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class LengthRule
implements Rule {
    public static final String ERROR_CODE_MIN = "TOO_SHORT";
    public static final String ERROR_CODE_MAX = "TOO_LONG";
    private int minimumLength;
    private int maximumLength = Integer.MAX_VALUE;

    public LengthRule() {
    }

    public LengthRule(int length) {
        this.minimumLength = length;
        this.maximumLength = length;
    }

    public LengthRule(int minLength, int maxLength) {
        this.minimumLength = minLength;
        this.maximumLength = maxLength;
    }

    public void setMinimumLength(int minLength) {
        this.minimumLength = minLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMaximumLength(int maxLength) {
        this.maximumLength = maxLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        int length = passwordData.getPassword().length();
        if (length >= this.minimumLength && length <= this.maximumLength) {
            result.setValid(true);
        } else {
            result.setValid(false);
            if (length < this.minimumLength) {
                result.getDetails().add(new RuleResultDetail(ERROR_CODE_MIN, this.createRuleResultDetailParameters()));
            } else {
                result.getDetails().add(new RuleResultDetail(ERROR_CODE_MAX, this.createRuleResultDetailParameters()));
            }
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters() {
        LinkedHashMap<String, Integer> m4 = new LinkedHashMap<String, Integer>();
        m4.put("minimumLength", this.minimumLength);
        m4.put("maximumLength", this.maximumLength);
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::minimumLength=%s,maximumLength=%s", this.getClass().getName(), this.hashCode(), this.minimumLength, this.maximumLength);
    }
}

