/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.AbstractDigester;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class HistoryRule
extends AbstractDigester
implements Rule {
    public static final String ERROR_CODE = "HISTORY_VIOLATION";

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        int size = passwordData.getPasswordHistory().size();
        if (size == 0) {
            return result;
        }
        String cleartext = passwordData.getPassword().getText();
        for (String previousPassword : passwordData.getPasswordHistory()) {
            if (!this.matches(cleartext, previousPassword)) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(size)));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(int size) {
        LinkedHashMap<String, Integer> m4 = new LinkedHashMap<String, Integer>();
        m4.put("historySize", size);
        return m4;
    }
}

