/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CharacterCharacteristicsRule
implements Rule {
    public static final String ERROR_CODE = "INSUFFICIENT_CHARACTERISTICS";
    private List<CharacterRule> rules = new ArrayList<CharacterRule>();
    private int numCharacteristics = 1;

    public List<CharacterRule> getRules() {
        return this.rules;
    }

    public void setRules(List<CharacterRule> l) {
        this.rules = l;
    }

    public void setNumberOfCharacteristics(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacteristics = n;
    }

    public int getNumberOfCharacteristics() {
        return this.numCharacteristics;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        if (this.numCharacteristics > this.rules.size()) {
            throw new IllegalStateException("Number of characteristics must be <= to the number of rules");
        }
        int successCount = 0;
        RuleResult result = new RuleResult(true);
        for (CharacterRule rule : this.rules) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                result.getDetails().addAll(rr.getDetails());
                continue;
            }
            ++successCount;
        }
        if (successCount < this.numCharacteristics) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(successCount)));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(int success) {
        LinkedHashMap<String, Integer> m4 = new LinkedHashMap<String, Integer>();
        m4.put("successCount", success);
        m4.put("minimumRequired", this.numCharacteristics);
        m4.put("ruleCount", this.rules.size());
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacteristics=%s,rules=%s", this.getClass().getName(), this.hashCode(), this.numCharacteristics, this.rules);
    }
}

