/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class AllowedCharacterRule
implements Rule {
    public static final String ERROR_CODE = "ALLOWED_CHAR";
    private final char[] allowedChar;

    public AllowedCharacterRule(char[] c) {
        this.allowedChar = c;
        Arrays.sort(this.allowedChar);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (char c : passwordData.getPassword().getText().toCharArray()) {
            if (Arrays.binarySearch(this.allowedChar, c) >= 0) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(c)));
            break;
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Character> m4 = new LinkedHashMap<String, Character>();
        m4.put("illegalCharacter", Character.valueOf(c));
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::allowedChar=%s", this.getClass().getName(), this.hashCode(), this.allowedChar != null ? Arrays.toString(this.allowedChar) : null);
    }
}

