/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.util.Converter;

public abstract class AbstractDigester {
    protected DigestAlgorithm digest;
    protected Converter converter;

    public void setDigest(String algorithm, Converter conv) {
        this.digest = DigestAlgorithm.newInstance(algorithm);
        this.converter = conv;
    }

    protected boolean matches(String undigested, String reference) {
        String compare;
        if (this.digest != null) {
            byte[] hash = this.converter.toBytes(reference);
            int saltLength = hash.length - this.digest.getDigest().getDigestSize();
            if (saltLength > 0) {
                byte[] salt = this.extractSalt(hash, saltLength);
                byte[] saltedHash = this.addSalt(this.digest.digest(this.addSalt(undigested.getBytes(), salt)), salt);
                compare = this.converter.fromBytes(saltedHash);
            } else {
                compare = this.digest.digest(undigested.getBytes(), this.converter);
            }
        } else {
            compare = undigested;
        }
        return reference.equals(compare);
    }

    protected byte[] extractSalt(byte[] hash, int length) {
        byte[] salt = new byte[length];
        System.arraycopy(hash, hash.length - length, salt, 0, length);
        return salt;
    }

    protected byte[] addSalt(byte[] data, byte[] salt) {
        byte[] saltedData = new byte[data.length + salt.length];
        System.arraycopy(data, 0, saltedData, 0, data.length);
        System.arraycopy(salt, 0, saltedData, data.length, salt.length);
        return saltedData;
    }
}

