/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractDictionaryRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_WORD";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_WORD_REVERSED";
    protected Dictionary dictionary;
    protected boolean matchBackwards;

    public void setDictionary(Dictionary dict) {
        this.dictionary = dict;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void setMatchBackwards(boolean b) {
        this.matchBackwards = b;
    }

    public boolean isMatchBackwards() {
        return this.matchBackwards;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String text = passwordData.getPassword().getText();
        String matchingWord = this.doWordSearch(text);
        if (matchingWord != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(matchingWord)));
        }
        if (this.matchBackwards && (matchingWord = this.doWordSearch(text = new StringBuilder(passwordData.getPassword().getText()).reverse().toString())) != null) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE_REVERSED, this.createRuleResultDetailParameters(matchingWord)));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(String word) {
        LinkedHashMap<String, String> m4 = new LinkedHashMap<String, String>();
        m4.put("matchingWord", word);
        return m4;
    }

    protected abstract String doWordSearch(String var1);

    public String toString() {
        return String.format("%s@%h::dictionary=%s,matchBackwards=%s", this.getClass().getName(), this.hashCode(), this.dictionary, this.matchBackwards);
    }
}

