/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractCharacterRule
implements CharacterRule {
    public static final String ERROR_CODE = "INSUFFICIENT_CHARACTERS";
    protected int numCharacters = 1;

    @Override
    public void setNumberOfCharacters(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacters = n;
    }

    @Override
    public int getNumberOfCharacters() {
        return this.numCharacters;
    }

    protected abstract int getNumberOfCharacterType(Password var1);

    protected abstract String getCharacterType();

    @Override
    public RuleResult validate(PasswordData passwordData) {
        if (this.getNumberOfCharacterType(passwordData.getPassword()) >= this.numCharacters) {
            return new RuleResult(true);
        }
        return new RuleResult(false, new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(passwordData.getPassword())));
    }

    protected Map<String, ?> createRuleResultDetailParameters(Password p) {
        LinkedHashMap<String, Object> m4 = new LinkedHashMap<String, Object>();
        m4.put("minimumRequired", this.numCharacters);
        m4.put("characterType", this.getCharacterType());
        m4.put("validCharacterCount", this.getNumberOfCharacterType(p));
        m4.put("validCharacters", this.getValidCharacters());
        return m4;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacters=%s", this.getClass().getName(), this.hashCode(), this.numCharacters);
    }
}

