/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509;

import edu.vt.middleware.crypt.x509.ExtensionType;
import edu.vt.middleware.crypt.x509.types.AccessDescription;
import edu.vt.middleware.crypt.x509.types.AccessDescriptionList;
import edu.vt.middleware.crypt.x509.types.AccessMethod;
import edu.vt.middleware.crypt.x509.types.AuthorityKeyIdentifier;
import edu.vt.middleware.crypt.x509.types.BasicConstraints;
import edu.vt.middleware.crypt.x509.types.DistributionPoint;
import edu.vt.middleware.crypt.x509.types.DistributionPointList;
import edu.vt.middleware.crypt.x509.types.GeneralName;
import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import edu.vt.middleware.crypt.x509.types.GeneralNameType;
import edu.vt.middleware.crypt.x509.types.KeyIdentifier;
import edu.vt.middleware.crypt.x509.types.KeyPurposeId;
import edu.vt.middleware.crypt.x509.types.KeyPurposeIdList;
import edu.vt.middleware.crypt.x509.types.KeyUsage;
import edu.vt.middleware.crypt.x509.types.NoticeReference;
import edu.vt.middleware.crypt.x509.types.PolicyInformation;
import edu.vt.middleware.crypt.x509.types.PolicyInformationList;
import edu.vt.middleware.crypt.x509.types.PolicyQualifierInfo;
import edu.vt.middleware.crypt.x509.types.ReasonFlags;
import edu.vt.middleware.crypt.x509.types.UserNotice;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralNames;

public final class ExtensionFactory {
    private ExtensionFactory() {
    }

    public static Object createInstance(DEREncodable encodedExtension, ExtensionType type) {
        Object extension = null;
        try {
            switch (type) {
                case AuthorityInformationAccess: {
                    extension = ExtensionFactory.createAccessDescriptionList(encodedExtension);
                    break;
                }
                case AuthorityKeyIdentifier: {
                    extension = ExtensionFactory.createAuthorityKeyIdentifier(encodedExtension);
                    break;
                }
                case BasicConstraints: {
                    extension = ExtensionFactory.createBasicConstraints(encodedExtension);
                    break;
                }
                case CertificatePolicies: {
                    extension = ExtensionFactory.createPolicyInformationList(encodedExtension);
                    break;
                }
                case CRLDistributionPoints: {
                    extension = ExtensionFactory.createDistributionPointList(encodedExtension);
                    break;
                }
                case ExtendedKeyUsage: {
                    extension = ExtensionFactory.createKeyPurposeIdList(encodedExtension);
                    break;
                }
                case IssuerAlternativeName: 
                case SubjectAlternativeName: {
                    extension = ExtensionFactory.createGeneralNameList(encodedExtension);
                    break;
                }
                case KeyUsage: {
                    extension = ExtensionFactory.createKeyUsage(encodedExtension);
                    break;
                }
                case NameConstraints: {
                    break;
                }
                case PolicyConstraints: {
                    break;
                }
                case PolicyMappings: {
                    break;
                }
                case PrivateKeyUsagePeriod: {
                    break;
                }
                case SubjectDirectoryAttributes: {
                    break;
                }
                case SubjectKeyIdentifier: {
                    extension = ExtensionFactory.createKeyIdentifier(encodedExtension);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)type) + " not yet supported.");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create %s from %s", new Object[]{type, encodedExtension.getClass().getSimpleName()}), e);
        }
        return extension;
    }

    public static GeneralNameList createGeneralNameList(DEREncodable enc) {
        ArrayList<GeneralName> nameList = new ArrayList<GeneralName>();
        for (org.bouncycastle.asn1.x509.GeneralName name : GeneralNames.getInstance((Object)enc).getNames()) {
            nameList.add(ExtensionFactory.createGeneralName((DEREncodable)name));
        }
        return new GeneralNameList(nameList);
    }

    public static GeneralName createGeneralName(DEREncodable enc) {
        org.bouncycastle.asn1.x509.GeneralName name = org.bouncycastle.asn1.x509.GeneralName.getInstance((Object)enc);
        return new GeneralName(name.getName().toString(), GeneralNameType.fromTagNumber(name.getTagNo()));
    }

    public static BasicConstraints createBasicConstraints(DEREncodable enc) {
        org.bouncycastle.asn1.x509.BasicConstraints constraints = org.bouncycastle.asn1.x509.BasicConstraints.getInstance((Object)enc);
        if (constraints.getPathLenConstraint() != null) {
            return new BasicConstraints(constraints.isCA(), constraints.getPathLenConstraint().intValue());
        }
        return new BasicConstraints(constraints.isCA());
    }

    public static PolicyInformationList createPolicyInformationList(DEREncodable enc) {
        if (!(enc instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Expected ASN1Sequence but got " + enc);
        }
        ASN1Sequence seq = (ASN1Sequence)enc;
        ArrayList<PolicyInformation> policies = new ArrayList<PolicyInformation>(seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            policies.add(ExtensionFactory.createPolicyInformation(seq.getObjectAt(i)));
        }
        return new PolicyInformationList(policies.toArray(new PolicyInformation[policies.size()]));
    }

    public static PolicyInformation createPolicyInformation(DEREncodable enc) {
        org.bouncycastle.asn1.x509.PolicyInformation info = org.bouncycastle.asn1.x509.PolicyInformation.getInstance((Object)enc);
        ASN1Sequence encodedQualifiers = info.getPolicyQualifiers();
        if (encodedQualifiers != null) {
            int size = encodedQualifiers.size();
            ArrayList<PolicyQualifierInfo> qualifiers = new ArrayList<PolicyQualifierInfo>(size);
            for (int i = 0; i < size; ++i) {
                DEREncodable item = encodedQualifiers.getObjectAt(i);
                qualifiers.add(ExtensionFactory.createPolicyQualifierInfo(item));
            }
            return new PolicyInformation(info.getPolicyIdentifier().toString(), qualifiers.toArray(new PolicyQualifierInfo[size]));
        }
        return new PolicyInformation(info.getPolicyIdentifier().toString());
    }

    public static PolicyQualifierInfo createPolicyQualifierInfo(DEREncodable enc) {
        org.bouncycastle.asn1.x509.PolicyQualifierInfo policyQualifier = org.bouncycastle.asn1.x509.PolicyQualifierInfo.getInstance((Object)enc);
        DEREncodable qualifier = policyQualifier.getQualifier();
        if (qualifier instanceof DERIA5String) {
            return new PolicyQualifierInfo(qualifier.toString());
        }
        return new PolicyQualifierInfo(ExtensionFactory.createUserNotice(qualifier));
    }

    public static UserNotice createUserNotice(DEREncodable enc) {
        org.bouncycastle.asn1.x509.UserNotice notice;
        if (!(enc instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Expected ASN1Sequence but got " + enc);
        }
        ASN1Sequence seq = (ASN1Sequence)enc;
        UserNotice result = null;
        result = seq.size() == 0 ? new UserNotice() : ((notice = new org.bouncycastle.asn1.x509.UserNotice(seq)).getExplicitText() != null ? (notice.getNoticeRef() != null ? new UserNotice(ExtensionFactory.createNoticeReference((DEREncodable)notice.getNoticeRef()), notice.getExplicitText().getString()) : new UserNotice(notice.getExplicitText().getString())) : new UserNotice(ExtensionFactory.createNoticeReference((DEREncodable)notice.getNoticeRef())));
        return result;
    }

    public static NoticeReference createNoticeReference(DEREncodable enc) {
        org.bouncycastle.asn1.x509.NoticeReference notRef = org.bouncycastle.asn1.x509.NoticeReference.getInstance((Object)enc);
        int[] notNums = new int[notRef.getNoticeNumbers().size()];
        for (int i = 0; i < notNums.length; ++i) {
            DERInteger num = (DERInteger)notRef.getNoticeNumbers().getObjectAt(i);
            notNums[i] = num.getValue().intValue();
        }
        return new NoticeReference(notRef.getOrganization().toString(), notNums);
    }

    public static KeyIdentifier createKeyIdentifier(DEREncodable enc) {
        if (!(enc instanceof ASN1OctetString)) {
            throw new IllegalArgumentException("Expected ASN1OctetString but got " + enc);
        }
        ASN1OctetString os = (ASN1OctetString)enc;
        return new KeyIdentifier(os.getOctets());
    }

    public static AuthorityKeyIdentifier createAuthorityKeyIdentifier(DEREncodable enc) {
        org.bouncycastle.asn1.x509.AuthorityKeyIdentifier aki = org.bouncycastle.asn1.x509.AuthorityKeyIdentifier.getInstance((Object)enc);
        KeyIdentifier keyIdentifier = null;
        if (aki.getKeyIdentifier() != null) {
            keyIdentifier = new KeyIdentifier(aki.getKeyIdentifier());
        }
        GeneralNameList issuerNames = null;
        if (aki.getAuthorityCertIssuer() != null) {
            issuerNames = ExtensionFactory.createGeneralNameList((DEREncodable)aki.getAuthorityCertIssuer());
        }
        Integer issuerSerial = null;
        if (aki.getAuthorityCertSerialNumber() != null) {
            issuerSerial = aki.getAuthorityCertSerialNumber().intValue();
        }
        return new AuthorityKeyIdentifier(keyIdentifier, issuerNames, issuerSerial);
    }

    public static KeyUsage createKeyUsage(DEREncodable enc) {
        DERBitString usage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)enc);
        return new KeyUsage(usage.getBytes());
    }

    public static KeyPurposeIdList createKeyPurposeIdList(DEREncodable enc) {
        ExtendedKeyUsage usages = ExtendedKeyUsage.getInstance((Object)enc);
        ArrayList<KeyPurposeId> idList = new ArrayList<KeyPurposeId>();
        for (Object usage : usages.getUsages()) {
            idList.add(KeyPurposeId.getByOid(usage.toString()));
        }
        return new KeyPurposeIdList(idList);
    }

    public static DistributionPointList createDistributionPointList(DEREncodable enc) {
        if (!(enc instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Expected ASN1Sequence but got " + enc);
        }
        ASN1Sequence seq = (ASN1Sequence)enc;
        ArrayList<DistributionPoint> distPoints = new ArrayList<DistributionPoint>();
        for (int i = 0; i < seq.size(); ++i) {
            org.bouncycastle.asn1.x509.DistributionPoint dp = org.bouncycastle.asn1.x509.DistributionPoint.getInstance((Object)seq.getObjectAt(i));
            Object name = null;
            if (dp.getDistributionPoint() != null) {
                name = dp.getDistributionPoint().getType() == 0 ? ExtensionFactory.createGeneralNameList((DEREncodable)dp.getDistributionPoint().getName()) : dp.getDistributionPoint().toString();
            }
            ReasonFlags reasons = null;
            if (dp.getReasons() != null) {
                reasons = new ReasonFlags(dp.getReasons().getBytes());
            }
            GeneralNameList issuer = null;
            if (dp.getCRLIssuer() != null) {
                issuer = ExtensionFactory.createGeneralNameList((DEREncodable)dp.getCRLIssuer());
            }
            if (name instanceof GeneralNameList) {
                distPoints.add(new DistributionPoint((GeneralNameList)name, reasons, issuer));
                continue;
            }
            distPoints.add(new DistributionPoint((String)name, reasons, issuer));
        }
        return new DistributionPointList(distPoints);
    }

    public static AccessDescriptionList createAccessDescriptionList(DEREncodable enc) {
        AuthorityInformationAccess info = AuthorityInformationAccess.getInstance((Object)enc);
        ArrayList<AccessDescription> accessDescList = new ArrayList<AccessDescription>();
        for (org.bouncycastle.asn1.x509.AccessDescription desc : info.getAccessDescriptions()) {
            accessDescList.add(new AccessDescription(AccessMethod.getByOid(desc.getAccessMethod().toString()), ExtensionFactory.createGeneralName((DEREncodable)desc.getAccessLocation())));
        }
        return new AccessDescriptionList(accessDescList);
    }
}

