/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.tasks;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Task;

public abstract class AbstractCryptTask
extends Task {
    protected String propertyName;
    protected String algorithm = "AES";
    protected String mode = "CBC";
    protected String padding = "PKCS5Padding";
    protected String iv;
    protected File privateKey;

    public void setName(String s2) {
        this.propertyName = s2;
    }

    public void setAlgorithm(String s2) {
        this.algorithm = s2;
    }

    public void setMode(String s2) {
        this.mode = s2;
    }

    public void setPadding(String s2) {
        this.padding = s2;
    }

    public void setIv(String s2) {
        this.iv = s2;
    }

    public void setPrivateKey(File f) {
        this.privateKey = f;
    }

    public abstract void execute();

    protected SymmetricAlgorithm createAlgorithm() throws CryptException, IOException {
        SymmetricAlgorithm crypt = SymmetricAlgorithm.newInstance(this.algorithm, this.mode, this.padding);
        if (this.iv != null) {
            crypt.setIV(new HexConverter().toBytes(this.iv));
        }
        crypt.setKey(CryptReader.readSecretKey(this.privateKey, this.algorithm));
        return crypt;
    }
}

