/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.io.CredentialReader;
import edu.vt.middleware.crypt.io.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecretKeyCredentialReader
implements CredentialReader<SecretKey> {
    private final String algorithm;

    public SecretKeyCredentialReader(String cipherAlgorithm) {
        this.algorithm = cipherAlgorithm;
    }

    @Override
    public SecretKey read(File file) throws IOException, CryptException {
        byte[] data = IOHelper.read(new FileInputStream(file).getChannel());
        try {
            return new SecretKeySpec(data, this.algorithm);
        }
        catch (Exception e) {
            throw new CryptException("Invalid key format.", e);
        }
    }

    @Override
    public SecretKey read(InputStream in) throws IOException, CryptException {
        byte[] data = IOHelper.read(in);
        try {
            return new SecretKeySpec(data, this.algorithm);
        }
        catch (Exception e) {
            throw new CryptException("Invalid key format.", e);
        }
    }
}

