/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.utils;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.intenso.confluence.plugins.utils.Page;
import com.intenso.confluence.plugins.utils.PageInfo;
import com.intenso.confluence.plugins.utils.PageResponse;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UsersUtils {
    private final UserAccessor userAccessor;
    private final UserManager userManager;

    public PageResponse<ConfluenceUser> getUsersPaged(Page page, String searchedUserName) {
        List<String> userNames = this.userAccessor.getUserNamesWithConfluenceAccess().stream().filter(userName -> this.filterBySearchedUserName((String)userName, searchedUserName)).collect(Collectors.toList());
        int pageLastIndex = page.getOffset() + page.pageSize;
        List<String> userNamesPage = this.getPagedList(page, userNames, pageLastIndex);
        List users = userNamesPage.stream().map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).collect(Collectors.toList());
        return new PageResponse<ConfluenceUser>(users, PageInfo.from(page, userNames.size(), "page"));
    }

    private List<String> getPagedList(Page page, List<String> userNames, int pageLastIndex) {
        if (userNames.size() < page.getOffset()) {
            page.setPageNumber(1);
            return userNames.subList(0, Math.min(page.pageSize, userNames.size()));
        }
        return userNames.subList(page.getOffset(), Math.min(pageLastIndex, userNames.size()));
    }

    public boolean validUserPassword(String userName, String password) {
        return this.userManager.authenticate(userName, password);
    }

    private boolean filterBySearchedUserName(String userName, String searchedUserName) {
        return StringUtils.isEmpty((CharSequence)searchedUserName) || userName.toLowerCase().contains(searchedUserName.toLowerCase());
    }

    @Generated
    public UsersUtils(UserAccessor userAccessor, UserManager userManager) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
    }
}

