/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.intenso.confluence.plugins.utils.Page;
import lombok.Generated;

@JsonAutoDetect
public class PageInfo {
    int current;
    int pageSize;
    int totalPages;
    int totalElements;
    String paginatorName;

    public static PageInfo from(Page page, int allOptionsFound, String paginatorName) {
        return PageInfo.builder().current(page.getOneBasedPageNumber()).pageSize(page.getPageSize()).totalPages(PageInfo.getTotalPages(page, allOptionsFound)).totalElements(allOptionsFound).paginatorName(paginatorName).build();
    }

    private static int getTotalPages(Page page, int allOptionsFound) {
        return (int)Math.ceil((double)allOptionsFound / (double)page.getPageSize());
    }

    @Generated
    PageInfo(int current, int pageSize, int totalPages, int totalElements, String paginatorName) {
        this.current = current;
        this.pageSize = pageSize;
        this.totalPages = totalPages;
        this.totalElements = totalElements;
        this.paginatorName = paginatorName;
    }

    @Generated
    public static PageInfoBuilder builder() {
        return new PageInfoBuilder();
    }

    @Generated
    public int getCurrent() {
        return this.current;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public int getTotalPages() {
        return this.totalPages;
    }

    @Generated
    public int getTotalElements() {
        return this.totalElements;
    }

    @Generated
    public String getPaginatorName() {
        return this.paginatorName;
    }

    @Generated
    public void setCurrent(int current) {
        this.current = current;
    }

    @Generated
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    @Generated
    public void setTotalElements(int totalElements) {
        this.totalElements = totalElements;
    }

    @Generated
    public void setPaginatorName(String paginatorName) {
        this.paginatorName = paginatorName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        String this$paginatorName = this.getPaginatorName();
        String other$paginatorName = other.getPaginatorName();
        return !(this$paginatorName == null ? other$paginatorName != null : !this$paginatorName.equals(other$paginatorName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getTotalElements();
        String $paginatorName = this.getPaginatorName();
        result = result * 59 + ($paginatorName == null ? 43 : $paginatorName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageInfo(current=" + this.getCurrent() + ", pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", totalElements=" + this.getTotalElements() + ", paginatorName=" + this.getPaginatorName() + ")";
    }

    @Generated
    public static class PageInfoBuilder {
        @Generated
        private int current;
        @Generated
        private int pageSize;
        @Generated
        private int totalPages;
        @Generated
        private int totalElements;
        @Generated
        private String paginatorName;

        @Generated
        PageInfoBuilder() {
        }

        @Generated
        public PageInfoBuilder current(int current) {
            this.current = current;
            return this;
        }

        @Generated
        public PageInfoBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public PageInfoBuilder totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        @Generated
        public PageInfoBuilder totalElements(int totalElements) {
            this.totalElements = totalElements;
            return this;
        }

        @Generated
        public PageInfoBuilder paginatorName(String paginatorName) {
            this.paginatorName = paginatorName;
            return this;
        }

        @Generated
        public PageInfo build() {
            return new PageInfo(this.current, this.pageSize, this.totalPages, this.totalElements, this.paginatorName);
        }

        @Generated
        public String toString() {
            return "PageInfo.PageInfoBuilder(current=" + this.current + ", pageSize=" + this.pageSize + ", totalPages=" + this.totalPages + ", totalElements=" + this.totalElements + ", paginatorName=" + this.paginatorName + ")";
        }
    }
}

