/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.utils;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;

public class LicenseUtils {
    private static final String ADD_ON_NAME = "Enterprise Password Policy";

    public static String checkLicense(PluginLicenseManager licenseManager) {
        if (licenseManager.getLicense().isDefined()) {
            return LicenseUtils.checkLicenseInternal((Option<PluginLicense>)licenseManager.getLicense(), licenseManager);
        }
        return "Unfortunately your current Enterprise Password Policy licence can not be used. For more details, please contact Confluence administrator";
    }

    public static boolean isValid(PluginLicenseManager licenseManager) {
        return licenseManager.getLicense().isDefined() && ((PluginLicense)licenseManager.getLicense().get()).isValid();
    }

    private static String checkLicenseInternal(Option<PluginLicense> license, PluginLicenseManager licenseManager) {
        if (license.isDefined()) {
            if (!((PluginLicense)license.get()).isValid()) {
                switch (((LicenseError)((PluginLicense)license.get()).getError().get()).ordinal()) {
                    case 1: {
                        return "Unfortunately your current Enterprise Password Policy licence can not be used. For more details, please contact Confluence administrator";
                    }
                    case 2: {
                        return "Invalid license: Your Enterprise Password Policy license does not match the " + ((PluginLicense)license.get()).getDescription() + " license on this Confluence installation. Please get a " + ((PluginLicense)license.get()).getDescription() + " license for Enterprise Password Policy and try again.";
                    }
                    case 3: {
                        return "EDITION_MISMATCH";
                    }
                    case 4: {
                        return "Invalid license: Your license for maintenance of Enterprise Password Policy is not valid. Please use the 'Renew' button to renew your Enterprise Password Policy license.";
                    }
                    case 5: {
                        int pluginCount = (Integer)((PluginLicense)license.get()).getEdition().get();
                        return "Invalid license: Your Enterprise Password Policy is only licensed for " + pluginCount + " users. ";
                    }
                }
                return "Invalid license!";
            }
        } else {
            return "Enterprise Password Policy is unlicensed. Please use the 'Buy' button to purchase a new license.";
        }
        return null;
    }
}

