/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.utils;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.intenso.confluence.plugins.action.FormattedGroupPasswordExpirationPolicy;
import com.intenso.confluence.plugins.service.PasswordExpirationService;
import com.intenso.confluence.plugins.utils.Page;
import com.intenso.confluence.plugins.utils.PageInfo;
import com.intenso.confluence.plugins.utils.PageResponse;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GroupsUtils {
    private final PasswordExpirationService passwordExpirationService;

    public PageResponse<FormattedGroupPasswordExpirationPolicy> getGroupPaged(UserAccessor userAccessor, Page page, String searchedGroupName) {
        List<FormattedGroupPasswordExpirationPolicy> groups = userAccessor.getGroupsAsList().stream().filter(group -> this.filterBySearchedUserName(group.getName(), searchedGroupName)).map(this::mapToFormattedGroupPasswordExpirationPolicy).collect(Collectors.toList());
        List<FormattedGroupPasswordExpirationPolicy> groupsPage = this.getPagedList(page, groups, this.getPageLastIndex(page));
        return new PageResponse<FormattedGroupPasswordExpirationPolicy>(groupsPage, PageInfo.from(page, groups.size(), "groupPage"));
    }

    private List<FormattedGroupPasswordExpirationPolicy> getPagedList(Page page, List<FormattedGroupPasswordExpirationPolicy> groups, int pageLastIndex) {
        if (groups.size() < page.getOffset()) {
            page.setPageNumber(1);
            return groups.subList(0, Math.min(page.pageSize, groups.size()));
        }
        return groups.subList(page.getOffset(), Math.min(pageLastIndex, groups.size()));
    }

    private FormattedGroupPasswordExpirationPolicy mapToFormattedGroupPasswordExpirationPolicy(Group group) {
        boolean isExpirationEnabled = this.passwordExpirationService.isExpirationPolicyEnabled(group);
        return new FormattedGroupPasswordExpirationPolicy(group, isExpirationEnabled);
    }

    private int getPageLastIndex(Page page) {
        return page.getOffset() + page.pageSize;
    }

    private boolean filterBySearchedUserName(String groupName, String searchedGroupName) {
        return StringUtils.isEmpty((CharSequence)searchedGroupName) || groupName.toLowerCase().contains(searchedGroupName.toLowerCase());
    }

    @Generated
    public GroupsUtils(PasswordExpirationService passwordExpirationService) {
        this.passwordExpirationService = passwordExpirationService;
    }
}

