/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.upgrade;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UserPropertiesMigrationUpgradeTask
implements PluginUpgradeTask {
    private final UserAccessor userAccessor;

    public String getShortDescription() {
        return "Migrates all the users plugin properties from PropertySet to UserPreferences";
    }

    public int getBuildNumber() {
        return 1000;
    }

    public String getPluginKey() {
        return "com.intenso.confluence.plugins.confluence-password-policy";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.userAccessor.getUserNamesWithConfluenceAccess().stream().map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).forEach(this::migrateData);
        return null;
    }

    private void migrateData(ConfluenceUser user) {
        PropertySet propertySet = this.userAccessor.getPropertySet(user);
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        this.migrateDate("last_password_changed_date_property", propertySet, userPreferences);
        this.migrateDate("last_password_expiration_notification_send_date", propertySet, userPreferences);
        this.migrateDate("last_password_expired_notification_send_date", propertySet, userPreferences);
        this.migrateDate("com.intenso.jira.plugins.passpolicy:date_of_user_locking_user_account", propertySet, userPreferences);
        this.migrateBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked", propertySet, userPreferences);
        this.migrateBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled", propertySet, userPreferences);
        this.migrateBoolean("com.intenso.jira.plugins.passpolicy:user_account_unlocked_manually", propertySet, userPreferences);
    }

    private void migrateDate(String key, PropertySet propertySet, UserPreferences preferences) {
        Optional.ofNullable(propertySet.getDate(key)).ifPresent(date -> preferences.setLong(key, date.getTime()));
    }

    private void migrateBoolean(String key, PropertySet propertySet, UserPreferences preferences) {
        boolean current = propertySet.getBoolean(key);
        preferences.setBoolean(key, current);
    }

    @Generated
    public UserPropertiesMigrationUpgradeTask(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

