/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.upgrade;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UserExpirationPasswordPolicySetter
implements PluginUpgradeTask {
    private final UserAccessor userAccessor;

    public int getBuildNumber() {
        return 100;
    }

    public String getShortDescription() {
        return "Set all users 'expiring password policy enable' property to true";
    }

    public Collection<Message> doUpgrade() throws Exception {
        for (String username : this.userAccessor.getUserNamesWithConfluenceAccess()) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            UserPreferences properties = this.userAccessor.getUserPreferences(user);
            properties.setBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled", true);
        }
        return null;
    }

    public String getPluginKey() {
        return "com.intenso.confluence.plugins.confluence-password-policy";
    }

    @Generated
    public UserExpirationPasswordPolicySetter(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

