/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.upgrade;

import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.intenso.confluence.plugins.ao.PassPolicyProp;
import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslationHelper;
import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslationHolder;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.upgrade.util.LocaleUtil;
import java.util.Collection;
import org.springframework.util.StringUtils;

public class TranslationUpragdeTask
implements PluginUpgradeTask {
    private final PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private final LocaleManager localeManager;
    private final LanguageManager languageManager;

    public TranslationUpragdeTask(LanguageManager languageManager, PasswordPolicyPropertiesService passwordPolicyPropertiesService, LocaleManager localeManager) {
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
        this.localeManager = localeManager;
        this.languageManager = languageManager;
    }

    public int getBuildNumber() {
        return 650;
    }

    public String getShortDescription() {
        return "Updates password configuration";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.convertPropertyTypeToLangTranslationHolder("passwordExpirationNotifierEmailSubject", "passwordExpirationNotifierEmailBody", "passwordExpirationNotifierEmailFromName", "passwordExpiredNotifierEmailSubject", "passwordExpiredNotifierEmailBody", "passwordExpiredNotifierEmailFromName");
        return null;
    }

    private void convertPropertyTypeToLangTranslationHolder(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            try {
                String msgContent = null;
                PassPolicyProp prop = this.passwordPolicyPropertiesService.getProperty(propertyName);
                if (prop != null) {
                    msgContent = prop.getValue();
                    if (!StringUtils.hasLength((String)msgContent) || LangTranslationHelper.isAJSON(msgContent)) {
                        msgContent = this.getDefault(propertyName);
                    }
                } else {
                    msgContent = this.getDefault(propertyName);
                }
                String msgContentFinal = msgContent;
                LangTranslationHolder.LangTranslationHolderBuilder builder = new LangTranslationHolder.LangTranslationHolderBuilder();
                builder.defaultLanguageKey(LocaleUtil.buildKey(this.localeManager.getSiteDefaultLocale()));
                for (Language language : this.languageManager.getLanguages()) {
                    builder.addLanguageTransalation(LocaleUtil.buildKey(language.getLocale()), language.getLocale().getDisplayLanguage(), msgContentFinal);
                    this.passwordPolicyPropertiesService.setPropertyValue(propertyName, LangTranslationHelper.toString(builder.build()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDefault(String propertyName) {
        if (propertyName.equals("passwordExpirationNotifierEmailSubject")) {
            return "Password Expiration Notification";
        }
        if (propertyName.equals("passwordExpiredNotifierEmailSubject")) {
            return "Password Expiration Notification";
        }
        if (propertyName.equals("passwordExpirationNotifierEmailBody")) {
            return "Hi $userFullName,<br /> \n<br />Your password for account <b>$userName</b> expires at $expirationDateTime\nPlease change your password <a href='$changePasswordUrl'>here</a> as soon as possible to prevent further logon problems.\n<br />\n<br />\nThank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence";
        }
        if (propertyName.equals("passwordExpiredNotifierEmailBody")) {
            return "Hi $userFullName,<br />\n<br />\nYour password for account <b>$userName</b> is expired. Please change your password <a href=\"$changePasswordUrl\">here</a>\n<br />\n<br />Thank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence";
        }
        if (propertyName.equals("passwordExpirationNotifierEmailFromName")) {
            return "Confluence Password Expiration Notifier";
        }
        if (propertyName.equals("passwordExpiredNotifierEmailFromName")) {
            return "Confluence Password Expiration Notifier";
        }
        return null;
    }

    public String getPluginKey() {
        return "com.intenso.confluence.plugins.confluence-password-policy";
    }
}

