/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.upgrade;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class MoveProperitiesToAO
implements PluginUpgradeTask {
    PluginConfigurationService pluginConfigurationService;
    PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private final PluginSettingsFactory pluginSettingsFactory;
    public static final String SETTINGS_KEY = "com.intenso.jira.plugins.passpolicy:password-policy";
    public static final String FIELD_ENABLED = "enabled";
    public static final String FIELD_MAXIMUM_PASSWORD_AGE = "maximumPasswordAge";
    private static final String FIELD_PASSWORDS_REMEBMERED_IN_HISTORY = "passwordsRemebmeredInHistory";
    private static final String FIELD_MIN_PASSWORD_LENGTH = "minPasswordLength";
    private static final String FIELD_MAX_PASSWORD_LENGTH = "maxPasswordLength";
    private static final String FIELD_DIGIT_CHARACTER_RULE = "digitCharacterRule";
    private static final String FIELD_NON_ALPHANUMERIC_CHARACTER_RULE = "nonAlphanumericCharacterRule";
    private static final String FIELD_UPPERCASE_CHARACTER_RULE = "uppercaseCharacterRule";
    private static final String FIELD_LOWERCASE_CHARACTER_RULE = "lowercaseCharacterRule";
    private static final String FIELD_PASSWORDS_LIKE_NAME_ALLOWED = "passwordsLikeNameAllowed";
    private static final String FIELD_NUMBER_OF_CHARACTERISTICS = "numberOfCharacteristics";
    public static final String FIELD_LAST_CHANGE_TIME = "lastChangeTime";
    public static final String FIELD_ADMIN_CAN_SKIP_PASSWORD_CHANGE = "adminCanSkipPasswordChange";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_ENABLED = "passwordExpirationNotifierEnabled";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION = "passwordExpirationNotifierDuration";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT = "passwordExpirationNotifierEmailSubject";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY = "passwordExpirationNotifierEmailBody";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME = "passwordExpirationNotifierEmailFromName";
    public static final String FIELD_LAST_PASSWORD_EXPIRATION_NOTIFIER_EXECUTION = "lastPasswordExpirationNotifierExecution";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT = "passwordExpiredNotifierEmailSubject";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY = "passwordExpiredNotifierEmailBody";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_FROM_NAME = "passwordExpiredNotifierEmailFromName";
    public static final String FIELD_USER_ACCOUNT_LOCKING_ENABLED = "userAccountLockingEnabled";
    public static final String FIELD_USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED = "userAccountLockingAfterPasswordExpirationEnabled";
    public static final String FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED = "userAccountLockingAfterFailedLoginsEnabled";
    public static final String FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER = "numberOfFailedAttemptsToLockUser";
    public static final String FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT = "daysAfterPasswordExpirationToLockUserAccount";
    public static final String FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT = "userAccountLockedPageConent";

    public MoveProperitiesToAO(PluginSettingsFactory pluginSettingsFactory, PluginConfigurationService pluginConfigurationService, PasswordPolicyPropertiesService passwordPolicyPropertiesService) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
    }

    public int getBuildNumber() {
        return 200;
    }

    public String getShortDescription() {
        return "";
    }

    public Collection<Message> doUpgrade() throws Exception {
        try {
            PluginConfiguration configuration = this.loadOldConfiguration();
            if (configuration != null) {
                this.pluginConfigurationService.saveConfiguration(configuration);
            }
        }
        catch (Exception ex) {
            this.pluginConfigurationService.setInitialValues();
        }
        return null;
    }

    public PluginConfiguration loadOldConfiguration() {
        PluginSettings pluginSettings = this.getPluginSettings();
        PluginConfiguration configuration = new PluginConfiguration();
        configuration.setEnabled(Boolean.parseBoolean((String)pluginSettings.get(FIELD_ENABLED)));
        if (pluginSettings.get(FIELD_MAXIMUM_PASSWORD_AGE) != null) {
            configuration.setMaximumPasswordAge(Integer.parseInt((String)pluginSettings.get(FIELD_MAXIMUM_PASSWORD_AGE)));
        } else {
            configuration.setMaximumPasswordAge(0);
        }
        configuration.setPasswordsRemebmeredInHistory(Integer.parseInt((String)pluginSettings.get(FIELD_PASSWORDS_REMEBMERED_IN_HISTORY)));
        configuration.setMinPasswordLength(Integer.parseInt((String)pluginSettings.get(FIELD_MIN_PASSWORD_LENGTH)));
        configuration.setMaxPasswordLength(Integer.parseInt((String)pluginSettings.get(FIELD_MAX_PASSWORD_LENGTH)));
        configuration.setDigitCharacterRule(Integer.parseInt((String)pluginSettings.get(FIELD_DIGIT_CHARACTER_RULE)));
        configuration.setNonAlphanumericCharacterRule(Integer.parseInt((String)pluginSettings.get(FIELD_NON_ALPHANUMERIC_CHARACTER_RULE)));
        configuration.setUppercaseCharacterRule(Integer.parseInt((String)pluginSettings.get(FIELD_UPPERCASE_CHARACTER_RULE)));
        configuration.setLowercaseCharacterRule(Integer.parseInt((String)pluginSettings.get(FIELD_LOWERCASE_CHARACTER_RULE)));
        configuration.setNumberOfCharacteristics(Integer.parseInt((String)pluginSettings.get(FIELD_NUMBER_OF_CHARACTERISTICS)));
        configuration.setLastChangeTime(Long.parseLong((String)pluginSettings.get(FIELD_LAST_CHANGE_TIME)));
        configuration.setAdminCanSkipPasswordChange(Boolean.parseBoolean((String)pluginSettings.get(FIELD_ADMIN_CAN_SKIP_PASSWORD_CHANGE)));
        configuration.setPasswordExpirationNotifierEnabled(Boolean.parseBoolean((String)pluginSettings.get(FIELD_PASSWORD_EXPIRATION_NOTIFIER_ENABLED)));
        if ((String)pluginSettings.get(FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION) != null) {
            configuration.setPasswordExpirationNotifierDuration(Integer.parseInt((String)pluginSettings.get(FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION)));
        }
        configuration.setUserAccountLockingEnabled(Boolean.parseBoolean((String)pluginSettings.get(FIELD_USER_ACCOUNT_LOCKING_ENABLED)));
        configuration.setUserAccountLockingAfterFailedLoginsEnabled(Boolean.parseBoolean((String)pluginSettings.get(FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED)));
        configuration.setNumberOfFailedAttemptsToLockUser(Integer.parseInt((String)pluginSettings.get(FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER)));
        configuration.setUserAccountLockingAfterPasswordExpirationEnabled(Boolean.parseBoolean((String)pluginSettings.get(FIELD_USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED)));
        if (configuration.getUserAccountLockingAfterPasswordExpirationEnabled().booleanValue()) {
            configuration.setDaysAfterPasswordExpirationToLockUserAccount(Integer.parseInt((String)pluginSettings.get(FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT)));
        }
        configuration.setUserAccountLockedPageConent((String)pluginSettings.get(FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT));
        configuration.setPasswordsLikeNameAllowed(Boolean.parseBoolean((String)pluginSettings.get(FIELD_PASSWORDS_LIKE_NAME_ALLOWED)));
        return configuration;
    }

    public PluginSettings getPluginSettings() {
        return this.pluginSettingsFactory.createSettingsForKey(SETTINGS_KEY);
    }

    public String getPluginKey() {
        return "com.intenso.confluence.plugins.confluence-password-policy";
    }
}

