/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.upgrade;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class LockingSettingsSetter
implements PluginUpgradeTask {
    private PluginConfigurationService pluginConfigurationService;
    private PasswordPolicyPropertiesService passwordPolicyPropertiesService;

    public LockingSettingsSetter(PluginConfigurationService pluginConfigurationService, PasswordPolicyPropertiesService passwordPolicyPropertiesService) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
    }

    public int getBuildNumber() {
        return 110;
    }

    public String getShortDescription() {
        return "Copy 'userAccountLockingEnabled' plugin settings value to 'userAccountLockingAfterPasswordExpirationEnabled' plugin settings value";
    }

    public Collection<Message> doUpgrade() throws Exception {
        String userAccountLockingEnabled = this.passwordPolicyPropertiesService.getPropertyValue("userAccountLockingEnabled");
        this.passwordPolicyPropertiesService.setPropertyValue("userAccountLockingAfterPasswordExpirationEnabled", userAccountLockingEnabled);
        return null;
    }

    public String getPluginKey() {
        return "com.intenso.confluence.plugins.confluence-password-policy";
    }
}

