/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.google.common.base.Preconditions;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import jakarta.annotation.Nonnull;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UserDirectoryServiceImpl
implements UserDirectoryService {
    private final CrowdService crowdService;
    private final CrowdDirectoryService directoryService;

    @Override
    public boolean isUserInInternalDirectory(com.atlassian.user.User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.findDirectoryFor(this.crowdService.getUser(user.getName()));
        return directory != null && directory.getType() == DirectoryType.INTERNAL;
    }

    @Override
    public boolean isExternalDefined() {
        return this.directoryService.findAllDirectories().stream().anyMatch(directory -> !this.isInternalDirectory((Directory)directory));
    }

    private boolean isInternalDirectory(Directory directory) {
        return directory.getType().equals((Object)DirectoryType.INTERNAL);
    }

    private Directory findDirectoryFor(@Nonnull User user) {
        return this.directoryService.findDirectoryById(Preconditions.checkNotNull(user, "user").getDirectoryId());
    }

    @Generated
    public UserDirectoryServiceImpl(CrowdService crowdService, CrowdDirectoryService directoryService) {
        this.crowdService = crowdService;
        this.directoryService = directoryService;
    }
}

