/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.intenso.confluence.plugins.action.FormattedGroupPasswordExpirationPolicy;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslationHelper;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.utils.GroupsUtils;
import com.intenso.confluence.plugins.utils.LicenseUtils;
import com.intenso.confluence.plugins.utils.Page;
import com.intenso.confluence.plugins.utils.PageResponse;
import com.intenso.confluence.plugins.utils.UsersUtils;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
public class PluginConfigurationServiceImpl
implements PluginConfigurationService {
    public static final String SETTINGS_KEY = "com.intenso.jira.plugins.passpolicy:password-policy";
    public static final String FIELD_ENABLED = "enabled";
    public static final String FIELD_ENABLED_EXPIRING_POLICY_BY_DEFAULT = "enabledExpiringPolicyByDefault";
    public static final String FIELD_MAXIMUM_PASSWORD_AGE = "maximumPasswordAge";
    private static final String FIELD_PASSWORDS_REMEBMERED_IN_HISTORY = "passwordsRemebmeredInHistory";
    private static final String FIELD_MIN_PASSWORD_LENGTH = "minPasswordLength";
    private static final String FIELD_MAX_PASSWORD_LENGTH = "maxPasswordLength";
    private static final String FIELD_DIGIT_CHARACTER_RULE = "digitCharacterRule";
    private static final String FIELD_NON_ALPHANUMERIC_CHARACTER_RULE = "nonAlphanumericCharacterRule";
    private static final String FIELD_UPPERCASE_CHARACTER_RULE = "uppercaseCharacterRule";
    private static final String FIELD_LOWERCASE_CHARACTER_RULE = "lowercaseCharacterRule";
    private static final String FIELD_PASSWORDS_LIKE_NAME_ALLOWED = "passwordsLikeNameAllowed";
    private static final String FIELD_NUMBER_OF_CHARACTERISTICS = "numberOfCharacteristics";
    public static final String FIELD_LAST_CHANGE_TIME = "lastChangeTime";
    public static final String FIELD_ADMIN_CAN_SKIP_PASSWORD_CHANGE = "adminCanSkipPasswordChange";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_ENABLED = "passwordExpirationNotifierEnabled";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION = "passwordExpirationNotifierDuration";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT = "passwordExpirationNotifierEmailSubject";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY = "passwordExpirationNotifierEmailBody";
    public static final String FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME = "passwordExpirationNotifierEmailFromName";
    public static final String FIELD_LAST_PASSWORD_EXPIRATION_NOTIFIER_EXECUTION = "lastPasswordExpirationNotifierExecution";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT = "passwordExpiredNotifierEmailSubject";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY = "passwordExpiredNotifierEmailBody";
    public static final String FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_FROM_NAME = "passwordExpiredNotifierEmailFromName";
    public static final String FIELD_USER_ACCOUNT_LOCKING_ENABLED = "userAccountLockingEnabled";
    public static final String FIELD_USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED = "userAccountLockingAfterPasswordExpirationEnabled";
    public static final String FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED = "userAccountLockingAfterFailedLoginsEnabled";
    public static final String FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER = "numberOfFailedAttemptsToLockUser";
    public static final String FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT = "daysAfterPasswordExpirationToLockUserAccount";
    public static final String FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT = "userAccountLockedPageConent";
    private boolean pluginEnabled;
    private boolean userAccountLockingEnabled;
    private long lastChangeTime;
    private int maximumPasswordAge;
    private final PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private final PluginLicenseManager licenseManager;
    private final UsersUtils usersUtils;
    private final GroupsUtils groupsUtils;

    public PluginConfigurationServiceImpl(PasswordPolicyPropertiesService passwordPolicyPropertiesService, PluginLicenseManager licenseManager, UsersUtils usersUtils, GroupsUtils groupsUtils) {
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
        this.licenseManager = licenseManager;
        this.usersUtils = usersUtils;
        this.groupsUtils = groupsUtils;
    }

    @Override
    public void saveConfiguration(PluginConfiguration configuration) {
        this.lastChangeTime = new Date().getTime();
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_ENABLED, configuration.getEnabled().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_ENABLED_EXPIRING_POLICY_BY_DEFAULT, configuration.getEnabledExpiringPolicyByDefault().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_MAXIMUM_PASSWORD_AGE, configuration.getMaximumPasswordAge().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_PASSWORDS_REMEBMERED_IN_HISTORY, configuration.getPasswordsRemebmeredInHistory().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_MIN_PASSWORD_LENGTH, configuration.getMinPasswordLength().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_MAX_PASSWORD_LENGTH, configuration.getMaxPasswordLength().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_DIGIT_CHARACTER_RULE, configuration.getDigitCharacterRule().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_NON_ALPHANUMERIC_CHARACTER_RULE, configuration.getNonAlphanumericCharacterRule().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_UPPERCASE_CHARACTER_RULE, configuration.getUppercaseCharacterRule().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_LOWERCASE_CHARACTER_RULE, configuration.getLowercaseCharacterRule().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_PASSWORDS_LIKE_NAME_ALLOWED, configuration.getPasswordsLikeNameAllowed().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_NUMBER_OF_CHARACTERISTICS, configuration.getNumberOfCharacteristics().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_LAST_CHANGE_TIME, String.valueOf(this.lastChangeTime));
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_ADMIN_CAN_SKIP_PASSWORD_CHANGE, configuration.getAdminCanSkipPasswordChange().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_PASSWORD_EXPIRATION_NOTIFIER_ENABLED, configuration.getPasswordExpirationNotifierEnabled().toString());
        if (configuration.getPasswordExpirationNotifierEnabled().booleanValue()) {
            this.passwordPolicyPropertiesService.setPropertyValue(FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION, configuration.getPasswordExpirationNotifierDuration().toString());
        }
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_USER_ACCOUNT_LOCKING_ENABLED, configuration.getUserAccountLockingEnabled().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED, configuration.getUserAccountLockingAfterPasswordExpirationEnabled().toString());
        if (configuration.getUserAccountLockingAfterPasswordExpirationEnabled().booleanValue()) {
            this.passwordPolicyPropertiesService.setPropertyValue(FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT, configuration.getDaysAfterPasswordExpirationToLockUserAccount().toString());
        }
        if (configuration.getUserAccountLockingEnabled().booleanValue()) {
            this.passwordPolicyPropertiesService.setPropertyValue(FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT, configuration.getUserAccountLockedPageConent());
        }
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED, configuration.getUserAccountLockingAfterFailedLoginsEnabled().toString());
        this.passwordPolicyPropertiesService.setPropertyValue(FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER, configuration.getNumberOfFailedAttemptsToLockUser().toString());
        this.pluginEnabled = configuration.getEnabled();
        this.userAccountLockingEnabled = configuration.getUserAccountLockingEnabled();
        this.maximumPasswordAge = configuration.getMaximumPasswordAge();
    }

    @Override
    public PluginConfiguration getConfiguration() {
        PluginConfiguration configuration = new PluginConfiguration();
        this.setInitialValues();
        this.setProperty(propValue -> configuration.setEnabled(Boolean.parseBoolean(propValue)), FIELD_ENABLED);
        this.setProperty(propValue -> configuration.setEnabledExpiringPolicyByDefault(Boolean.parseBoolean(propValue)), FIELD_ENABLED_EXPIRING_POLICY_BY_DEFAULT);
        this.setProperty(propValue -> configuration.setMaximumPasswordAge(Integer.parseInt(propValue)), FIELD_MAXIMUM_PASSWORD_AGE);
        this.setProperty(propValue -> configuration.setPasswordsRemebmeredInHistory(Integer.parseInt(propValue)), FIELD_PASSWORDS_REMEBMERED_IN_HISTORY, "0");
        this.setProperty(propValue -> configuration.setMinPasswordLength(Integer.parseInt(propValue)), FIELD_MIN_PASSWORD_LENGTH);
        this.setProperty(propValue -> configuration.setMaxPasswordLength(Integer.parseInt(propValue)), FIELD_MAX_PASSWORD_LENGTH);
        this.setProperty(propValue -> configuration.setDigitCharacterRule(Integer.parseInt(propValue)), FIELD_DIGIT_CHARACTER_RULE);
        this.setProperty(propValue -> configuration.setNonAlphanumericCharacterRule(Integer.parseInt(propValue)), FIELD_NON_ALPHANUMERIC_CHARACTER_RULE);
        this.setProperty(propValue -> configuration.setUppercaseCharacterRule(Integer.parseInt(propValue)), FIELD_UPPERCASE_CHARACTER_RULE);
        this.setProperty(propValue -> configuration.setLowercaseCharacterRule(Integer.parseInt(propValue)), FIELD_LOWERCASE_CHARACTER_RULE);
        this.setProperty(propValue -> configuration.setNumberOfCharacteristics(Integer.parseInt(propValue)), FIELD_NUMBER_OF_CHARACTERISTICS);
        this.setProperty(propValue -> configuration.setLastChangeTime(Long.parseLong(propValue)), FIELD_LAST_CHANGE_TIME);
        this.setProperty(propValue -> configuration.setAdminCanSkipPasswordChange(Boolean.parseBoolean(propValue)), FIELD_ADMIN_CAN_SKIP_PASSWORD_CHANGE);
        this.setProperty(propValue -> configuration.setPasswordExpirationNotifierEnabled(Boolean.parseBoolean(propValue)), FIELD_PASSWORD_EXPIRATION_NOTIFIER_ENABLED);
        this.setProperty(propValue -> configuration.setPasswordExpirationNotifierDuration(Integer.parseInt(propValue)), FIELD_PASSWORD_EXPIRATION_NOTIFIER_DURATION);
        this.setProperty(propValue -> configuration.getPasswordExpirationNotifierEmailTemplate().setSubject(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT);
        this.setProperty(propValue -> configuration.getPasswordExpirationNotifierEmailTemplate().setBody(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY);
        this.setProperty(propValue -> configuration.getPasswordExpirationNotifierEmailTemplate().setFromName(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME);
        this.setProperty(propValue -> configuration.getPasswordExpiredNotifierEmailTemplate().setSubject(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT);
        this.setProperty(propValue -> configuration.getPasswordExpiredNotifierEmailTemplate().setBody(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY);
        this.setProperty(propValue -> configuration.getPasswordExpiredNotifierEmailTemplate().setFromName(LangTranslationHelper.getObject(propValue)), FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_FROM_NAME);
        this.setProperty(propValue -> configuration.setUserAccountLockingEnabled(Boolean.parseBoolean(propValue)), FIELD_USER_ACCOUNT_LOCKING_ENABLED);
        this.setProperty(propValue -> configuration.setUserAccountLockingAfterFailedLoginsEnabled(Boolean.parseBoolean(propValue)), FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED);
        this.setProperty(propValue -> configuration.setNumberOfFailedAttemptsToLockUser(Integer.parseInt(propValue)), FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER);
        this.setProperty(propValue -> configuration.setUserAccountLockingAfterPasswordExpirationEnabled(Boolean.parseBoolean(propValue)), FIELD_USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED);
        this.setProperty(propValue -> configuration.setDaysAfterPasswordExpirationToLockUserAccount(Integer.parseInt(propValue)), FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT);
        this.setProperty(configuration::setUserAccountLockedPageConent, FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT);
        this.setProperty(propValue -> configuration.setPasswordsLikeNameAllowed(Boolean.parseBoolean(propValue)), FIELD_PASSWORDS_LIKE_NAME_ALLOWED);
        return configuration;
    }

    private void setProperty(Consumer<String> consumer, String propertyKey) {
        String propertyValue = this.passwordPolicyPropertiesService.getPropertyValue(propertyKey);
        if (Objects.nonNull(propertyValue)) {
            consumer.accept(propertyValue);
        }
    }

    private void setProperty(Consumer<String> consumer, String propertyKey, String defaultValue) {
        String propertyValue = this.passwordPolicyPropertiesService.getPropertyValue(propertyKey);
        if (Objects.nonNull(propertyValue)) {
            consumer.accept(propertyValue);
        } else {
            consumer.accept(defaultValue);
        }
    }

    @Override
    public void setInitialValues() {
        String userAccountLockingEnabledProperty = this.passwordPolicyPropertiesService.getPropertyValue(FIELD_USER_ACCOUNT_LOCKING_ENABLED);
        this.userAccountLockingEnabled = Boolean.parseBoolean(userAccountLockingEnabledProperty);
        String maximumPasswordAgeProperty = this.passwordPolicyPropertiesService.getPropertyValue(FIELD_MAXIMUM_PASSWORD_AGE);
        this.maximumPasswordAge = maximumPasswordAgeProperty != null ? Integer.parseInt(maximumPasswordAgeProperty) : 0;
        String lastChangeTimeValue = this.passwordPolicyPropertiesService.getPropertyValue(FIELD_LAST_CHANGE_TIME);
        if (lastChangeTimeValue != null) {
            try {
                this.lastChangeTime = Long.parseLong(lastChangeTimeValue);
            }
            catch (NumberFormatException e) {
                this.lastChangeTime = 0L;
            }
        }
        this.initProperty(FIELD_NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER, "3");
        this.initProperty(FIELD_USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED, "false");
        this.initProperty(FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT, "Password Expiration Notification");
        this.initProperty(FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT, "Password Expiration Notification");
        this.initProperty(FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY, "Hi $userFullName,<br /> \n<br />Your password for account <b>$userName</b> expires at $expirationDateTime\nPlease change your password <a href='$changePasswordUrl'>here</a> as soon as possible to prevent further logon problems.\n<br />\n<br />\nThank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence");
        this.initProperty(FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY, "Hi $userFullName,<br />\n<br />\nYour password for account <b>$userName</b> is expired. Please change your password <a href=\"$changePasswordUrl\">here</a>\n<br />\n<br />Thank you!\n<br />\n<br />\n------------------------------------------------------------------------<br />\nThis is an automatically generated message from Confluence");
        this.initProperty(FIELD_USER_ACCOUNT_LOCKED_PAGE_CONENT, "<h3>Your account has been locked</h3>\n<div>To unlock your account contact your Confluence Administrator</div>");
        this.initProperty(FIELD_DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT, "3");
        this.initProperty(FIELD_PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME, "Confluence Password Expiration Notifier");
        this.initProperty(FIELD_PASSWORD_EXPIRED_NOTIFIER_EMAIL_FROM_NAME, "Confluence Password Expiration Notifier");
        this.initProperty(FIELD_PASSWORDS_LIKE_NAME_ALLOWED, "true");
    }

    private void initProperty(String propertyKey, String initValue) {
        String propertyValue = this.passwordPolicyPropertiesService.getPropertyValue(propertyKey);
        if (propertyValue == null) {
            this.passwordPolicyPropertiesService.setPropertyValue(propertyKey, initValue);
        }
    }

    @Override
    public boolean pluginEnabled() {
        String property = this.passwordPolicyPropertiesService.getPropertyValue(FIELD_ENABLED);
        return Boolean.parseBoolean(property);
    }

    @Override
    public long getLastConfigChangeTime() {
        return this.lastChangeTime;
    }

    @Override
    public boolean isLicenseValidAndPluginEnabled() {
        return this.pluginEnabled() && LicenseUtils.isValid(this.licenseManager);
    }

    @Override
    public void updateLastPasswordExpirationNotifierExecution(Date date) {
        if (date != null) {
            this.passwordPolicyPropertiesService.setPropertyValue(FIELD_LAST_PASSWORD_EXPIRATION_NOTIFIER_EXECUTION, String.valueOf(date.getTime()));
        }
    }

    @Override
    public Date getLastPasswordExpirationNotifierExecution() {
        try {
            String value = this.passwordPolicyPropertiesService.getPropertyValue(FIELD_LAST_PASSWORD_EXPIRATION_NOTIFIER_EXECUTION);
            if (value != null) {
                long longValue = Long.parseLong(value);
                return new Date(longValue);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public PageResponse<ConfluenceUser> getWritableActiveUsersPage(Page page, String searchedUserName) {
        return this.usersUtils.getUsersPaged(page, searchedUserName);
    }

    @Override
    public PageResponse<FormattedGroupPasswordExpirationPolicy> getGroupsPage(UserAccessor userAccessor, Page page, String searchedGroupName) {
        return this.groupsUtils.getGroupPaged(userAccessor, page, searchedGroupName);
    }

    @Override
    public boolean isUserAccountLockingEnabled() {
        PluginConfiguration pc = this.getConfiguration();
        return pc.getUserAccountLockingEnabled() != false && pc.getMaximumPasswordAge() > 0;
    }
}

