/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.ao.UserPasswordHistoryDAO;
import com.intenso.confluence.plugins.passpolicy.LazyUserPasswordPolicy;
import com.intenso.confluence.plugins.passpolicy.PasswordMessageResolver;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.rules.HistoryRule;
import com.intenso.confluence.plugins.rules.PolicyRule;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import com.intenso.confluence.plugins.utils.UserPreferencesUtils;
import com.intenso.confluence.plugins.utils.UsersUtils;
import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.password.CharacterCharacteristicsRule;
import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.DictionaryRule;
import edu.vt.middleware.password.DigitCharacterRule;
import edu.vt.middleware.password.LengthRule;
import edu.vt.middleware.password.LowercaseCharacterRule;
import edu.vt.middleware.password.NonAlphanumericCharacterRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.PasswordValidator;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.UppercaseCharacterRule;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.springframework.stereotype.Component;

@Component
public class PasswordPolicyServiceImpl
implements PasswordPolicyService {
    private final UserPasswordHistoryDAO userPasswordHistoryDAO;
    private final UserManager userManager;
    private PasswordMessageResolver messageResolver;
    private final PluginConfigurationService pluginConfigurationService;
    private final HttpContext httpContext;
    private final LocaleManager localeManager;
    private final UserAccessor userAccessor;
    private final PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private final UsersUtils usersUtils;
    private final UserDirectoryService userDirectoryService;

    public PasswordPolicyServiceImpl(UserPasswordHistoryDAO userPasswordHistoryDAO, PluginConfigurationService pluginConfigurationService, UserManager userManager, HttpContext httpContext, LocaleManager localeManager, UserAccessor userAccessor, PasswordPolicyPropertiesService passwordPolicyPropertiesService, UsersUtils usersUtils, UserDirectoryService userDirectoryService) {
        this.userPasswordHistoryDAO = userPasswordHistoryDAO;
        this.userManager = userManager;
        this.httpContext = httpContext;
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
        this.userDirectoryService = userDirectoryService;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("validationMessages.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.messageResolver = new PasswordMessageResolver(props);
        this.pluginConfigurationService = pluginConfigurationService;
        this.localeManager = localeManager;
        this.userAccessor = userAccessor;
        this.usersUtils = usersUtils;
    }

    @Override
    public boolean hasUserPasswordExpired(ConfluenceUser user) {
        Hours passwordAge = this.getUserPasswordAgeInHours(user);
        if (passwordAge != null) {
            int hoursInDay = 24;
            Integer maximumPasswordAge = this.getMaximumPasswordAge();
            if (maximumPasswordAge == null) {
                return false;
            }
            Integer maximumPasswordAgeInHours = maximumPasswordAge * hoursInDay;
            return passwordAge.getHours() > maximumPasswordAgeInHours;
        }
        return true;
    }

    @Override
    public Hours getUserPasswordAgeInHours(ConfluenceUser user) {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        UserPreferences userPreferences = userAccessor.getUserPreferences(user);
        Date lastPasswordChangeDate = UserPreferencesUtils.getDate("last_password_changed_date_property", userPreferences);
        if (lastPasswordChangeDate != null) {
            return Hours.hoursBetween(new DateTime(lastPasswordChangeDate), new DateTime());
        }
        return null;
    }

    @Override
    public void resetPasswordAge() {
        this.userAccessor.getUserNamesWithConfluenceAccess().forEach(userName -> {
            UserPreferences preferences = this.userAccessor.getUserPreferences(this.userAccessor.getUserByName(userName));
            preferences.remove("last_password_changed_date_property");
            preferences.remove("last_password_expiration_notification_send_date");
            preferences.remove("last_password_expired_notification_send_date");
        });
    }

    private Integer getMaximumPasswordAge() {
        String maxPassAge = this.passwordPolicyPropertiesService.getPropertyValue("maximumPasswordAge");
        if (maxPassAge != null) {
            return Integer.parseInt(maxPassAge);
        }
        return null;
    }

    @Override
    public List<String> validatePassword(String password) {
        return this.validatePassword(this.getConfiguration(), password, null);
    }

    private PluginConfiguration getConfiguration() {
        return this.pluginConfigurationService.getConfiguration();
    }

    @Override
    public List<String> validatePassword(String password, String username) {
        return this.validatePassword(this.getConfiguration(), password, username);
    }

    @Override
    public PasswordValidator getPasswordValidator() {
        return this.createValidator(this.getConfiguration());
    }

    private PasswordValidator createValidator(PluginConfiguration configuration) {
        List<Rule> ruleList = this.getPasswordRuleList(configuration);
        return new PasswordValidator(this.messageResolver, ruleList);
    }

    private void updateMessageResolver(String username) {
        Properties props = new Properties();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null) {
            this.updateMessageResolverDefault();
            return;
        }
        Locale locale = this.localeManager.getLocale((User)user);
        InputStream is = null;
        try {
            if (locale != null) {
                is = this.getClass().getClassLoader().getResourceAsStream("validationMessages_" + locale.getLanguage() + ".properties");
                if (is == null) {
                    is = this.getClass().getClassLoader().getResourceAsStream("validationMessages.properties");
                }
            } else {
                is = this.getClass().getClassLoader().getResourceAsStream("validationMessages.properties");
            }
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.messageResolver = new PasswordMessageResolver(props);
    }

    private void updateMessageResolverDefault() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("validationMessages.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.messageResolver = new PasswordMessageResolver(props);
    }

    @Override
    public List<PolicyRule> getPasswordRulesHelp(PluginConfiguration configuration, String username) {
        this.updateMessageResolver(username);
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<PolicyRule> rules = new ArrayList<PolicyRule>();
        if (configuration.getPasswordsRemebmeredInHistory() > 0 && this.userPasswordHistoryDAO.hasPreviousPasswords(username)) {
            HistoryRule historyRule = new HistoryRule(this.userPasswordHistoryDAO, username);
            messages.add(this.messageResolver.resolve("HISTORY_RULE", new LinkedHashMap()));
            rules.add(new PolicyRule(historyRule, "HISTORY_RULE", new LinkedHashMap(), this.messageResolver));
        }
        List<Rule> passwordRuleList = this.getPasswordRuleList(configuration);
        for (Rule rule : passwordRuleList) {
            LinkedHashMap<String, Integer> parameters;
            if (rule instanceof LengthRule) {
                LengthRule lengthRule = (LengthRule)rule;
                parameters = new LinkedHashMap<String, Integer>();
                parameters.put("minimumLength", lengthRule.getMinimumLength());
                parameters.put("maximumLength", lengthRule.getMaximumLength());
                messages.add(this.messageResolver.resolve("LENGTH_RULE", parameters));
                rules.add(new PolicyRule(rule, "LENGTH_RULE", parameters, this.messageResolver));
            }
            if (rule instanceof DictionaryRule) {
                DictionaryRule dicRule = (DictionaryRule)rule;
                parameters = new LinkedHashMap();
                rules.add(new PolicyRule(rule, "DICTIONARY_RULE", parameters, this.messageResolver));
            }
            if (!(rule instanceof CharacterCharacteristicsRule)) continue;
            CharacterCharacteristicsRule characterCharacteristicsRule = (CharacterCharacteristicsRule)rule;
            parameters = new LinkedHashMap();
            parameters.put("numberOfCharacteristics", characterCharacteristicsRule.getNumberOfCharacteristics());
            parameters.put("rulesSize", characterCharacteristicsRule.getRules().size());
            messages.add(this.messageResolver.resolve("CHARACTER_CHARACTERISTICS_RULE", parameters));
            rules.add(new PolicyRule(rule, "CHARACTER_CHARACTERISTICS_RULE", parameters, this.messageResolver));
            List<CharacterRule> characterRules = characterCharacteristicsRule.getRules();
            for (CharacterRule characterRule : characterRules) {
                parameters = new LinkedHashMap();
                parameters.put("numberOfCharacters", characterRule.getNumberOfCharacters());
                if (characterRule instanceof DigitCharacterRule) {
                    messages.add(this.messageResolver.resolve("DIGIT_CHARACTER_RULE", parameters));
                    rules.add(new PolicyRule(characterRule, "DIGIT_CHARACTER_RULE", parameters, this.messageResolver));
                }
                if (characterRule instanceof NonAlphanumericCharacterRule) {
                    messages.add(this.messageResolver.resolve("NON_ALPHANUMERIC_CHARACTER_RULE", parameters));
                    rules.add(new PolicyRule(characterRule, "NON_ALPHANUMERIC_CHARACTER_RULE", parameters, this.messageResolver));
                }
                if (characterRule instanceof UppercaseCharacterRule) {
                    messages.add(this.messageResolver.resolve("UPPERCASE_CHARACTER_RULE", parameters));
                    rules.add(new PolicyRule(characterRule, "UPPERCASE_CHARACTER_RULE", parameters, this.messageResolver));
                }
                if (!(characterRule instanceof LowercaseCharacterRule)) continue;
                messages.add(this.messageResolver.resolve("LOWERCASE_CHARACTER_RULE", parameters));
                rules.add(new PolicyRule(characterRule, "LOWERCASE_CHARACTER_RULE", parameters, this.messageResolver));
            }
        }
        return rules;
    }

    private DictionaryRule getDictionaryRule(PluginConfiguration configuration) {
        if (this.userManager.getRemoteUser() == null) {
            return null;
        }
        String username = this.userManager.getRemoteUser().getUsername();
        final List<String> forbiddenPasswords = this.getForbiddenPasswords(username);
        Dictionary dict = new Dictionary(){

            @Override
            public boolean search(String word) {
                if (forbiddenPasswords.contains(word)) {
                    return true;
                }
                for (String forbPass : forbiddenPasswords) {
                    if (!word.contains(forbPass)) continue;
                    return true;
                }
                return false;
            }
        };
        DictionaryRule rule = new DictionaryRule(this, dict){

            @Override
            protected String doWordSearch(String text) {
                if (this.dictionary.search(text)) {
                    if (forbiddenPasswords.contains(text)) {
                        int index = forbiddenPasswords.indexOf(text);
                        return (String)forbiddenPasswords.get(index);
                    }
                    for (String forbPass : forbiddenPasswords) {
                        if (!text.contains(forbPass)) continue;
                        return forbPass;
                    }
                }
                return null;
            }
        };
        return rule;
    }

    private List<String> getForbiddenPasswords(String username) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(username);
        UserAccessor ua = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        ConfluenceUser user = ua.getUserByName(username);
        result.add(user.getKey().toString());
        String displayName = user.getFullName();
        String[] forbPasswords = null;
        if (displayName != null) {
            forbPasswords = displayName.split(" ");
        }
        if (forbPasswords != null) {
            for (String string : forbPasswords) {
                result.add(string);
            }
        }
        return result;
    }

    private List<PolicyRule> getPasswordPolicyRules(String username) {
        if (StringUtils.isBlank((CharSequence)username) && this.userManager.getRemoteUsername() != null) {
            username = this.userManager.getRemoteUsername();
        }
        return this.getPasswordRulesHelp(this.getConfiguration(), username);
    }

    @Override
    public Map<String, Boolean> validatePasswordWithRules(String password, String userName) {
        if (password == null) {
            password = "";
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List<PolicyRule> passwordPolicyRules = this.getPasswordPolicyRules(userName);
        for (PolicyRule policyRule : passwordPolicyRules) {
            boolean passwordValid = policyRule.isPasswordValid(password);
            result.put(policyRule.getKey(), passwordValid);
        }
        return result;
    }

    private List<Rule> getPasswordRuleList(PluginConfiguration configuration) {
        DictionaryRule dictRule;
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (!configuration.getPasswordsLikeNameAllowed().booleanValue() && (dictRule = this.getDictionaryRule(configuration)) != null) {
            ruleList.add(dictRule);
        }
        if (configuration.getMaxPasswordLength() > 0) {
            LengthRule lengthRule = new LengthRule(configuration.getMinPasswordLength(), configuration.getMaxPasswordLength());
            ruleList.add(lengthRule);
        }
        if (configuration.getNumberOfCharacteristics() > 0) {
            CharacterCharacteristicsRule charRule = this.createPasswordCharactersRule(configuration);
            ruleList.add(charRule);
        }
        return ruleList;
    }

    private CharacterCharacteristicsRule createPasswordCharactersRule(PluginConfiguration configuration) {
        CharacterCharacteristicsRule charRule = new CharacterCharacteristicsRule();
        if (configuration.getDigitCharacterRule() > 0) {
            charRule.getRules().add(new DigitCharacterRule(configuration.getDigitCharacterRule()));
        }
        if (configuration.getNonAlphanumericCharacterRule() > 0) {
            charRule.getRules().add(new NonAlphanumericCharacterRule(configuration.getNonAlphanumericCharacterRule()));
        }
        if (configuration.getUppercaseCharacterRule() > 0) {
            charRule.getRules().add(new UppercaseCharacterRule(configuration.getUppercaseCharacterRule()));
        }
        if (configuration.getLowercaseCharacterRule() > 0) {
            charRule.getRules().add(new LowercaseCharacterRule(configuration.getLowercaseCharacterRule()));
        }
        charRule.setNumberOfCharacteristics(configuration.getNumberOfCharacteristics());
        return charRule;
    }

    @Override
    public List<String> validatePassword(PluginConfiguration configuration, String password, String username) {
        PasswordValidator validator = this.createValidator(configuration);
        RuleResult result = validator.validate(new PasswordData(new Password(password)));
        ArrayList<String> messages = new ArrayList<String>();
        if (!result.isValid()) {
            messages.addAll(validator.getMessages(result));
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            if (this.isSameAsCurrentPassword(password, username)) {
                messages.add("Password must be different from current password.");
            }
            if (this.passwordInHistory(configuration, password, username)) {
                messages.add("Password matches one of previous passwords.");
            }
        }
        return messages;
    }

    private boolean isSameAsCurrentPassword(String password, String username) {
        return this.usersUtils.validUserPassword(username, password);
    }

    private boolean passwordInHistory(PluginConfiguration configuration, String password, String username) {
        return configuration.getPasswordsRemebmeredInHistory() > 0 && this.userPasswordHistoryDAO.passwordInHistory(username, password);
    }

    private void updateUserPropertiesAfterPasswordChange(ConfluenceUser user) {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        UserPreferences userPreferences = userAccessor.getUserPreferences(user);
        UserPreferencesUtils.setDate("last_password_changed_date_property", userPreferences, new Date());
        userPreferences.setBoolean("com.intenso.jira.plugins.passpolicy:user_account_unlocked_manually", false);
        userPreferences.remove("last_password_expired_notification_send_date");
        HttpServletRequest request = this.httpContext.getActiveRequest();
        request.getSession().removeAttribute("confluence-passport-policy-filterRedirected-userPasswordExpired");
    }

    @Override
    public void savePasswordToHistory(String username, String password) {
        Integer passwordsRemebmeredInHistory = this.getConfiguration().getPasswordsRemebmeredInHistory();
        this.userPasswordHistoryDAO.save(username, password, passwordsRemebmeredInHistory);
    }

    @Override
    public void userPasswordChanged(ConfluenceUser user, String password) {
        this.savePasswordToHistory(user.getName(), password);
        this.updateUserPropertiesAfterPasswordChange(user);
    }

    @Override
    public void userPasswordChanged(String userName, String password) {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        this.userPasswordChanged(userAccessor.getUserByName(userName), password);
    }

    @Override
    public UserPasswordPolicy createLazyUserPasswordPolicy(ConfluenceUser user, PluginConfiguration configuration) {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        boolean isUserInternal = this.userDirectoryService.isUserInInternalDirectory((User)user);
        return new LazyUserPasswordPolicy(user, userPreferences, configuration, isUserInternal);
    }

    private boolean isUserSystemAdmin(User loggedInUser) {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        return userAccessor.isSuperUser(loggedInUser);
    }

    @Override
    public void saveDistinctPasswordToHistory(String username, String currentPassword) {
        if (!this.isPasswordInHistory(username, currentPassword)) {
            this.savePasswordToHistory(username, currentPassword);
        }
    }

    private boolean isPasswordInHistory(String username, String currentPassword) {
        return this.userPasswordHistoryDAO.passwordInHistory(username, currentPassword);
    }
}

