/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.intenso.confluence.plugins.ao.PassPolicyProp;
import com.intenso.confluence.plugins.ao.PassPolicyPropDAO;
import com.intenso.confluence.plugins.cache.ConfigurationCacheManager;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class PasswordPolicyPropertiesServiceImpl
implements PasswordPolicyPropertiesService {
    private final PassPolicyPropDAO dao;
    private final ConfigurationCacheManager configurationCacheManager;

    @Override
    public List<PassPolicyProp> getAllProperties() {
        return this.dao.getAllProperties();
    }

    @Override
    public PassPolicyProp getProperty(String key) {
        return this.dao.getProperty(key);
    }

    @Override
    public Optional<PassPolicyProp> getOptionalProperty(String key) {
        return Optional.ofNullable(this.dao.getProperty(key));
    }

    @Override
    public String getPropertyValue(String key) {
        return this.configurationCacheManager.getPropertyValue(key).orElse(null);
    }

    @Override
    public void setPropertyValue(String key, String value) {
        this.dao.setPropertyValue(key, value);
        this.configurationCacheManager.savePropertyValue(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.dao.removeProperty(key);
        this.configurationCacheManager.removePropertyValue(key);
    }

    @Generated
    public PasswordPolicyPropertiesServiceImpl(PassPolicyPropDAO dao, ConfigurationCacheManager configurationCacheManager) {
        this.dao = dao;
        this.configurationCacheManager = configurationCacheManager;
    }
}

