/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.service.PasswordExpirationService;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import org.springframework.stereotype.Component;

@Component
public class PasswordExpirationServiceImpl
implements PasswordExpirationService {
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private final PermissionManager permissionManager;

    public PasswordExpirationServiceImpl(UserManager userManager, UserAccessor userAccessor, PasswordPolicyPropertiesService passwordPolicyPropertiesService, PermissionManager permissionManager) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
        this.permissionManager = permissionManager;
    }

    @Override
    public void setExpirationPolicyEnabledForUser(String username, boolean enabled) {
        ConfluenceUser user;
        ConfluenceUser loggedInUser = this.userAccessor.getUserByKey(this.userManager.getRemoteUserKey());
        if (this.isConfluenceAdmin(loggedInUser) && (user = this.userAccessor.getUserByName(username)) != null) {
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            preferences.setBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled", enabled);
        }
    }

    @Override
    public boolean isExpirationPolicyEnabled(ConfluenceUser user) {
        UserPreferences preferences = this.userAccessor.getUserPreferences(user);
        return preferences.getBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled").orElse(false);
    }

    @Override
    public boolean isExpirationPolicyGloballyEnabled(ConfluenceUser user) {
        for (String groupName : this.userAccessor.getGroupNames((User)user)) {
            if (this.isExpirationPolicyEnabled(groupName)) continue;
            return false;
        }
        return this.isExpirationPolicyEnabled(user);
    }

    @Override
    public void update(Group group, Boolean expitarionPolicyEnabled) {
        this.update(group.getName(), expitarionPolicyEnabled);
    }

    @Override
    public void update(String groupName, Boolean expitarionPolicyEnabled) {
        this.passwordPolicyPropertiesService.setPropertyValue(groupName, expitarionPolicyEnabled.toString());
    }

    @Override
    public boolean isExpirationPolicyEnabled(Group group) {
        return this.isExpirationPolicyEnabled(group.getName());
    }

    @Override
    public boolean isExpirationPolicyEnabled(String groupName) {
        if (this.passwordPolicyPropertiesService.getProperty(groupName) == null) {
            return true;
        }
        String result = this.passwordPolicyPropertiesService.getPropertyValue(groupName);
        return Boolean.parseBoolean(result);
    }

    private boolean isConfluenceAdmin(ConfluenceUser loggedInUser) {
        return this.permissionManager.isConfluenceAdministrator(loggedInUser);
    }
}

